/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua;

import java.io.File;
import java.io.IOException;
import java.net.*;
import java.util.Vector;
import java.io.BufferedOutputStream;
import java.io.PipedInputStream;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

import org.apache.log4j.Logger;

/*
 * sends audio to skype client
 */

public class SkypeAudioSenderServer extends Thread 
{
    private Vector<String> skypeClipQueue=new Vector<String>();
    private AudioInputStream skypeClipStream=null;
    
    private boolean stopnow=false;
    
    private Logger log = null;
    
    private static final int PIPEBUFFER_SIZE=65536;
    private static final int maxBehindBytes=PIPEBUFFER_SIZE-5000;

    
    private SkypeUserAgent ua=null;
    
    private boolean haltNow=false;
    
    
    private boolean sipSentData=false;
    private boolean sipConnected=false;
    
	private ServerSocket listener;
	
	private static final int pcmBytesPerMs=32;
    
    private PipedInputStreamPCM sipInputStream = new PipedInputStreamPCM(PIPEBUFFER_SIZE);
    
	public SkypeAudioSenderServer(SkypeUserAgent argUa) throws Exception
	{
		this.setName(this.getClass().getName()+".T"+this.getName().replaceAll("Thread-", ""));
		log = Logger.getLogger(this.getName());
		this.ua=argUa;
	}

	public PipedInputStream getPipedInPutStream()
	{
		return sipInputStream;
	}
	
	public void queueSkypeClip(String argClipFile)
	{
		log.debug("Play Clip:"+argClipFile);
		skypeClipQueue.add(argClipFile);
	}
	
	/*
	 * stops any clips and clears the queue
	 */
	public void stopSkypeClips()
	{
		skypeClipQueue.removeAllElements();
		if (skypeClipStream!=null)
		{
			try
			{
				skypeClipStream.close();
			}
			catch(Exception e)
			{
			}
			skypeClipStream=null;
		}
		
	}
	
	public boolean areClipsComplete()
	{
		if (skypeClipQueue.size()==0 && skypeClipStream==null)
			return true;
		else
			return false;
	}
	
	
	public void stopMedia()
	{
		stopnow=true;
	}
	
	public void halt()
	{
		haltNow=true;
		try
		{
		 listener.close();
		}
		catch (Exception e)
		{}

	}
	
	public void setSipConnected()
	{
		sipConnected=true;
	}
	
	
	public synchronized void sipSentData()
	{
		sipSentData=true;
		this.notify();
	}
	
	public void interrupt()
	{
		stopnow=true;
		super.interrupt();
	}
	
	
	  public void run() 
	  {
	  	try 
	  	{
	      
	      listener = new ServerSocket(ua.skypeInPort);
	      
	      while (!haltNow)
	      {	
	    	  Socket skypeSocket = listener.accept();
	          handleConnection(skypeSocket);
	          skypeSocket.close();
	      }
	      
	    } 
	  	catch (IOException ioe) 
	    {
	      if (!haltNow)	
	    	  log.error("error",ioe);
	    }
	  }
	
	
	public void handleConnection(Socket skypeSocket)
	{
				if (ua.skype_profile.audioPriorityIncrease>0)
				{
					try
					{
					this.setPriority(Thread.NORM_PRIORITY+ua.skype_profile.audioPriorityIncrease);
					}
					catch (Exception e)
					{
						log.warn("setPriority Error. ",e);
					}
				}

		
				stopnow=false;
				byte[] buffer=new byte[PIPEBUFFER_SIZE];
		      	int availBytes=0;
		      	int numRead=0;
				long pcmBufferBytesReceived=0;
				long pcmPacketCounter=0;
		      	int bufferCeiling=0;
		      	long choppedCnt=0;
				long underRunsCnt=0;
				long ioErrors=0;
				int skypeSendMillis=10;
				int minRxSize=pcmBytesPerMs*skypeSendMillis;
				BufferedOutputStream skypeSockout=null;

				try
				{
			      skypeSocket.setSoLinger(false, 500);
			      skypeSocket.setTcpNoDelay(true);
			      skypeSocket.setKeepAlive(false);
		      	  skypeSockout=new BufferedOutputStream(skypeSocket.getOutputStream(),80*pcmBytesPerMs);
  		      	  sipInputStream.clearBuffer();
				}
				catch (IOException e)
				{
					log.fatal("error",e);
					this.ua.hangup();
					stopnow=true;
				}
				
        		if (this.ua.skype_profile.TcpTxBufferSize>0)
        		{	
        			try
        			{
						skypeSocket.setSendBufferSize(this.ua.skype_profile.TcpTxBufferSize);
						int tstTx=skypeSocket.getSendBufferSize();
						if (tstTx!=this.ua.skype_profile.TcpTxBufferSize)
						{
							log.warn("error setting TCPSendBufferSize");
						}
        			}
        			catch (SocketException e)
        			{
						log.warn("error setting TCPSendBufferSize",e);
        			}
        		}

				
			    log.debug("+++ skypeAudioSender connected to port:"+ua.skypeInPort);
				
				while (!stopnow)
				{
							
					if (skypeClipStream!=null)
					{
								//playing a clip
								int clipRead=-1;
								try
								{
						    	  clipRead=skypeClipStream.read(buffer,0,640); // 20 ms
								}
							    catch(Exception e)
							    {log.error("error",e);}
							    
							    if (clipRead>0)
							    {
							        try
							        {
								       skypeSockout.write(buffer,0,clipRead);
								    }
									catch(IOException e)
									{
										log.error("error",e);
									}
								    try	{sleep(20);} catch (Exception ew4){}
								}
								else
								{
									log.debug("--- clip Closed");
									try
								    {
										skypeClipStream.close();
								    }
								    catch(Exception e)
								    {}	
								    skypeClipStream=null;

								    if (skypeClipQueue.size()==0 && sipConnected)
								    {
								    	try
								    	{
								    	  sipInputStream.clearBuffer();
								    	}
								    	catch(Exception e){}
								    }
								    
								}
					}
					else if (skypeClipQueue.size()>0)
					{
						skypeClipStream=getNextClipStream();
					}					  
					else if (sipConnected)
				    {	 
						   
						   synchronized (this)
							{
								try
								{
								  if (!sipSentData)	// in case we get notfied when we are out of this section
									wait(100); // wait for a notify or timeout
								  //else
								//	yield();

								  sipSentData=false;
								}
								catch(InterruptedException e)
								{
									log.error("Interrupted",e);
								}
							}
							
							try
							{
								availBytes=sipInputStream.available();
							}
							catch(IOException e)
							{
								log.error("pipe ioerror",e);
							}
						    
						    //log.info("sass availBytes="+availBytes);
							    
						    if (availBytes>=minRxSize)
						    {	
						    	pcmBufferBytesReceived+=availBytes;
								pcmPacketCounter++;

								if (availBytes>=maxBehindBytes)
								{
									try
									{
									  sipInputStream.chopBuffer((int)(maxBehindBytes*.9));
					            	  availBytes=sipInputStream.available();
									}
									catch (IOException e){}
									choppedCnt++;
								}

								//if (pcmPacketCounter%10==0)
								//	log.info("s "+(int)((availBytes-minRxSize)/pcmBytesPerMs));

						    	if (availBytes>bufferCeiling)
									bufferCeiling=availBytes;
						    	
						    	try
								{
						    		numRead=sipInputStream.read(buffer,0,availBytes);
									skypeSockout.write(buffer,0,numRead);
								}
								catch(IOException e)
								{
									ioErrors++;
								}
							}    
							else if (!this.ua.onRemoteSipHold && pcmPacketCounter>5 && !stopnow)
							{	
							    // not enough data received and not on hold and received at least 5 packets
								underRunsCnt++;
								//log.info("su");
							}    
							    
					    }   
						else
						{
							// idle
							try	{sleep(20);} catch (Exception ew2){}
						}
				}
	
				//it's time to shutdown
				stopSkypeClips();
				
				try
				{
					skypeSockout.close();
					sipInputStream.clearBuffer();
				}
				catch(IOException e){}
				
				if (ua.skype_profile.audioPriorityIncrease>0)
				{
					try
					{
					this.setPriority(Thread.NORM_PRIORITY);
					}
					catch (Exception e)
					{
						log.warn("resetPriority Error. ",e);
					}
				}

		    	sipConnected=false;
				stopnow=false;
				
				//bufferCeiling-=minRxSize;
				int maxLatency=(bufferCeiling/pcmBytesPerMs);
				if (maxLatency<0)
					maxLatency=0;

				//pcmBufferBytesReceived-=(minRxSize*pcmPacketCounter);
				int avgLatency=0;
				if (pcmPacketCounter>0)
					avgLatency=(int)(pcmBufferBytesReceived/pcmPacketCounter/pcmBytesPerMs);
				
				String msg="SkypeAudioSender stats - packets:"+pcmPacketCounter;
				if (choppedCnt>0)
					msg+=" chopCnt:"+choppedCnt;
				if (underRunsCnt>0)
					msg+=" underRuns:"+underRunsCnt;
				if (ioErrors>0)
					msg+=" IOErrors:"+ioErrors;
				msg+=" maxLatency:"+maxLatency+"ms avgLatency:"+avgLatency+"ms";
				log.info(msg);

	}

	
	/*
	 * gets the next clip from the clip queue
	 */
	private AudioInputStream getNextClipStream()
	{
	   AudioInputStream retvar=null;
	   while (skypeClipQueue.size()>0 && retvar==null)
	   {	   
		   String clipFile=skypeClipQueue.get(0);
		   skypeClipQueue.remove(0);
		   try
		   {
			 log.debug("clipFormat="+AudioSystem.getAudioFileFormat(new File(clipFile)).toString());
			 
			 AudioFormat format=new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0F, 16, 1, 2, 16000.0F, false);
			 AudioInputStream srcStream=AudioSystem.getAudioInputStream(new File(clipFile));
		     retvar=AudioSystem.getAudioInputStream(format, srcStream);
		     log.debug("+++ clip "+clipFile+" Opened");
		   }
		   catch (Exception e)
		   {
			   log.error("File "+clipFile+" Error - Msg:",e);
		   }
	   }
	   return retvar;
	}
	

}
