/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua;
import org.zoolu.tools.Configure;
import org.zoolu.tools.Parser;
import java.util.Hashtable;
	
	/*
	 * 
	 * Skype specific profile settings
	 */

	public class SkypeProfile extends Configure
	{
	   // ********************** user configurations *********************

	   private Hashtable<String,String> paramCheck=new Hashtable<String,String>(); 	
	   public int SkypeAudioPortBase=64432;

	   public double[] SkypeAudioOutGain={1};
	   public double[] SkypeAudioInGain={1};
	   
	   public boolean connect=true;
	   public boolean skypeAPITrace=false;
	   public String SipToSkypeAuthFile="SipToSkypeAuth.props";
	   public String SkypeToSipAuthFile="SkypeToSipAuth.props";

	   public String pinFile="clips/enterPin.wav";
	   public String destinationFile="clips/enterDest.wav";
	   public String dialingFile="clips/dialing.wav";
	   public String invalidPinFile="clips/invalidPin.wav";
	   public String invalidDestFile="clips/invalidDest.wav";


	   public String skypePinFile="clips/enterPin.wav";
	   public String skypeDestinationFile="clips/enterDest.wav";
	   public String skypeDialingFile="clips/dialing.wav";
	   public String skypeInvalidPinFile="clips/invalidPin.wav";
	   public String skypeInvalidDestFile="clips/invalidDest.wav";
	   
	   public int pinTimeout=8;
	   public int destinationTimeout=12;
	   public int pinRetryLimit=3;
	   public int destRetryLimit=3;
	   public boolean handleEarlyMedia=false;
	   public boolean sendSkypeIM=false;
	   public int sendSkypeImDelay=1;
	   public String skypeImMessage="You are about to receive a Skype Voice call from [callerid].";

	   public int autoShutdownMinutes=0;
	   public boolean enableSkypeDtmfDetector=false;
	   public boolean skypeClientSupportsMultiCalls=false;
	   
	   public String SkypeInboundAllChannelsBusyAction="REFUSE";
	   public String SkypeOutDialingRulesFile="SkypeOutDialingRules.props";
	   public boolean sendSipDtmfToSkype=false;
	   public boolean sendSkypeDtmfToSip=false;
	   
	   public int SkypeDtmfDetectorHitThreshold=30;
	   public int SkypeDtmfDetectorSilenceThreshold=6;
	   public boolean enableSIPInbandDtmfDetector=false;
	   public int SipDtmfDetectorHitThreshold=30;
	   public int SipDtmfDetectorSilenceThreshold=6;
	   public String SipOutDialingRulesFile="SipOutDialingRules.props";
	   
	   public int audioPriorityIncrease=0;
	   public boolean enableSendRTPtoReceivedAddress=false;
	   public int lockRtpSendAddressAfterPackets=1;
	   public int noRtpReceivedAutoHangupSeconds=30;
	   
	   public int baseFailureResponse=403;
	   public int skypeRefusedResponse=603;
	   public int skypeFailedResponse=404;
	   public int skypeUnPlacedResponse=408;
	   public int skypeBusyResponse=600;
	   
	   public int jitterLevel=0; // 0=disable,1=small,2=medium,3=large
	   
	   public int configWatchInterval=0;
	   
	   public int TcpRxBufferSize=0;
	   public int TcpTxBufferSize=0;
	   public int RtpRxBufferSize=0;
	   public int RtpTxBufferSize=0;
	   
	   public String skypeInboundSipDestUnavailableAction="hangup";
	   
	   public boolean JoinManualSkypeOutboundCallToSip=false;
	   public boolean inbandFullTimeDtmfDetection=false;
	   public String[] filterParams={"NONE"};
	   public boolean forceChannelBusy=false;
	   public String skypeUserId=null;
	   public int connectorWatchDogMinutes=0;
	   public double connectionFee=0;
	   public boolean sendSkypeEarlyMediaOverSipSessionProgress=false;
	   
	   public int maxCallTimeLimitMinutes=0;
	   public int warnMinutesBeforeCutoff=0;
	   public String overLimitWarningFile="clips/overlimit.wav";
	   public int overUsageLimitSipResponse=480;
	   public String callLogPath="log/";
	   public int dailyPstnLimitMinutes=0;
	   public int dailyPstnUniqueNumberLimit=0;
	   public int refuseNewPstnCallsWhenRemainingMinutesUnder=0;
	   public int MaxPstnCallTimeLimitMinutes=0;
	   public boolean loadSkypeClientCallHistory=false;
	   public String tollFreeNumberPrefixes="";
	   public boolean runConnectorReliabilityTest=false;
	   public boolean replaceFromWithSkypeId=false;

	   
	   public double emailWhenBalanceDropsTo=-1;
	   public String emailHost=null;
	   public int emailPort=25;
	   public String emailUsername=null;
	   public String emailPassword=null;
	   public String emailRecipients=null;
	   public String emailFrom=null;
	   public boolean emailTest=false;
	   
	   // ************************** Constructors *************************
	   
	   /** Costructs a void Profile */
	   public SkypeProfile()
	   {  init();
	   }

	   /** Costructs a new Profile */
	   public SkypeProfile(String file)
	   {  // load configuration
	      if (!loadFile(file))
	    	  System.exit(SkypeUA.ExitCode.CONFIGERROR.code());
	      // post-load manipulation     
	      init();
	   }

	   /** Inits the Profile */
	   private void init()
	   {  
		   paramCheck=null;
	   }  


	   // ************************ Public methods ************************

	   // *********************** Protected methods **********************

	   /** Parses a single line (loaded from the config file) */
	   protected void parseLine(String line)
	   {  
		  String attribute;
	      Parser par;
	      int index=line.indexOf("=");
	      if (index>0) 
	      {  
	    	  attribute=line.substring(0,index).trim(); 
	          par=new Parser(line,index+1);  
	      }
	      else 
	      {  
	    	  attribute=line; 
	    	  par=new Parser("");  
	      }
	      attribute=attribute.toLowerCase();
	      
	      if (paramCheck.containsKey(attribute))
	      {
	    	  System.out.println("### Warning: Duplicate Parameter: "+attribute);
	      }
	      else
	    	  paramCheck.put(attribute, "");
	      
	      
	      
	      if (attribute.equals("skype_audioportbase"))   { SkypeAudioPortBase=par.getInt(); return; }
	      if (attribute.equals("skype_connect"))  
	      { 
	    	  if (par.getRemainingString().toLowerCase().startsWith("n"))
	    		  connect=false;
	    	  else
	    		  connect=true;
	    	  return; 
	      }
	      if (attribute.equals("siptoskypeauthfile"))  { SipToSkypeAuthFile=par.getRemainingString(); return; }
	      if (attribute.equals("skypetosipauthfile"))  { SkypeToSipAuthFile=par.getRemainingString(); return; }
	      
	      
	      if (attribute.equals("pintimeout"))   { pinTimeout=par.getInt(); return; }
	      if (attribute.equals("destinationtimeout"))   { destinationTimeout=par.getInt(); return; }

	      if (attribute.equals("pinretrylimit"))   { pinRetryLimit=par.getInt(); return; }
	      if (attribute.equals("destinationretrylimit"))   { destRetryLimit=par.getInt(); return; }

	      if (attribute.equals("pinfile"))  { pinFile=par.getRemainingString(); return; }
	      if (attribute.equals("destinationfile"))  { destinationFile=par.getRemainingString(); return; }
	      if (attribute.equals("dialingfile"))  { dialingFile=par.getRemainingString(); return; }
	      if (attribute.equals("invalidpinfile"))  { invalidPinFile=par.getRemainingString(); return; }
	      if (attribute.equals("invaliddestfile"))  { invalidDestFile=par.getRemainingString(); return; }

	      if (attribute.equals("skypepinfile"))  { skypePinFile=par.getRemainingString(); return; }
	      if (attribute.equals("skypedestinationfile"))  { skypeDestinationFile=par.getRemainingString(); return; }
	      if (attribute.equals("skypedialingfile"))  { skypeDialingFile=par.getRemainingString(); return; }
	      if (attribute.equals("skypeinvalidpinfile"))  { skypeInvalidPinFile=par.getRemainingString(); return; }
	      if (attribute.equals("skypeinvaliddestfile"))  { skypeInvalidDestFile=par.getRemainingString(); return; }
	   
	      if (attribute.equals("handleearlymedia"))  
	      { 
	    	  if (par.getRemainingString().toLowerCase().startsWith("y"))
	    		  handleEarlyMedia=true;
	    	  else
	    		  handleEarlyMedia=false;
	    	  return; 
	      }
	      
	      if (attribute.equals("sendskypeim"))  
	      { 
	    	  if (par.getRemainingString().toLowerCase().startsWith("y"))
	    		 sendSkypeIM=true;
	    	  else
	    		 sendSkypeIM=false;
	    	  return; 
	      }
	      
	      if (attribute.equals("skypeimmessage"))  { skypeImMessage=par.getRemainingString(); return; }
	      
	      if (attribute.equals("autoshutdownminutes"))   { autoShutdownMinutes=par.getInt(); return; }
	      
	      if (attribute.equals("enableskypedtmfdetector"))  
	      { 
	    	  if (par.getRemainingString().toLowerCase().startsWith("y"))
	    		  enableSkypeDtmfDetector=true;
	    	  else
	    		  enableSkypeDtmfDetector=false;
	    	  return; 
	      }
	   
	      if (attribute.equals("skypedtmfdetectorhitthreshold"))   {SkypeDtmfDetectorHitThreshold=par.getInt(); return; }
	      if (attribute.equals("skypedtmfdetectorsilencethreshold"))   { SkypeDtmfDetectorSilenceThreshold=par.getInt(); return; }
	      

	      if (attribute.equals("skypeclientsupportsmulticalls"))  
	      { 
	    	  if (par.getRemainingString().toLowerCase().startsWith("y"))
	    		  skypeClientSupportsMultiCalls=true;
	    	  else
	    		  skypeClientSupportsMultiCalls=false;
	    	  return; 
	      }
	   

	      if (attribute.equals("sendsipdtmftoskype"))  
	      { 
	    	  if (par.getRemainingString().toLowerCase().startsWith("y"))
	    		  sendSipDtmfToSkype=true;
	    	  else
	    		  sendSipDtmfToSkype=false;
	    	  return; 
	      }

	      if (attribute.equals("sendskypedtmftosip"))  
	      { 
	    	  if (par.getRemainingString().toLowerCase().startsWith("y"))
	    		  sendSkypeDtmfToSip=true;
	    	  else
	    		  sendSkypeDtmfToSip=false;
	    	  return; 
	      }
	      
	      
	      if (attribute.equals("skypeinboundallchannelsbusyaction"))  { SkypeInboundAllChannelsBusyAction=par.getRemainingString().toLowerCase(); return; }
	      	   
	      if (attribute.equals("skypeoutdialingrulesfile"))  {SkypeOutDialingRulesFile=par.getRemainingString(); return; }
	      
	      
	      if (attribute.equals("enablesipinbanddtmfdetector"))  
	      { 
	    	  if (par.getRemainingString().toLowerCase().startsWith("y"))
	    		  enableSIPInbandDtmfDetector=true;
	    	  else
	    		  enableSIPInbandDtmfDetector=false;
	    	  return; 
	      }
	      if (attribute.equals("sipdtmfdetectorhitthreshold"))   {SipDtmfDetectorHitThreshold =par.getInt(); return; }
	      if (attribute.equals("sipdtmfdetectorsilencethreshold"))   { SipDtmfDetectorSilenceThreshold=par.getInt(); return; }
	      
	      if (attribute.equals("sipoutdialingrulesfile"))  {SipOutDialingRulesFile=par.getRemainingString(); return; }
	      
	      
	      if (attribute.equalsIgnoreCase("skypeUserId"))  {skypeUserId=par.getRemainingString(); return; }
	      
	      
	      if (attribute.equals("audiopriorityincrease"))   {audioPriorityIncrease =par.getInt(); return; }
	      
	      if (attribute.equals("enablesendrtptoreceivedaddress"))  
	      { 
	    	  if (par.getRemainingString().toLowerCase().startsWith("y"))
	    		  enableSendRTPtoReceivedAddress=true;
	    	  else
	    		  enableSendRTPtoReceivedAddress=false;
	    	  return; 
	      }
	    
	      if (attribute.equals("lockrtpsendaddressafterpackets"))   {lockRtpSendAddressAfterPackets =par.getInt(); return; }
	      
	      
	      
	      if (attribute.equals("nortpreceivedautohangupseconds"))   {noRtpReceivedAutoHangupSeconds =par.getInt(); return; }
	      
	      if (attribute.equals("skype_audiooutgain"))  { SkypeAudioOutGain=makeDoubleArray(par.getString().split(",")); return; }
	      if (attribute.equals("skype_audioingain"))  { SkypeAudioInGain=makeDoubleArray(par.getString().split(",")); return; }
	    
	      
	      if (attribute.equals("basefailureresponse"))   {baseFailureResponse =par.getInt(); return; }

	      if (attribute.equals("skyperefusedresponse"))   {skypeRefusedResponse =par.getInt(); return; }

	      if (attribute.equals("skypefailedresponse"))   {skypeFailedResponse =par.getInt(); return; }
	      if (attribute.equals("skypeunplacedresponse"))   {skypeUnPlacedResponse =par.getInt(); return; }
	      if (attribute.equals("skypebusyresponse"))   {skypeBusyResponse =par.getInt(); return; }
	    
	      
	      if (attribute.equals("configwatchinterval"))   {configWatchInterval =par.getInt(); return; }
	      if (attribute.equals("jitterlevel"))   {jitterLevel =par.getInt(); return; }
	      
	      if (attribute.equalsIgnoreCase("TcpRxBufferSize"))   {TcpRxBufferSize =par.getInt(); return; }
	      if (attribute.equalsIgnoreCase("TcpTxBufferSize"))   {TcpTxBufferSize =par.getInt(); return; }
	      if (attribute.equalsIgnoreCase("RtpRxBufferSize"))   {RtpRxBufferSize =par.getInt(); return; }
	      if (attribute.equalsIgnoreCase("RtpTxBufferSize"))   {RtpTxBufferSize =par.getInt(); return; }
	      
	      
	      if (attribute.equalsIgnoreCase("sendSkypeImDelay"))   {sendSkypeImDelay =par.getInt(); return; }
	      
	      if (attribute.equalsIgnoreCase("SkypeInboundSipDestUnavailableAction"))   {skypeInboundSipDestUnavailableAction =par.getRemainingString().toLowerCase(); return; }
	      
	      
	      if (attribute.equalsIgnoreCase("JoinManualSkypeOutboundCallToSip"))  {JoinManualSkypeOutboundCallToSip= par.getRemainingString().startsWith("y");return; }
	      
	      if (attribute.equalsIgnoreCase("inbandFullTimeDtmfDetection"))  
	      { 
	    	  inbandFullTimeDtmfDetection= (par.getRemainingString().toLowerCase().startsWith("y"));
	    	  return; 
	      }
	      
	      if (attribute.equalsIgnoreCase("FilterParams"))  
	      { 
	    	  filterParams=(par.getString().split(","));
	    	  return; 
	      }
	      
	      if (attribute.equalsIgnoreCase("forceChannelBusy"))  
	      { 
	    	  forceChannelBusy= (par.getRemainingString().toLowerCase().startsWith("y"));
	    	  return; 
	      }
	      
	      if (attribute.equalsIgnoreCase("sendSkypeEarlyMediaOverSipSessionProgress"))  
	      { 
	    	  sendSkypeEarlyMediaOverSipSessionProgress= (par.getRemainingString().toLowerCase().startsWith("y"));
	    	  return; 
	      }
	      
	      if (attribute.equalsIgnoreCase("connectorWatchDogMinutes"))   {connectorWatchDogMinutes =par.getInt(); return; }
	      if (attribute.equalsIgnoreCase("connectionFee"))   {connectionFee =par.getDouble(); return; }
	      
	      
	      if (attribute.equalsIgnoreCase("MaxCallTimeLimitMinutes"))   {maxCallTimeLimitMinutes =par.getInt(); return; }
	      if (attribute.equalsIgnoreCase("WarnMinutesBeforeCutoff"))   {warnMinutesBeforeCutoff =par.getInt(); return; }
	      if (attribute.equalsIgnoreCase("OverLimitWarningFile"))   {overLimitWarningFile =par.getRemainingString(); return; }
	      if (attribute.equalsIgnoreCase("callLogPath"))   {callLogPath =par.getRemainingString(); return; }
	      if (attribute.equalsIgnoreCase("overUsageLimitSipResponse"))   {overUsageLimitSipResponse =par.getInt(); return; }
	      if (attribute.equalsIgnoreCase("dailyPstnLimitMinutes"))   {dailyPstnLimitMinutes =par.getInt(); return; }
	      if (attribute.equalsIgnoreCase("dailyPstnUniqueNumberLimit"))   {dailyPstnUniqueNumberLimit =par.getInt(); return; }
	      if (attribute.equalsIgnoreCase("refuseNewPstnCallsWhenRemainingMinutesUnder"))   {refuseNewPstnCallsWhenRemainingMinutesUnder =par.getInt(); return; }
	      if (attribute.equalsIgnoreCase("MaxPstnCallTimeLimitMinutes"))   {MaxPstnCallTimeLimitMinutes =par.getInt(); return; }
	   
	      if (attribute.equalsIgnoreCase("loadSkypeClientCallHistory"))  
	      { 
	    	  loadSkypeClientCallHistory= (par.getRemainingString().toLowerCase().startsWith("y"));
	    	  return; 
	      }
	      if (attribute.equalsIgnoreCase("tollFreeNumberPrefixes"))   {tollFreeNumberPrefixes =par.getRemainingString().trim(); return; }
	      
	      
	      if (attribute.equalsIgnoreCase("skypeAPITrace"))  
	      { 
	    	  skypeAPITrace= (par.getRemainingString().toLowerCase().startsWith("y"));
	    	  return; 
	      }
	      
	      if (attribute.equalsIgnoreCase("runConnectorReliabilityTest"))  
	      { 
	    	  runConnectorReliabilityTest= (par.getRemainingString().toLowerCase().startsWith("y"));
	    	  return; 
	      }
	      
	      
	      if (attribute.equalsIgnoreCase("replaceFromWithSkypeId"))  
	      { 
	    	  replaceFromWithSkypeId= (par.getRemainingString().toLowerCase().startsWith("y"));
	    	  return; 
	      }
	      
	      
	      if (attribute.equalsIgnoreCase("emailHost"))   {emailHost =par.getRemainingString().trim(); return; }
	      if (attribute.equalsIgnoreCase("emailUsername"))   {emailUsername =par.getRemainingString().trim(); return; }
	      if (attribute.equalsIgnoreCase("emailPassword"))   {emailPassword =par.getRemainingString().trim(); return; }
	      if (attribute.equalsIgnoreCase("emailRecipients"))   {emailRecipients =par.getRemainingString().trim(); return; }
	      if (attribute.equalsIgnoreCase("emailFrom"))   {emailFrom =par.getRemainingString().trim(); return; }
	      if (attribute.equalsIgnoreCase("emailWhenBalanceDropsTo"))   {emailWhenBalanceDropsTo =par.getDouble(); return; }
	      if (attribute.equalsIgnoreCase("emailPort"))   {emailPort =par.getInt(); return; }
	      if (attribute.equalsIgnoreCase("emailTest"))  
	      { 
	    	  emailTest= (par.getRemainingString().toLowerCase().startsWith("y"));
	    	  return; 
	      }
	      
	   }


	   /** Converts the entire object into lines (to be saved into the config file) */
	   protected String toLines()
	   {  // currently not implemented..
	      return "";
	   }
	  
	   
	   private double[] makeDoubleArray(String[] strArray)
	   {
		   double[] dblArray=new double[strArray.length];
		   
		   for (int s=0;s<strArray.length;s++)
			   dblArray[s]=Double.parseDouble(strArray[s]);
		   
		   return dblArray;
	   }
	  
	   private float[] makeFloatArray(String[] strArray)
	   {
		   float[] array=new float[strArray.length];
		   
		   for (int s=0;s<strArray.length;s++)
			   array[s]=Float.parseFloat(strArray[s]);
		   
		   return array;
	   }
}
