/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua;

import local.ua.sscodecs.SSCodec;
import local.ua.sscodecs.SSCodecFactory;


import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.zoolu.sdp.MediaDescriptor;
import org.zoolu.sdp.AttributeField;
import org.zoolu.sdp.SessionDescriptor;
import org.zoolu.sip.provider.SipProvider;
import org.zoolu.tools.Parser;
import java.io.IOException;

public class SkypeUserAgent extends UserAgent
{
		SkypeRtpReceiver skypeRtpReceiver=null;
		SkypeRtpSender skypeRtpSender=null;
		private String skypeDtmfBuffer="";
	
		protected SkypeProfile skype_profile=null;
		protected int skypeInPort;
		protected int skypeOutPort;
		protected boolean skypeHoldingLocal=false;
		protected boolean skypeHoldingRemote=false;
		private SSCodec sscodec=null;

		DatagramSocket rtpSocket=null;
	    
		/** Costructs a UA with a default media port */
	   public SkypeUserAgent(SipProvider sip_provider, UserAgentProfile user_profile, UserAgentListener listener,SkypeProfile skype_profile,int argRtpPort,int argSkypePort,int chanId) throws Exception
	   {  
		  super(sip_provider,user_profile,listener,argRtpPort);
		  log=Logger.getLogger(this.getClass().getName()+".#C"+chanId);

		  this.skypeInPort=argSkypePort;
		  this.skypeOutPort=argSkypePort+1;
		  
		  this.skype_profile=skype_profile;
		  

		  if (!openRtpSocket())
		  {
			  throw new IOException("RTP Socket create error.");
		  }
         
		  
		  this.skypeRtpSender=new SkypeRtpSender(this);

		  this.skypeRtpReceiver=new SkypeRtpReceiver(this);
	      
		  this.skypeRtpSender.start(); 
		  this.skypeRtpReceiver.start(); 

		  clip_on=null;
          clip_off=null;
          clip_ring=null;

	   } 
	   
	   public void listen()
	   {   
		   skypeHoldingLocal=false;
		   skypeHoldingRemote=false;
		   clearSkypeDtmfBuffer();
		   super.listen();
	   }

	   
	   public void stopMedia()
	   {
		   skypeRtpSender.stopMedia();
		   skypeRtpReceiver.stopMedia();
	   }
	   
	   public void startSkypeMedia(boolean sendSkypeOverSipSessionProgress) throws Exception
	   {
		   if (!sendSkypeOverSipSessionProgress) // false either means no sip session progress (183) or call accepted (200)
			   skypeRtpReceiver.startSkypeMedia();   
		   
		   skypeRtpSender.startSkypeMedia();   
		   if (sendSkypeOverSipSessionProgress)
		   {
			   log.info("Sending Skype Early Media to SIP device");
			   launchMediaApplication();
		   }	   
	   }
	   
	   // sip clips
	   public void queueSipClip(String clipFile)
	   {
		   this.skypeRtpSender.queueSipClip(clipFile);
	   }
	   boolean getSipClipQueueComplete()
	   {
		   return this.skypeRtpSender.areClipsComplete();
	   }

	   // sip send dtmf
	   public void queueSipDtmfDigits(String digits)
	   {
		   skypeRtpSender.queueSipDtmfDigits(digits);
	   }

	   // skype clips
	   public void queueSkypeClip(String clipFile)
	   {
		   this.skypeRtpReceiver.skypeSender.queueSkypeClip(clipFile);
	   }

	   // skype receive dtmf
	   public void clearSkypeDtmfBuffer()
	   {
		   this.skypeDtmfBuffer="";
	   }
	   
	   public boolean getSkypeClipQueueComplete()
	   {
		   return this.skypeRtpReceiver.skypeSender.areClipsComplete();
	   }

	   public void chopSkypeDtmfBuffer(int bytes)
	   {
		   if (bytes<this.skypeDtmfBuffer.length())
			   this.skypeDtmfBuffer=this.skypeDtmfBuffer.substring(bytes);
		   else
			   this.skypeDtmfBuffer="";
	   }	   
	   
	   public void gotSkypeDtmfDigit(int digit)
	   {
    	  this.skypeDtmfBuffer+=dtmfConvertToString(digit);
		  listener.onDtmfReceived(this, digit,true);
	   }
	   
	   public String dtmfConvertToString(int digit)
	   {
		     String retvar="";
		     if (digit<10)
		    	 retvar=String.valueOf(digit);
		      else if (digit==10)
		    	  retvar="*";
		      else if (digit==11)
		    	  retvar="#";
		      else if (digit>11 && digit<16)
		    	  retvar=String.valueOf((char)(digit+53));
		   return retvar;
	   }
	   
	   public String getSkypeDtmfBuffer()
	   {
		   return this.skypeDtmfBuffer;
	   }
	   
	   
	   /** Launches the Media Application */
	   protected void launchMediaApplication()
	   {
		  String localDesc=call.getLocalSessionDescriptor();
		  if (localDesc==null)
		  {	 
			 // this can occur if call has been cancelled
			 log.debug("Local SIP call cancelled. callUsed="+ call.callUsed());
			 if (call.callUsed())
				 this.listener.onUaCallFailed(this);
			 return;
		  }

		  SessionDescriptor local_sdp=new SessionDescriptor(localDesc);
	      //String local_media_address=(new Parser(local_sdp.getConnection().toString())).skipString().skipString().getString();
	      int local_audio_port=0;

	      int local_avp=0;
	      String codecParms="";
	      
	        // parse local sdp
	    	 MediaDescriptor md=local_sdp.getMediaDescriptor("audio");
	         if (md!=null) 
	         { 
	            local_audio_port=md.getMedia().getPort();
	            Vector<AttributeField> af=md.getAttributes("rtpmap");
	         	boolean codecMatched=false;
	            
	            int c=0;
	            while (c<af.size())
	            {
	            	AttributeField ca=af.get(c);
	            	String[] locAttr=ca.getAttributeValues();
	            	if (locAttr[1].toLowerCase().contains("telephone-event"))
        			{
        				// so rtp rx/tx knows correct dynamic payload number
	            		dtmf2833PayloadType_session=Integer.parseInt(locAttr[0]);
        			}
	            	else if (!codecMatched)
        			{
        				// found the codec
        				codecParms=locAttr[1];
	            		local_avp=Integer.parseInt(locAttr[0]);
	            		codecMatched=true;
        			}
	            	c++;
	            }

	 	        if (!codecMatched)
		        {	   
		    	   log.error("error matching codec local_sdp:"+local_sdp);
		    	   this.listener.onUaCallFailed(this);
		    	   return;
		        }
	         
	         }
	         else
	         {
		    	   log.error("Error - no audio descriptor in local session??? local_sdp:"+local_sdp);
		    	   this.listener.onUaCallFailed(this);
		    	   return;
	         }
	         
	      if (dtmf2833PayloadType_session==local_avp)
	      {
	    	   log.error("Error - rfc2833 type same as codec type - disabling rfc2833 for this session");
	    	   dtmf2833PayloadType_session=-1;
	      }
	         
	         
	      // parse remote sdp
	      SessionDescriptor remote_sdp=new SessionDescriptor(call.getRemoteSessionDescriptor());
	      String remote_media_address=(new Parser(remote_sdp.getConnection().toString())).skipString().skipString().getString();
	      
	      
	      int remote_audio_port=0;
	      
	      MediaDescriptor remmd=remote_sdp.getMediaDescriptor("audio");
	      if (remmd!=null) 
	            remote_audio_port=remmd.getMedia().getPort();
	      

	      if (log.isDebugEnabled())
	      {	  
    	    log.debug("launchMediaApplication\r\nremote media IP:"+remote_media_address+"\r\nlocalSdp:"+local_sdp.toString()+"\r\n\r\nremoteSdp:"+remote_sdp.toString());
  	        log.debug("RTP audio ports: local_audio_port="+local_audio_port+" remote_audio_port="+remote_audio_port);
	      }
    
	      
	      // select the media direction (send_only, recv_ony, fullduplex)
	      int dir=0;
	      if (user_profile.recv_only) 
	    	  dir=-1;
	      else if (user_profile.send_only) 
	    	  dir=1;
	      
	      //update info if the Media Application is already running  
	      if (audio_app!=null || video_app!=null)
	      {  
	    	 if (dir>=0 && audio_app!=null && !remote_media_address.equals("0.0.0.0"))
	         {	 
	        	this.skypeRtpSender.redirectRTP(remote_media_address,remote_audio_port);
	        	this.skypeRtpReceiver.resetRTPAllowRedirect();
	         }
	         else
	        	 log.debug("media application is already running");
	         
	         //if (!sscodec.getCodecName().equals(SSCodecFactory.getCodecNameFromNumber(local_avp)))
		     if (!sscodec.getCodecName().equals(codecParms.split("/")[0]))
	         {	 
		    	 String dmsg="Switching codec to: "+codecParms+"("+local_avp+")";
		    	 if (dtmf2833PayloadType_session>=0)
		    		 dmsg+=" rfc2833Type("+dtmf2833PayloadType_session+")";
		         log.info(dmsg);
		         SSCodec newCodec=null;
		         try
		         {
		        	 if (local_avp<96 || local_avp>127) //iana.org type
		        	 	newCodec=SSCodecFactory.getCodecByNumber(local_avp);
		        	 else
		        		newCodec=SSCodecFactory.getDynamicCodec(local_avp,codecParms);
		         }
		         catch (Exception e)
		         {
		        	log.fatal("Failed to load codec.",e);
		        	this.listener.onUaCallFailed(this);
		        	return;
		         }
		         
		         if (newCodec==null)
		         {
		        	log.fatal("Failed to load codec. (null)");
		        	this.listener.onUaCallFailed(this);
		        	return;
		         }
		         
		         sscodec=newCodec;
		         this.skypeRtpSender.initCodec(sscodec);
	         	 this.skypeRtpReceiver.initCodec(sscodec);
	         }
	         return;
	      }	      
	      
	      
	      if (user_profile.audio)
	      {  
	    	 if (local_audio_port!=0 && remote_audio_port!=0)
	    	 {	 
		    	  // create a skype audio_app and start it

		    	 String dmsg="Starting codec: "+codecParms+"("+local_avp+")";
		    	 if (dtmf2833PayloadType_session>=0)
		    	 	dmsg+=" rfc2833Type("+dtmf2833PayloadType_session+")";
	    		 
	    		 log.info(dmsg); 
		    	 
	
		         try
		         {
		        	 if (local_avp<96 || local_avp>127) //iana.org type
		        		 sscodec=SSCodecFactory.getCodecByNumber(local_avp);
		        	 else
		        		 sscodec=SSCodecFactory.getDynamicCodec(local_avp,codecParms);
		         }
		         catch (Exception e)
		         {
		        	log.fatal("Failed to load codec.",e); 
		        	this.listener.onUaCallFailed(this);
		        	return;
		         }
		         
		         audio_app=new JSkypeAudioLauncher(rtpSocket,sscodec,remote_media_address,remote_audio_port,dir,this.skypeRtpReceiver,this.skypeRtpSender);
		         audio_app.startMedia();
	    	 }
	    	 else
	    	 {
	    		 log.error("AudioPorts not found in descriptors??? local:"+local_audio_port+" remote:"+remote_audio_port);
	    		 this.listener.onUaCallFailed(this);
	    	 }
	      }
	   }
	   
	   protected synchronized void closeMediaApplication()
		{
		   super.closeMediaApplication();
		   sscodec=null;
		   openRtpSocket();
		}

	   
	   private void closeRtpSocket()
	   {
		   if (rtpSocket!=null)
		   {	 
			   try
			   {
			     rtpSocket.disconnect();
			     rtpSocket.close();
			   }
			   catch(Exception e)
			   {log.error("error disconnecting rtp socket",e);}
		   }
		   rtpSocket=null;
	   }
	   
	   private synchronized boolean openRtpSocket()
	   {
		   boolean retvar=false;

		   closeRtpSocket();
		   
		   try
		   {
			   
			 if (sip_provider.getInterfaceAddress()==null)                  
				 rtpSocket=new DatagramSocket(this.rtpPort);
	         else
	             rtpSocket=new DatagramSocket(this.rtpPort,sip_provider.getInterfaceAddress().getInetAddress()); 			   

			 retvar=true;
		   }
		   catch(Exception e)
		   {log.fatal("error creating rtp socket",e);}
		   
           /*
               IPTOS_LOWCOST (0x02) 
			   IPTOS_RELIABILITY (0x04) 
			   IPTOS_THROUGHPUT (0x08) 
			   IPTOS_LOWDELAY (0x10) 
            */
		   
		   try
           {
        	  rtpSocket.setTrafficClass(0x10 | 0x08);
           }
           catch(Exception e)
           {
        	  log.debug("setTrafficClass failed.",e);
           }		   
           
	   		if (skype_profile.RtpRxBufferSize>0)
			{
				try
				{
					rtpSocket.setReceiveBufferSize(skype_profile.RtpRxBufferSize);
					int tstRx=rtpSocket.getReceiveBufferSize();
					if (tstRx!=skype_profile.RtpRxBufferSize)
					{
						log.warn("error setting RtpReceiveBufferSize");
					}
				}
				catch (SocketException e)
				{
					log.warn("error setting RtpReceiveBufferSize",e);
				}
			}
           
	   		if (skype_profile.RtpTxBufferSize>0)
    		{	
    			try
    			{
    				rtpSocket.setSendBufferSize(skype_profile.RtpTxBufferSize);
					int tstTx=rtpSocket.getSendBufferSize();
					if (tstTx!=skype_profile.RtpTxBufferSize)
					{
						log.warn("error setting RTPSendBufferSize");
					}
    			}
    			catch (SocketException e)
    			{
					log.warn("error setting RTPSendBufferSize",e);
    			}
    		}
           
           
           return retvar;
	   }
	   
	   
	   void halt()
	   {
		    stopMedia();
			skypeRtpSender.halt();
			skypeRtpReceiver.halt();
		    closeRtpSocket();
			try {Thread.sleep(1000);}catch (Exception e){}
	   }
	   
}
