/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua;
import java.io.File;
import java.io.FileOutputStream;
import java.io.BufferedOutputStream;
import java.io.RandomAccessFile;

	public class UlawWriter
	{
		
		private BufferedOutputStream writer;
		private int bytesWritten=0;
		private String fileName=null;
		
		public UlawWriter(String fileName)
		{
			this.fileName=fileName;
			try
			{
				writer=new BufferedOutputStream (new FileOutputStream(fileName),8192); 
			}
			catch(Exception e)
			{
				System.err.println(e.getLocalizedMessage());
			}
	        
	        byte[] auHeader ={
	        		'.','s','n','d',
	        		'?','?','?','?',
	        		'?','?','?','?',
	        		'?','?','?','?',
	        		'?','?','?','?',
	        		'?','?','?','?',
	        		};

	        write(auHeader,0,auHeader.length);
			
			
	        bytesWritten=0;

		}

		public void write(byte[] data,int offset,int len)
		{  
			try
			{
				writer.write(data,offset,len);
				bytesWritten+=len;
			}
			catch(Exception e)
			{
				System.err.println(e.getLocalizedMessage());
			}
		}
		
		public void writeValues(byte[] data,int offset,int len)
		{  
			StringBuffer tmp=new StringBuffer();
			for (int x=offset;x<offset+len;x++)
				tmp.append(" "+Byte.toString(data[x]));
			tmp.append("\n");
			
			try
			{
				//writer.write(data,offset,len);
				writer.write(tmp.toString().getBytes());
				bytesWritten+=len;
			}
			catch(Exception e)
			{
				System.err.println(e.getLocalizedMessage());
			}
		}
		
		public void close()
		{
			try
			{
				writer.close();
			
				//	Now we can correct the .wav header:
				RandomAccessFile headWriter=new RandomAccessFile (new File(fileName),"rw"); 
				byte[]tmpbuf=new byte[4];

				// data offset
				local.ua.sscodecs.SSCodecFactory.intToBytes32(24,tmpbuf, 0, true);
				headWriter.seek(4);
				headWriter.write(tmpbuf);
				
				// data size
				local.ua.sscodecs.SSCodecFactory.intToBytes32(bytesWritten,tmpbuf,0,true);
				headWriter.seek(8);
				headWriter.write(tmpbuf);

				//ulaw format
				local.ua.sscodecs.SSCodecFactory.intToBytes32(1,tmpbuf,0,true);
				headWriter.seek(12);
				headWriter.write(tmpbuf);

				// 8000 bps
				local.ua.sscodecs.SSCodecFactory.intToBytes32(8000,tmpbuf,0,true);
				headWriter.seek(16);
				headWriter.write(tmpbuf);
				
				//1 channel
				local.ua.sscodecs.SSCodecFactory.intToBytes32(1,tmpbuf,0,true);
				headWriter.seek(20);
				headWriter.write(tmpbuf);

				headWriter.close();	
			
			}
			catch(Exception e)
			{
				System.err.println(e.getLocalizedMessage());
			}
		}
		
		
}
