/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.FileOutputStream;
import java.io.BufferedOutputStream;
public class WavWriter
{
	
	private BufferedOutputStream writer;
	private int bytesWritten=0;
	private String fileName=null;
	
	
	public WavWriter(String fileName)
	{
		this.fileName=fileName;
		
		try
		{
			writer=new BufferedOutputStream (new FileOutputStream(fileName),8192); 
		}
		catch(Exception e)
		{
			System.err.println(e.getLocalizedMessage());
		}
        
        byte[] wavHeader ={
        		'R','I','F','F','?','?','?','?',
        		'W','A','V','E','f','m','t',32,
        		16,0,0,0,1,0,1,0,
        		(byte)128,62,0,0,0,125,0,0,
        		2,0,16,0,'d','a','t','a',
        		'?','?','?','?'
        		};

        
        write(wavHeader,wavHeader.length);
        
        bytesWritten=0;

	}
	
	public void write(byte[] data,int len)
	{  
		try
		{
			writer.write(data,0,len);
			bytesWritten+=len;
		}
		catch(Exception e)
		{
			System.err.println(e.getLocalizedMessage());
		}
	}
	
	public void close()
	{
		try
		{
			writer.close();
			
			//	Now we can correct the .wav header:
			RandomAccessFile headWriter=new RandomAccessFile (new File(fileName),"rw"); 
			byte[]tmpbuf=new byte[4];

			local.ua.sscodecs.SSCodecFactory.intToBytes32(bytesWritten+36,tmpbuf, 0, false);
			headWriter.seek(4);
			headWriter.write(tmpbuf);
			
			local.ua.sscodecs.SSCodecFactory.intToBytes32(bytesWritten,tmpbuf,0,false);
			headWriter.seek(40);
			headWriter.write(tmpbuf);

			headWriter.close();	
		}
		catch(Exception e)
		{
			System.err.println(e.getLocalizedMessage());
		}
	}
	
	
}
