/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * 
 * Formula from http://en.wikipedia.org/wiki/Low-pass_filter
 * 
 * Author(s):
 * Greg Dorfuss 
 */

package local.ua.sscodecs;


public class FilterLowPassRc implements FilterInterface
{
	private float filtdt; // 50
	private float filtRC; // 39.82
	private float filtAlpha;
	private int filtConvsbpos;
	private short filtCurSample;
	private short filtLastSample=0;
	private int filtConvbsR;
	private int chunkSize;
	
	public FilterLowPassRc(float argDt,float argRc,int argChunkSize)
	{
		filtdt=argDt;
		filtRC=argRc;
		filtAlpha = filtdt / (filtRC + filtdt);
		chunkSize=argChunkSize;
	}
	
	public void filter(byte[] inBuf)
	{
    	 filtConvsbpos=0;
    	 filtConvbsR=0;
	     for (int i=0;i<chunkSize/2;i++)
	     {	 
	       filtCurSample=(short) (inBuf[filtConvbsR + 1] << 8 | inBuf[filtConvbsR] & 0xff);
	       filtConvbsR+=2;
	       filtLastSample = (short) (filtLastSample + filtAlpha * (filtCurSample - filtLastSample));
	       
	       inBuf[filtConvsbpos++] = (byte)(filtLastSample);
		   inBuf[filtConvsbpos++] = (byte)(filtLastSample >> 8);
	     }
	}      
	
}
