/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua.sscodecs;

public interface SSCodec
{
	 //Skype API is 16 Khz and 16 Bits per sample PCM
	 //The 16-bit samples are stored as 2's-complement signed integers, ranging from -32768 to 32767.
	
	public void init(int frame_size,double encodeGain,double decodeGain);
	
	public int getFrameSize();
	public int getPcmFrameSize();
	public int getSampleRate();
	public void setSampleRate(int rate);
	public int getPayloadType();
	public void setPayloadType(int type);
	public String getCodecName();
	
    public int getCodecBlankPacket(byte[] buf,int offset);

    public int PcmToCodec(byte[] buf,int len,byte[] codecOut,int codecBufOffset);
    
    public int CodecToPcm(byte[] buf,int offset,int len,byte[] pcmout);
 
    public int[] getValidFrameSizes();
    
    public SSCodecInfo getCodecInfo();
    
}
