/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * 
 * Author(s):
 * Greg Dorfuss
 */
package local.ua.sscodecs;

public class SSCodecUtilRW extends SSCodecUtil
{
	/* these globals should not be an issue since there should be 
	 * no need to up and down sample from the same side
	 * the codec could always allocate another instance if needed
	 */
	
	// downsamle vars
	private int dnCurSample1;
	private int dnSample;
	private int dnpos;
	private int dnR;


	
	public int downSample2x(byte[] srcbuf,int len,short[] outbuf,double gain)
	{
		// 2x downsample bytes to shorts
		dnpos=0;
    	for (dnR=0;dnR<len;dnR+=4) //	need to downsample - 2 samples each loop
		{
			// just drop a sample
			
    		dnCurSample1= srcbuf[dnR + 1] << 8 | srcbuf[dnR] & 0xff;
    		
    		dnSample=(int)(dnCurSample1*gain);
			if (dnSample>32767)
				dnSample=32767;
			else if (dnSample<-32768)
				dnSample=-32768;
    		
    		outbuf[dnpos++] = (short)dnSample;
		}
    	
    	return dnpos;
	}


	public int downSample2x(byte[] srcbuf,int len,byte[] outbuf,double gain)
	{
		// 2x downsample bytes to bytes
		dnpos=0;
    	for (dnR=0;dnR<len;dnR+=4) //	need to downsample - 2 samples each loop
		{
			// just drop a sample
			
    		dnCurSample1= srcbuf[dnR + 1] << 8 | srcbuf[dnR] & 0xff;
    		
    		dnSample=(int)(dnCurSample1*gain);
			if (dnSample>32767)
				dnSample=32767;
			else if (dnSample<-32768)
				dnSample=-32768;
    		
    		outbuf[dnpos++] = (byte)(dnSample);
    		outbuf[dnpos++] = (byte)(dnSample >> 8);
		}
    	
    	return dnpos;
	}



}
