/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * This one uses JMF
 * 
 * Author(s):
 * Greg Dorfuss
 */

// each GSM packet is 20ms

package local.ua.sscodecs;

import org.apache.log4j.Logger;

import local.ua.sscodecs.SSCodecUtil;
import com.ibm.media.codec.audio.gsm.GsmDecoder;
import com.ibm.media.codec.audio.gsm.GsmEncoder;


public class SSCodec_GSM implements SSCodec
{
	private Logger log = Logger.getLogger(this.getClass());
	private String codecName="GSM";
	private int payLoadType=3;
	private int sample_rate=8000;  
	private int sample_size=1;
	private int frame_size=0;
	private static final int gsmPacketSize=33;
	private static final int gsmInputSize=320;
	private double encodeGain=0;
	private double decodeGain=0;
	SSCodecUtil codecUtil=new SSCodecUtil();
	private int pcmFrameSize;
	
	//encoder vars
	private GsmEncoder encoder=new GsmEncoder();
	private byte[] encPcmBuf=null;
	private int encReadPtr;
	private int encWritePtr;

	
	//decoder vars
	GsmDecoder decoder=new GsmDecoder();
	private byte[] decPcmBuf=new byte[1280];
	private int decReadPtr;
	private int decWritePtr;

	public void init(int frame_size,double argEncodeGain,double argDecodeGain)
    {
		this.frame_size=frame_size;
		this.pcmFrameSize=frame_size*4;
    	this.encodeGain=argEncodeGain;
		this.decodeGain=argDecodeGain;
		
		encPcmBuf=new byte[this.frame_size*2];
    }

    public SSCodecInfo getCodecInfo()
    {
    	return new SSCodecInfo(this.getClass().getSimpleName().replaceAll("^[^_]+_", ""),this.codecName,this.frame_size,this.encodeGain,this.decodeGain);
    }

	
    public int[] getValidFrameSizes()
    {
    	return new int[]{160,320}; //20ms, 40ms I wouldn't bet on everything supporting 40ms
    }

	public int getFrameSize()
	{
	   return frame_size;	
	}
	
	public int getPcmFrameSize()
	{
	   return pcmFrameSize;	
	}
	
	public int getSampleRate()
	{
	   return sample_rate;	
	}
	
	public void setSampleRate(int rate)
	{
		sample_rate=rate;
	}
	
	public void setPayloadType(int type)
	{
		payLoadType=type;
	}
	
	public int getPayloadType()
	{
		return payLoadType;
	}
	
	public String getCodecName()
	{
		return codecName;
	}

    public int PcmToCodec(byte[] inpcm,int len,byte[] outgsm,int offset)
    {
    	// need to downsample first 
    	codecUtil.downSample2x(inpcm,len,encPcmBuf,encodeGain); // input 640 bytes returns 320 bytes
    	len=len/2;
    	
    	encReadPtr=0;
        encWritePtr=offset;
        while(encReadPtr<len)
        {
            encoder.gsm_encode_frame(encPcmBuf, encReadPtr, outgsm, encWritePtr);
            encReadPtr += gsmInputSize;
            encWritePtr += gsmPacketSize;
        }

        return encWritePtr-offset;
    }
    
    public int CodecToPcm(byte[] gsmBuf,int offset,int len,byte[] outpcm)
    {
    	decReadPtr=offset;
        decWritePtr = 0;
        while (decReadPtr<len)
        {
            decoder.decodeFrame(gsmBuf, decReadPtr, decPcmBuf, decWritePtr);
            decWritePtr += gsmInputSize;
            decReadPtr += gsmPacketSize;
        }

		//need 2x upsample
    	codecUtil.upSample2x(decPcmBuf,decWritePtr,outpcm,decodeGain); // upsample 320 bytes to 640
    	
    	return decWritePtr*2;
    }

    public int getCodecBlankPacket(byte[] buf,int offset)
    {
    	byte[] blankBuf=new byte[getPcmFrameSize()];
    	return PcmToCodec(blankBuf,blankBuf.length,buf,offset);
    }
	
}
