/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * uses ILBC from sipcommunicator
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua.sscodecs;

import org.apache.log4j.Logger;

import local.ua.sscodecs.SSCodecUtil;
import local.ua.sscodecs.ilbc.ilbc_decoder;
import local.ua.sscodecs.ilbc.ilbc_encoder;

public class SSCodec_ILBC implements SSCodec
{
	private Logger log = Logger.getLogger(this.getClass());
	private String codecName="iLBC";
	private int payLoadType=-1; // dynamic type
	private int sample_rate=8000;  
	private int sample_size=1;
	private int frame_size=0;
	private double encodeGain=0;
	private double decodeGain=0;
	SSCodecUtil codecUtil=new SSCodecUtil();
	private int pcmFrameSize;

	
	//encoder vars
	private short[] encPcmBuf=null;
	private ilbc_encoder encoder=null;
	private int encOutBytes;
	private short[] encIlbcBuf=null;

	
	//decoder vars
	private ilbc_decoder decoder=null;
	private short[] decIlbcBuf=null;
	private short[] decTargetPcmBuf=null;

	public void init(int frame_size,double argEncodeGain,double argDecodeGain)
    {
		this.frame_size=frame_size;
		this.pcmFrameSize=frame_size*4;
    	this.encodeGain=argEncodeGain;
		this.decodeGain=argDecodeGain;
		
		encPcmBuf=new short[this.frame_size];
		
		if (frame_size==160)
			encOutBytes=38;
		else
			encOutBytes=50;

		encIlbcBuf=new short[encOutBytes/2];
		
		decIlbcBuf=new short[encOutBytes/2];
		decTargetPcmBuf=new short[frame_size];

		encoder=new ilbc_encoder(frame_size/8);
		decoder=new ilbc_decoder(frame_size/8,1);
		
    }
	
    public SSCodecInfo getCodecInfo()
    {
    	return new SSCodecInfo(this.getClass().getSimpleName().replaceAll("^[^_]+_", ""),this.codecName,this.frame_size,this.encodeGain,this.decodeGain);
    }


    public int[] getValidFrameSizes()
    {
    	return new int[]{240}; //30ms
    }

	public int getFrameSize()
	{
	   return frame_size;	
	}
	
	public int getPcmFrameSize()
	{
	   return pcmFrameSize;	
	}
	
	public int getSampleRate()
	{
	   return sample_rate;	
	}
	
	public void setSampleRate(int rate)
	{
		sample_rate=rate;
	}
	
	public void setPayloadType(int type)
	{
		payLoadType=type;
	}

	public int getPayloadType()
	{
		return payLoadType;
	}
	public String getCodecName()
	{
		return codecName;
	}

    public int PcmToCodec(byte[] inpcm,int len,byte[] outIlbc,int offset)
    {
    	// need to downsample first 
    	codecUtil.downSample2x(inpcm,len,encPcmBuf,encodeGain); // input x bytes returns x/4 shorts
    	encoder.encode(encIlbcBuf,encPcmBuf); // buffers reversed (out,in) returns shorts
    	
    	// convert shorts to bytes
    	codecUtil.convertShortsToBytesBE(encIlbcBuf,encOutBytes/2,outIlbc,offset);
    	
        return encOutBytes;
    }
    
    public int CodecToPcm(byte[] inIlbc,int offset,int len,byte[] outpcm)
    {
    	codecUtil.convertBytesToShortsBE(inIlbc,offset,len,decIlbcBuf);

        decoder.decode(decTargetPcmBuf, decIlbcBuf, (short) 1); // buffers reversed (out,in,mode);

		//need 2x upsample
    	codecUtil.upSample2x(decTargetPcmBuf,frame_size,outpcm,decodeGain); // convert shorts to bytes while upsample
    	
    	return pcmFrameSize;
    }

    public int getCodecBlankPacket(byte[] buf,int offset)
    {
    	byte[] blankBuf=new byte[getPcmFrameSize()];
    	return PcmToCodec(blankBuf,blankBuf.length,buf,offset);
    }
	
}
