/*
 * Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Based on mjsip 1.6 software and skype4java
 * 
 * uses JSpeex
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua.sscodecs;

import org.apache.log4j.Logger;

import local.ua.sscodecs.SSCodecUtil;
import org.xiph.speex.SpeexEncoder;
import org.xiph.speex.SpeexDecoder;

public class SSCodec_SPEEX implements SSCodec
{
	private Logger log = Logger.getLogger(this.getClass());
	private String codecName="speex";
	private int payLoadType=-1; // dynamic type
	private int sample_rate=8000;  
	private int speexMode=0; //0=narrowband,1=wideband,2=ultrawideband
	private int sample_size=1;
	private int speexChannels=1;
	private int frame_size=0;
	private double encodeGain=0;
	private double decodeGain=0;
	SSCodecUtil codecUtil=new SSCodecUtil();
	private int pcmFrameSize;
	
	//encoder vars
	private SpeexEncoder encoder=new SpeexEncoder();
	private short[] encPcmBuf=null;
	private int speexQuality=3; // 0-10

	
	//decoder vars
	private SpeexDecoder decoder=new SpeexDecoder();
	private byte[] decPcmBuf=new byte[1280];
	private int decWritePtr;
	private boolean speexEnhanced=false;

	public void init(int frame_size,double argEncodeGain,double argDecodeGain)
    {
		this.frame_size=frame_size;
		this.pcmFrameSize=frame_size*4;
    	this.encodeGain=argEncodeGain;
		this.decodeGain=argDecodeGain;
		
		encPcmBuf=new short[this.frame_size];
		
		encoder.init(speexMode, speexQuality,sample_rate,speexChannels);
		
		encoder.getEncoder().setComplexity(2); // (0-10 from least complex to most complex) 
		encoder.getEncoder().setVbrQuality(4);
		encoder.getEncoder().setVbr(false);
		encoder.getEncoder().setAbr(0);
		encoder.getEncoder().setVad(false);
		encoder.getEncoder().setDtx(false);
		
		decoder.init(speexMode,sample_rate,speexChannels,speexEnhanced);
    }

	public SSCodecInfo getCodecInfo()
    {
    	return new SSCodecInfo(this.getClass().getSimpleName().replaceAll("^[^_]+_", ""),this.codecName,this.frame_size,this.encodeGain,this.decodeGain);
    }
	
    public int[] getValidFrameSizes()
    {
    	return new int[]{160}; //20ms
    }

	public int getFrameSize()
	{
	   return frame_size;	
	}
	
	public int getPcmFrameSize()
	{
	   return pcmFrameSize;	
	}
	
	public int getSampleRate()
	{
	   return sample_rate;	
	}
	
	public void setSampleRate(int rate)
	{
		sample_rate=rate;
	}
	
	public void setPayloadType(int type)
	{
		payLoadType=type;
	}

	public int getPayloadType()
	{
		return payLoadType;
	}
	public String getCodecName()
	{
		return codecName;
	}

    public int PcmToCodec(byte[] inpcm,int len,byte[] outSpeex,int offset)
    {
    	// need to downsample first 
    	codecUtil.downSample2x(inpcm,len,encPcmBuf,encodeGain); // input x bytes returns x/4 shorts
        encoder.processData(encPcmBuf,0,len/4);
        return encoder.getProcessedData(outSpeex,offset);
    }
    
    public int CodecToPcm(byte[] speexBuf,int offset,int len,byte[] outpcm)
    {
      	try
      	{
      		decoder.processData(speexBuf,offset,len);
      	}
      	catch(Exception e)
      	{
      		log.error("Speex Decoder Error",e);
      		return 0;
      	}
        
      	decWritePtr=decoder.getProcessedData(decPcmBuf, 0); 
      	
		//need 2x upsample
    	codecUtil.upSample2x(decPcmBuf,decWritePtr,outpcm,decodeGain);
    	
    	return decWritePtr*2;
    }

    public int getCodecBlankPacket(byte[] buf,int offset)
    {
    	byte[] blankBuf=new byte[getPcmFrameSize()];
    	return PcmToCodec(blankBuf,blankBuf.length,buf,offset);
    }
	
}
