/* Copyright (C) 2009 Greg Dorfuss - mhspot.com
 * 
 * SipToSis is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * SipToSis is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this source code; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * 
 * Author(s):
 * Greg Dorfuss
 */

package local.ua;

import java.text.DecimalFormat;

import org.apache.log4j.Logger;

import com.skype.connector.Connector;

public class util 
{
	private static Logger log=Logger.getLogger("util");
	
	
	private util()
	{
	}
	
	static String formatAmount(double amount,int precision)
	{
		    String strPrec="00000";
		    if (precision==0)
		    	precision=1;
			DecimalFormat Currency = new DecimalFormat("#0."+strPrec.substring(0,precision));
			return Currency.format(amount);
	}

	
	public static String parseSkypeResponse(String cmd,String hdr)
	{
		try
		{
			String response=Connector.getInstance().executeWithId(cmd,hdr);
			//log.info("###"+response);
			return response.substring(hdr.length()).trim();
		}
		catch(Throwable e)
		{
			log.debug("parseSkypeResponse error:",e);
		}
		return "";
	}

	static double getSkypeCreditBalance()
	{
		try
		{
			//int prec=Integer.parseInt(parseSkypeResponse("GET PROFILE PSTN_BALANCE_PRECISION","PROFILE PSTN_BALANCE_PRECISION"));
			//if (prec==0)
			int	prec=2;
			long bal=Long.parseLong(util.parseSkypeResponse("GET PROFILE PSTN_BALANCE","PROFILE PSTN_BALANCE"));
			return bal/Math.pow(10,prec);
		}
		catch(Throwable e)
		{
			log.debug("getSkypeCreditBal",e);
		}	
		return 0;
	}

	static String formatSkypeCreditBalance(double bal)
	{
		try
		{
			String currency=util.parseSkypeResponse("GET PROFILE PSTN_BALANCE_CURRENCY","PROFILE PSTN_BALANCE_CURRENCY");
			return "AcctBalance: "+util.formatAmount(bal,2)+" "+currency;
		}
		catch(Throwable e)
		{
			log.debug("getSkypeCreditBal",e);
		}	
		return "";
	}

}

