package local.ua;

import java.util.Vector;

public class SIPPortPool
{
	private static SIPPortPool sipPool=null;
	
	private Vector<Integer> pool=new Vector<Integer>();
	
	public static SIPPortPool getInstance() 
	{ 
		// singleton
		return sipPool;
	}	
	
	SIPPortPool(int basePort,int connectLimit)
	{
		sipPool=this;
		
		for (int p=basePort;p<basePort+(connectLimit*2);p+=2) // rtp is supposed be on even ports
			sipPool.returnPort(p);
		
	}
	
	public synchronized int getPort() throws Exception
	{
	   int retPort=pool.get(0);
	   pool.remove(0);
	   return retPort;	
	}
	
	public synchronized void returnPort(int port) 
	{
	   pool.add(port);
	}
	
	
}
