/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import titech.file.FileUtils;
import titech.file.ImageFileFilter;
import titech.image.ScrollableJPanel;
import titech.image.math.AMath;
import titech.wt.ModListener;

public class ImageRetrieval
implements Runnable {
    public static final String INDEX_NAME = ".histogram";
    public static final String THUMBSDIR = ".bthumbs";
    private int[] equivalences = new int[]{0, 1, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10};
    public static final int TIMEOUT = 10;
    ImageFileFilter filter;
    double regionThreshold = Double.MAX_VALUE;
    double[][] imageDB = null;
    double[][] univHistoDB;
    String[] paths;
    Vector retrieved = new Vector();
    double posW = 0.0;
    double volW = 0.2;
    double oriW = 0.2;
    double colW = 0.6;
    double[] query;
    ScrollableJPanel sjpanel;
    ModListener modListener;

    public ImageRetrieval(double[] query) {
        this.query = query;
        this.filter = new ImageFileFilter();
        this.filter.addExtension("jpg");
        this.filter.addExtension("png");
        this.filter.addExtension("jpeg");
        this.filter.addExtension("bmp");
        this.filter.addExtension("tiff");
    }

    public ImageRetrieval() {
        this(null);
    }

    public void setModListener(ModListener modListener) {
        this.modListener = modListener;
    }

    public void setQuery(double[] query) {
        this.query = query;
    }

    public void setSJPanel(ScrollableJPanel sjpanel) {
        this.sjpanel = sjpanel;
    }

    public ScrollableJPanel getSJPanel() {
        return this.sjpanel;
    }

    public double[][] getImageDB() {
        return this.imageDB;
    }

    public void setImageDB(double[][] imageDB) {
        this.imageDB = imageDB;
    }

    public void addLocalDB(String path) throws FileNotFoundException, IOException {
        File indexFile = new File(path + File.separator + INDEX_NAME);
        System.out.println(path);
        File[] fileList = FileUtils.ls(path, this.filter);
        BufferedReader reader = new BufferedReader(new FileReader(indexFile));
        this.imageDB = new double[fileList.length][];
        this.univHistoDB = new double[fileList.length][];
        this.paths = new String[fileList.length];
        for (int i = 0; i < fileList.length; ++i) {
            File f = fileList[i];
            String descriptor = reader.readLine();
            this.imageDB[i] = AMath.vectorDouble(descriptor);
            this.univHistoDB[i] = this.universalHistogram(this.imageDB[i]);
            this.paths[i] = f.getAbsolutePath();
        }
        reader.close();
        System.out.println("ImageRetrieval: " + this.imageDB.length + " images in the DB.");
    }

    double[] universalHistogram(double[] h) {
        double[] univHisto = new double[11];
        for (int i = 0; i < 52; ++i) {
            int cat;
            int n = cat = this.equivalences[i];
            univHisto[n] = univHisto[n] + h[22 + i];
        }
        return univHisto;
    }

    public void clear() {
        this.sjpanel.removeAll();
        this.sjpanel.repaint();
    }

    public void run() {
        try {
            int i;
            for (int timeout = 0; (this.query == null || this.imageDB == null) && timeout < 10; ++timeout) {
                Thread.sleep(500L);
            }
            TreeMap<Double, Integer> treemap = new TreeMap<Double, Integer>();
            for (i = 0; i < this.imageDB.length; ++i) {
                double pdist = AMath.distance(this.query, this.imageDB[i], 0, 8);
                double vdist = AMath.distance(this.query, this.imageDB[i], 9, 18);
                double sdist = AMath.distance(this.query, this.imageDB[i], 19, 21);
                double cdist = AMath.distance(this.query, this.imageDB[i], 22, this.query.length - 1);
                double univdist = AMath.distance(this.universalHistogram(this.query), this.univHistoDB[i]);
                double distance = this.posW * pdist + this.volW * vdist + this.oriW * sdist + this.colW * cdist * univdist;
                treemap.put(new Double(distance), new Integer(i));
            }
            if (this.sjpanel != null) {
                this.clear();
                for (i = 0; i < 10; ++i) {
                    Double k = (Double)treemap.firstKey();
                    Integer v = (Integer)treemap.remove(k);
                    System.out.println("Image distance: " + k);
                    this.sjpanel.add(new JButton(new ImageIcon(Utilities.resize(Utilities.loadImage(this.paths[v]), 120))));
                }
                if (this.modListener != null) {
                    this.modListener.imageRetrieved();
                } else {
                    this.sjpanel.validate();
                }
            }
        }
        catch (Exception exc) {
            System.err.println("ImageRetrieval thread: " + exc);
        }
    }
}

