/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class NaviBar
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int ICON_WIDTH = 28;
    public static final int ICON_HEIGHT = 28;
    Window parentWindow = null;
    JTextArea log = null;
    ToolBar toolBar = null;
    String resultDir = "drawings";
    File[] fileList = null;
    int currentImage = -1;

    public NaviBar() {
        this.setLayout(new FlowLayout());
        JButton startB = new JButton("START");
        startB.setActionCommand("start");
        startB.addActionListener(this);
        JButton nextB = new JButton(new ImageIcon(this.getClass().getResource("/resources/next.png")));
        nextB.setPreferredSize(new Dimension(28, 28));
        nextB.setActionCommand("next");
        nextB.addActionListener(this);
        this.add(startB);
        this.add(nextB);
    }

    public void setToolBar(ToolBar tb) {
        this.toolBar = tb;
    }

    public void setParentWindow(Window pw) {
        this.parentWindow = pw;
    }

    public void setLog(JTextArea l) {
        this.log = l;
    }

    public void saveCurrent() {
        int ji = this.currentImage + 1;
        String fname = this.resultDir + File.separator + "drawing" + (ji < 10 ? "0" + ji : "" + ji) + ".png";
        try {
            File tt = new File(this.resultDir);
            if (!tt.exists()) {
                tt.mkdir();
            }
            if (!(tt = new File(fname)).exists()) {
                Utilities.saveImage(this.toolBar.getDrawing(), "png", new File(fname));
            } else {
                this.print("You already drew this before.");
            }
        }
        catch (Exception exc) {
            this.print("Saving: " + exc);
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void print(String text) {
        this.log.append(text + "\n");
        this.log.setCaretPosition(this.log.getDocument().getLength());
        System.out.println(text);
    }
}

