/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import titech.file.FileUtils;
import titech.image.math.AMath;

public class ObjectImage {
    public static final int NFEATURES = 15;
    public static final int RHISTO_SIZE = 22;
    public static final int CHISTO_SIZE = 52;
    Vector regions;
    double contourCount = -1.0;
    double[] pwdistances = null;
    String location;
    String keywords;
    double[] histogram = null;
    double[] weights = new double[]{0.25, 0.25, 0.25, 0.25};
    double minDist;
    private int[] equivalences = null;
    private int nlabels;
    private float[][] labmap;

    public ObjectImage() {
        this.regions = new Vector();
        this.histogram = new double[74];
        try {
            InputStream stream = this.getClass().getResourceAsStream("/resources/histogram.palette");
            this.labmap = Utilities.loadPaletteLab(stream);
        }
        catch (Exception ex) {
            System.err.println("ObjectImage: " + ex);
        }
    }

    public ObjectImage(String os) {
        this.regions = new Vector();
        StringTokenizer stok = new StringTokenizer(os);
        try {
            int nregions = Integer.parseInt(stok.nextToken());
            this.contourCount = Double.parseDouble(stok.nextToken());
            this.pwdistances = new double[4];
            for (int k = 0; k < 4; ++k) {
                this.pwdistances[k] = Double.parseDouble(stok.nextToken());
            }
            for (int i = 1; i < nregions; ++i) {
                Region region = new Region();
                region.setColorCat(Integer.parseInt(stok.nextToken()));
                this.regions.add(region);
            }
            double[] features = new double[15];
            for (int i = 1; i < nregions; ++i) {
                for (int f = 0; f < 15; ++f) {
                    features[f] = Double.parseDouble(stok.nextToken());
                }
                Region region = (Region)this.regions.get(i - 1);
                region.setFeatures(features);
            }
        }
        catch (Exception e) {
            System.err.println("ObjectImage: " + e);
        }
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBThumbLocation() {
        return ObjectImage.thumbFromLocation(this.location);
    }

    public static String thumbFromLocation(String location) {
        String path = location.substring(0, location.lastIndexOf("/"));
        String filename = location.substring(location.lastIndexOf("/") + 1);
        return path + File.separator + ".bthumbs" + File.separator + FileUtils.nameWOExtension(filename) + ".png";
    }

    public Region addRegion(BufferedImage img, Color stroke) {
        Region region = this.calculateFeatures(img);
        region.setColor(stroke);
        this.regions.add(region);
        return region;
    }

    public Region getRegion(int index) {
        return (Region)this.regions.get(index);
    }

    public void clear() {
        this.regions.clear();
    }

    public Region calculateFeatures(BufferedImage img) {
        int r;
        int i;
        int j;
        int width = img.getWidth();
        int height = img.getHeight();
        int n = 0;
        double vol = 0.0;
        int minx = width;
        int maxx = 0;
        int miny = height;
        int maxy = 0;
        int momentX = 0;
        int momentY = 0;
        double momentXX = 0.0;
        double momentXY = 0.0;
        double momentYY = 0.0;
        double centerX = 0.0;
        double centerY = 0.0;
        double relativeVol = 0.0;
        double orientation = 0.0;
        double elongation = 0.0;
        for (j = 0; j < height; ++j) {
            for (i = 0; i < width; ++i) {
                r = img.getRGB(i, j) & 0xFFFFFF;
                if (r == 0) continue;
                ++n;
                if (i < minx) {
                    minx = i;
                }
                if (i > maxx) {
                    maxx = i;
                }
                if (j < miny) {
                    miny = j;
                }
                if (j > maxy) {
                    maxy = j;
                }
                momentX += i;
                momentY += j;
            }
        }
        if (n > 0) {
            centerX = (double)momentX / (double)n;
            centerY = (double)momentY / (double)n;
            for (j = miny; j < maxy; ++j) {
                for (i = minx; i < maxx; ++i) {
                    r = img.getRGB(i, j) & 0xFFFFFF;
                    if (r == 0) continue;
                    double pX = (double)i - centerX;
                    double pY = (double)j - centerY;
                    momentXX += pX * pX;
                    momentXY += pX * pY;
                    momentYY += pY * pY;
                }
            }
            orientation = Math.atan(((momentYY /= (double)n) - (momentXY *= 2.0 / (double)n)) / ((momentXX /= (double)n) - momentXY));
            if (momentYY < momentXY) {
                orientation = Math.abs(orientation) - 1.5707963267948966;
            }
            elongation = (Math.abs(momentXX - momentYY) + Math.abs(momentXY)) / AMath.max(momentXX, Math.abs(momentXY), momentYY);
            elongation = Math.min(elongation, 1.0);
            int w = maxx - minx + 1;
            int h = maxy - miny + 1;
            if (w * h > 0) {
                relativeVol = (double)n / (double)(w * h);
            }
            vol = (double)n / (double)(width * height);
            centerX /= (double)width;
            centerY /= (double)height;
        }
        Region region = new Region();
        region.setCenter(centerX, centerY);
        region.setVolume(vol, relativeVol);
        region.setOrientation(orientation);
        region.setElongation(elongation);
        return region;
    }

    public void setRegions(BufferedImage bim) {
        this.setRegions(this.colorLabel(bim), bim);
    }

    public void setRegions(int[][] img, BufferedImage bim) {
        this.clear();
        int width = img.length;
        int height = img[0].length;
        int[] n = new int[this.nlabels];
        double[] vol = new double[this.nlabels];
        int[] minx = new int[this.nlabels];
        for (int i = 0; i < this.nlabels; ++i) {
            minx[i] = width;
        }
        int[] maxx = new int[this.nlabels];
        int[] miny = new int[this.nlabels];
        for (int i = 0; i < this.nlabels; ++i) {
            miny[i] = height;
        }
        int[] maxy = new int[this.nlabels];
        int[] momentX = new int[this.nlabels];
        int[] momentY = new int[this.nlabels];
        double[] momentXX = new double[this.nlabels];
        double[] momentYY = new double[this.nlabels];
        double[] momentXY = new double[this.nlabels];
        double[] centerX = new double[this.nlabels];
        double[] centerY = new double[this.nlabels];
        double[] relativeVol = new double[this.nlabels];
        double[] orientation = new double[this.nlabels];
        double[] elongation = new double[this.nlabels];
        int[] color = new int[this.nlabels];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int r;
                int n2 = r = img[i][j];
                n[n2] = n[n2] + 1;
                if (r <= 0 || r >= this.nlabels) continue;
                if (i < minx[r]) {
                    minx[r] = i;
                }
                if (i > maxx[r]) {
                    maxx[r] = i;
                }
                if (j < miny[r]) {
                    miny[r] = j;
                }
                if (j > maxy[r]) {
                    maxy[r] = j;
                }
                int n3 = r;
                momentX[n3] = momentX[n3] + i;
                int n4 = r;
                momentY[n4] = momentY[n4] + j;
                color[r] = bim.getRGB(i, j);
            }
        }
        for (int r = 1; r < this.nlabels; ++r) {
            if (n[r] <= 0) continue;
            centerX[r] = (double)momentX[r] / (double)n[r];
            centerY[r] = (double)momentY[r] / (double)n[r];
            for (int j = miny[r]; j < maxy[r]; ++j) {
                for (int i = minx[r]; i < maxx[r]; ++i) {
                    if (img[i][j] != r) continue;
                    double pX = (double)i - centerX[r];
                    double pY = (double)j - centerY[r];
                    int n5 = r;
                    momentXX[n5] = momentXX[n5] + pX * pX;
                    int n6 = r;
                    momentXY[n6] = momentXY[n6] + pX * pY;
                    int n7 = r;
                    momentYY[n7] = momentYY[n7] + pY * pY;
                }
            }
            int n8 = r;
            momentXX[n8] = momentXX[n8] / (double)n[r];
            int n9 = r;
            momentXY[n9] = momentXY[n9] * (2.0 / (double)n[r]);
            int n10 = r;
            momentYY[n10] = momentYY[n10] / (double)n[r];
            orientation[r] = Math.atan((momentYY[r] - momentXY[r]) / (momentXX[r] - momentXY[r]));
            if (momentYY[r] < momentXY[r]) {
                orientation[r] = Math.abs(orientation[r]) - 1.5707963267948966;
            }
            elongation[r] = (Math.abs(momentXX[r] - momentYY[r]) + Math.abs(momentXY[r])) / AMath.max(momentXX[r], Math.abs(momentXY[r]), momentYY[r]);
            elongation[r] = Math.min(elongation[r], 1.0);
            int w = maxx[r] - minx[r] + 1;
            int h = maxy[r] - miny[r] + 1;
            if (w * h > 0) {
                relativeVol[r] = (double)n[r] / (double)(w * h);
            }
            vol[r] = (double)n[r] / (double)(width * height);
            int n11 = r;
            centerX[n11] = centerX[n11] / (double)width;
            int n12 = r;
            centerY[n12] = centerY[n12] / (double)height;
            Region region = new Region();
            region.setCenter(centerX[r], centerY[r]);
            region.setVolume(vol[r], relativeVol[r]);
            region.setOrientation(orientation[r]);
            region.setElongation(elongation[r]);
            region.setColor(color[r]);
            this.regions.add(region);
        }
        this.computeColorHistogram(bim, this.labmap);
        this.computeRegionHistogram();
    }

    public int minDistanceRegion(Region query) {
        this.minDist = Double.MAX_VALUE;
        int minR = 0;
        for (int i = 0; i < this.regions.size(); ++i) {
            Region r = (Region)this.regions.get(i);
            double d = r.distance(query, this.weights, null);
            if (!(d < this.minDist)) continue;
            minR = i;
            this.minDist = d;
        }
        return minR;
    }

    public void setWeights(double position, double volume, double color, double orientation) {
        this.weights[0] = position;
        this.weights[1] = volume;
        this.weights[2] = color;
        this.weights[3] = orientation;
    }

    public double getMinDist() {
        return this.minDist;
    }

    private int[][] colorLabel(BufferedImage src) {
        int width = src.getWidth();
        int height = src.getHeight();
        int[][] dst = new int[width][height];
        int[] nb = new int[4];
        int[] nbl = new int[4];
        this.equivalences = new int[width * height];
        for (int i = 0; i < this.equivalences.length; ++i) {
            this.equivalences[i] = i;
        }
        int label = 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i;
                int color = src.getRGB(x, y);
                nb[0] = this.getSample(src, x - 1, y);
                nb[1] = this.getSample(src, x, y - 1);
                nb[2] = this.getSample(src, x - 1, y - 1);
                nb[3] = this.getSample(src, x + 1, y - 1);
                nbl[0] = this.getSample(dst, x - 1, y);
                nbl[1] = this.getSample(dst, x, y - 1);
                nbl[2] = this.getSample(dst, x - 1, y - 1);
                nbl[3] = this.getSample(dst, x + 1, y - 1);
                if (nb[0] != color && nb[1] != color && nb[2] != color && nb[3] != color) {
                    dst[x][y] = label++;
                    continue;
                }
                int count = 0;
                int found = -1;
                for (i = 0; i < 4; ++i) {
                    if (nb[i] != color) continue;
                    ++count;
                    found = i;
                }
                dst[x][y] = nbl[found];
                if (count <= 1) continue;
                for (i = 0; i < 4; ++i) {
                    if (nb[i] != color || nbl[i] == dst[x][y]) continue;
                    this.associate(nbl[i], dst[x][y]);
                }
            }
        }
        for (int i = label - 1; i > 0; --i) {
            this.equivalences[i] = this.reduce(i);
        }
        int[] condensed = new int[label];
        int count = 0;
        for (int i = 0; i < label; ++i) {
            if (i != this.equivalences[i]) continue;
            condensed[i] = count++;
        }
        this.nlabels = count;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int i;
                dst[x][y] = i = condensed[this.equivalences[dst[x][y]]];
            }
        }
        this.equivalences = null;
        return dst;
    }

    private int getSample(BufferedImage src, int x, int y) {
        int w = src.getWidth();
        int h = src.getHeight();
        return x < 0 || x >= w || y < 0 || y >= h ? 0 : src.getRGB(x, y);
    }

    private int getSample(int[][] src, int x, int y) {
        int w = src.length;
        int h = src[0].length;
        return x < 0 || x >= w || y < 0 || y >= h ? 0 : src[x][y];
    }

    private int reduce(int a) {
        if (this.equivalences[a] == a) {
            return a;
        }
        return this.reduce(this.equivalences[a]);
    }

    private void associate(int a, int b) {
        if (a > b) {
            this.associate(b, a);
            return;
        }
        if (a == b || this.equivalences[b] == a) {
            return;
        }
        if (this.equivalences[b] == b) {
            this.equivalences[b] = a;
        } else {
            this.associate(this.equivalences[b], a);
            this.equivalences[b] = a;
        }
    }

    public double[] getHistogram() {
        return this.histogram;
    }

    private void computeRegionHistogram() {
        for (int i = 0; i < 22; ++i) {
            this.histogram[i] = 0.0;
        }
        double[][] refPos = new double[][]{{0.16666666666666666, 0.16666666666666666}, {0.5, 0.16666666666666666}, {0.8333333333333334, 0.16666666666666666}, {0.16666666666666666, 0.5}, {0.5, 0.5}, {0.8333333333333334, 0.5}, {0.16666666666666666, 0.8333333333333334}, {0.5, 0.8333333333333334}, {0.8333333333333334, 0.8333333333333334}};
        double[] refVols = new double[]{0.6, 0.4, 0.2, 0.1, 0.05};
        double refRVol = 0.5;
        double[] refAngles = new double[]{0.0, 1.5707963267948966, 0.7853981633974483};
        double[] refElongs = new double[]{1.0, 1.0, 0.0};
        int nregions = this.regions.size();
        for (int r = 0; r < nregions; ++r) {
            int i;
            Region rg = (Region)this.regions.get(r);
            int n = i = AMath.findMin(new double[]{rg.cx, rg.cy}, refPos);
            this.histogram[n] = this.histogram[n] + rg.vol;
            i = AMath.findMin(rg.vol, refVols);
            int j = rg.rvol <= refRVol ? 0 : 1;
            int n2 = 9 + 2 * i + j;
            this.histogram[n2] = this.histogram[n2] + 1.0;
            i = AMath.findMinAngular(rg.orientation, refAngles, rg.elongation, refElongs);
            int n3 = 19 + i;
            this.histogram[n3] = this.histogram[n3] + rg.vol;
        }
        for (int i = 0; i < 10; ++i) {
            int n = 9 + i;
            this.histogram[n] = this.histogram[n] / (double)nregions;
        }
    }

    private void computeColorHistogram(BufferedImage image, float[][] labmap) {
        int height = image.getHeight();
        int width = image.getWidth();
        int bins = labmap.length;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int rgb = image.getRGB(i, j);
                float[] lab = Utilities.sRGBtoLab(rgb);
                int bin = AMath.findMin(lab, labmap);
                int n = 22 + bin;
                this.histogram[n] = this.histogram[n] + 1.0;
            }
        }
        for (int i = 0; i < bins; ++i) {
            int n = 22 + i;
            this.histogram[n] = this.histogram[n] / (double)(height * width);
        }
    }
}

