/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import titech.db.ImageRetrieval;
import titech.db.Retrieval;
import titech.image.dsp.ObjectImage;
import titech.image.dsp.Region;

public class PaintCanvas
extends Canvas
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    public static final int NONE = 0;
    public static final int DOTS = 1;
    public static final int SQUARE = 2;
    private BufferedImage mImage = null;
    private BufferedImage mUndo = null;
    private BufferedImage mBrush = null;
    private BufferedImage mObject = null;
    ObjectImage objectImage;
    protected Color bgColor = Color.black;
    protected Color fgColor = Color.white;
    protected int toolMode = 1;
    protected Point startP;
    protected Point endP;
    protected int strokeSize = 50;
    protected Stroke stroke = new BasicStroke(this.strokeSize);
    protected boolean dragging = false;
    private int gridWidth = 1;
    private int gridHeight = 1;
    private int width = 1;
    private int height = 1;
    boolean block = false;
    boolean rubber = false;
    boolean inside = false;
    Point location;
    Retrieval retrieval;
    ImageRetrieval iretrieval;
    Thread iretrievalThread;

    public void setRetrieval(Retrieval ret) {
        this.retrieval = ret;
    }

    public void setImageRetrieval(ImageRetrieval iret) {
        this.iretrieval = iret;
    }

    public void setRubber(boolean r) {
        this.rubber = r;
    }

    public void block() {
        this.block = true;
    }

    public void release() {
        this.block = false;
    }

    public boolean isBlocked() {
        return this.block;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = this.width;
        size.height = this.height;
        return size;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public Color getbgColor() {
        return this.bgColor;
    }

    public PaintCanvas(int size) {
        this(size, size);
    }

    public PaintCanvas(int width, int height) {
        this(width, height, Color.black);
    }

    public PaintCanvas(int width, int height, Color bg) {
        this.bgColor = bg;
        this.setBackground(this.bgColor);
        this.setForeground(this.fgColor);
        this.setSize(width, height);
        this.setStroke(this.strokeSize);
        this.toolMode = 1;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.objectImage = new ObjectImage();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.width = width;
        this.height = height;
        this.mImage = new BufferedImage(width, height, 1);
        Graphics gi = this.mImage.getGraphics();
        gi.setColor(this.bgColor);
        gi.fillRect(0, 0, width, height);
        gi.dispose();
        this.mUndo = new BufferedImage(width, height, 1);
        this.mObject = new BufferedImage(width, height, 1);
    }

    public void setStroke(int size) {
        this.strokeSize = size;
        this.stroke = new BasicStroke(size, 1, 1);
    }

    public void setBrush(BufferedImage buf) {
        this.mBrush = buf;
        this.toolMode = 1;
    }

    public void setMode(int mode) {
        this.toolMode = mode;
    }

    public void setGrid(int width, int height) {
        this.gridWidth = width;
        this.gridHeight = height;
    }

    public void setPaintColor(Color c) {
        this.fgColor = c;
        this.repaint();
    }

    public Color getPaintColor() {
        return this.fgColor;
    }

    public void setBackColor(Color c) {
        this.bgColor = c;
    }

    public Color getBackColor() {
        return this.bgColor;
    }

    public void clear() {
        Graphics gu = this.mUndo.getGraphics();
        gu.drawImage(this.mImage, 0, 0, this);
        gu.dispose();
        Graphics gi = this.mImage.getGraphics();
        gi.setColor(this.bgColor);
        gi.fillRect(0, 0, this.width, this.height);
        gi.dispose();
        this.repaint();
        this.objectImage.clear();
        this.objectImage.setRegions(Utilities.resize(this.mImage, 100));
        try {
            if (this.iretrievalThread != null) {
                this.iretrievalThread.join();
            }
        }
        catch (Exception exc) {
            System.err.println("PaintCanvas: " + exc);
        }
        if (this.iretrieval != null) {
            this.iretrieval.setQuery(this.objectImage.getHistogram());
            this.iretrievalThread = new Thread(this.iretrieval);
            this.iretrievalThread.start();
        }
    }

    public void set(BufferedImage img) {
        this.setSize(img.getWidth(), img.getHeight());
        Graphics layer = this.mImage.getGraphics();
        layer.drawImage(img, 0, 0, this);
        layer.dispose();
        this.repaint();
    }

    public void drawOn(Graphics g0) {
        Graphics2D g = (Graphics2D)g0;
        if (this.rubber) {
            g.setColor(this.bgColor);
        } else {
            g.setColor(this.fgColor);
        }
        if (this.mBrush != null) {
            g.drawImage((Image)this.mBrush, this.startP.x, this.startP.y, this);
        } else if (this.startP.equals(this.endP)) {
            switch (this.toolMode) {
                case 1: {
                    g.fillOval(this.startP.x - (this.strokeSize >> 1), this.startP.y - (this.strokeSize >> 1), this.strokeSize, this.strokeSize);
                    break;
                }
                case 2: {
                    g.fillRect(this.startP.x - (this.strokeSize >> 1), this.startP.y - (this.strokeSize >> 1), this.strokeSize, this.strokeSize);
                    break;
                }
            }
        } else {
            g.setStroke(this.stroke);
            g.drawLine(this.startP.x, this.startP.y, this.endP.x, this.endP.y);
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.mImage, 0, 0, this);
        if (this.inside && !this.dragging) {
            g.setColor(this.fgColor);
            g.drawOval(this.location.x - (this.strokeSize >> 1), this.location.y - (this.strokeSize >> 1), this.strokeSize, this.strokeSize);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void mouseEntered(MouseEvent e) {
        this.location = e.getPoint();
        this.inside = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.inside = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        if (this.isBlocked()) {
            return;
        }
        if (e.getButton() == 3) {
            this.setRubber(true);
        } else if (e.getButton() == 1) {
            this.setRubber(false);
        }
        Point p = e.getPoint();
        if (this.gridWidth > 1) {
            p.x /= this.gridWidth;
            p.x *= this.gridWidth;
        }
        if (this.gridHeight > 1) {
            p.y /= this.gridHeight;
            p.y *= this.gridHeight;
        }
        Graphics gUndo = this.mUndo.getGraphics();
        Graphics gImage = this.mImage.getGraphics();
        gUndo.drawImage(this.mImage, 0, 0, this);
        gUndo.dispose();
        if (!this.dragging) {
            this.startP = p;
            this.endP = p;
        }
        this.drawOn(gImage);
        gImage.dispose();
        if (!this.rubber) {
            Color fg = this.fgColor;
            this.fgColor = Color.WHITE;
            Graphics gObj = this.mObject.getGraphics();
            this.drawOn(gObj);
            gObj.dispose();
            this.fgColor = fg;
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.dragging = false;
        Region region = this.objectImage.addRegion(this.mObject, this.fgColor);
        if (this.retrieval != null) {
            Retrieval ret = new Retrieval(region);
            ret.cloneFrom(this.retrieval);
            Thread rt = new Thread(ret);
            rt.start();
        }
        this.objectImage.setRegions(Utilities.resize(this.mImage, 100));
        try {
            if (this.iretrievalThread != null) {
                this.iretrievalThread.join();
            }
        }
        catch (Exception exc) {
            System.err.println("PaintCanvas: " + exc);
        }
        if (this.iretrieval != null) {
            this.iretrieval.setQuery(this.objectImage.getHistogram());
            this.iretrievalThread = new Thread(this.iretrieval);
            this.iretrievalThread.start();
        }
        Graphics gi = this.mObject.getGraphics();
        gi.setColor(Color.BLACK);
        gi.fillRect(0, 0, this.width, this.height);
        gi.dispose();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.location = e.getPoint();
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isBlocked()) {
            return;
        }
        this.endP = e.getPoint();
        this.dragging = true;
        this.mousePressed(e);
        this.startP = this.endP;
    }
}

