/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import titech.image.math.AMath;

public class Region {
    double cx;
    double cy;
    double vol;
    double rvol;
    double[] color;
    int ccat;
    double orientation;
    double elongation;

    void setCenter(double cx, double cy) {
        this.cx = cx;
        this.cy = cy;
    }

    void setVolume(double vol, double rvol) {
        this.vol = vol;
        this.rvol = rvol;
    }

    void setOrientation(double orientation) {
        this.orientation = orientation;
    }

    void setElongation(double elongation) {
        this.elongation = elongation;
    }

    void setColor(Color rgb) {
        float[] rgbvector = new float[]{(float)rgb.getRed() / 255.0f, (float)rgb.getGreen() / 255.0f, (float)rgb.getBlue() / 255.0f};
        this.color = AMath.multV(AMath.toDouble(Utilities.sRGBtoLab(rgbvector)), 0.01);
    }

    void setColor(int rgb) {
        float[] v = new float[]{rgb >> 16, rgb >> 8 & 0xFF, rgb & 0xFF};
        v[0] = v[0] / 255.0f;
        v[1] = v[1] / 255.0f;
        v[2] = v[2] / 255.0f;
        this.color = AMath.multV(AMath.toDouble(Utilities.sRGBtoLab(v)), 0.01);
    }

    void setColorCat(int cat) {
        this.ccat = cat;
    }

    void setFeatures(double[] features) {
        this.cx = features[0];
        this.cy = features[1];
        this.vol = features[2];
        this.rvol = features[3];
        this.color = new double[]{features[4], features[5], features[6]};
        this.orientation = features[13];
        this.elongation = features[14];
    }

    double distance(Region pair) {
        return this.distance(pair, new double[]{0.25, 0.25, 0.25, 0.25}, null);
    }

    double distance(Region pair, double[] weights, double[] distances) {
        double pd = Math.sqrt((this.cx - pair.cx) * (this.cx - pair.cx) + (this.cy - pair.cy) * (this.cy - pair.cy));
        double vd = Math.sqrt((this.vol - pair.vol) * (this.vol - pair.vol) + (this.rvol - pair.rvol) * (this.rvol - pair.rvol));
        double cd = 0.0;
        if (weights[2] > 0.0) {
            for (int c = 0; c < 3; ++c) {
                cd += (this.color[c] - pair.color[c]) * (this.color[c] - pair.color[c]);
            }
            cd = Math.sqrt(cd);
        }
        double cosa = Math.cos(this.orientation) * Math.cos(pair.orientation) + Math.sin(this.orientation) * Math.sin(pair.orientation);
        double ed = Math.abs(this.elongation - pair.elongation);
        double od = (this.elongation * pair.elongation * (1.0 - Math.abs(cosa)) + ed) / 2.0;
        if (distances != null && distances.length > 3) {
            distances[0] = pd;
            distances[1] = vd;
            distances[2] = cd;
            distances[3] = od;
        }
        double dist = pd * weights[0] + vd * weights[1] + cd * weights[2] + od * weights[3];
        return dist;
    }

    public String toString() {
        return "{(" + this.cx + "," + this.cy + "), " + "(" + this.vol + "," + this.rvol + "), " + this.orientation + ", " + this.elongation + "}";
    }
}

