/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import javax.swing.ImageIcon;
import titech.file.FileUtils;
import titech.file.ImageFileFilter;
import titech.image.ScrollableJPanel;
import titech.util.ValuePair;
import titech.wt.CompositeButton;

public class Retrieval
implements Runnable {
    public static final String INDEX_NAME = ".blobs";
    public static final String THUMBSDIR = ".bthumbs";
    public static final int TIMEOUT = 10;
    ImageFileFilter filter;
    double regionThreshold = Double.MAX_VALUE;
    Vector objectDB = new Vector();
    Vector retrieved = new Vector();
    double posW = 0.25;
    double volW = 0.25;
    double colW = 0.25;
    double oriW = 0.25;
    Region query;
    ScrollableJPanel sjpanel;

    public Retrieval(Region query) {
        this.query = query;
        this.filter = new ImageFileFilter();
        this.filter.addExtension("jpg");
        this.filter.addExtension("png");
        this.filter.addExtension("jpeg");
        this.filter.addExtension("bmp");
        this.filter.addExtension("tiff");
    }

    public Retrieval() {
        this(null);
    }

    public void setQuery(Region query) {
        this.query = query;
    }

    public void setSJPanel(ScrollableJPanel sjpanel) {
        this.sjpanel = sjpanel;
    }

    public ScrollableJPanel getSJPanel() {
        return this.sjpanel;
    }

    public Vector getObjectDB() {
        return this.objectDB;
    }

    public void setObjectDB(Vector objectDB) {
        this.objectDB = objectDB;
    }

    public void addLocalDB(String path) throws FileNotFoundException, IOException {
        File indexFile = new File(path + File.separator + INDEX_NAME);
        System.out.println(path);
        File[] fileList = FileUtils.ls(path, this.filter);
        BufferedReader reader = new BufferedReader(new FileReader(indexFile));
        for (int i = 0; i < fileList.length; ++i) {
            File f = fileList[i];
            String descriptor = reader.readLine();
            ObjectImage obi = new ObjectImage(descriptor);
            obi.setLocation(f.getAbsolutePath());
            this.objectDB.add(obi);
        }
        reader.close();
        System.out.println("Retrieval: " + this.objectDB.size() + " images in the DB.");
    }

    public Vector retrieveRegions(Region query) {
        this.retrieved.clear();
        for (int i = 0; i < this.objectDB.size(); ++i) {
            ObjectImage obi = (ObjectImage)this.objectDB.get(i);
            obi.setWeights(this.posW, this.volW, this.colW, this.oriW);
            int index = obi.minDistanceRegion(query);
            if (!(obi.getMinDist() < this.regionThreshold)) continue;
            this.retrieved.add(new ValuePair(i, obi.getMinDist(), index, obi.getLocation()));
        }
        Collections.sort(this.retrieved);
        return this.retrieved;
    }

    public void cloneFrom(Retrieval ret) {
        this.setObjectDB(ret.getObjectDB());
        this.setSJPanel(ret.getSJPanel());
        this.colW = ret.colW;
        this.posW = ret.posW;
        this.volW = ret.volW;
        this.oriW = ret.oriW;
    }

    public void clear() {
        this.sjpanel.removeAll();
        this.sjpanel.repaint();
    }

    public void run() {
        try {
            int timeout;
            for (timeout = 0; (this.query == null || this.objectDB.size() == 0) && timeout < 10; ++timeout) {
                Thread.sleep(500L);
            }
            if (timeout < 10) {
                this.retrieveRegions(this.query);
                for (int i = 0; i < 3; ++i) {
                    ValuePair vp = (ValuePair)this.retrieved.get(i);
                    System.out.println("retrieved :" + vp);
                    if (this.sjpanel == null) continue;
                    BufferedImage bim = Utilities.loadImage(ObjectImage.thumbFromLocation(vp.label));
                    BufferedImage original = Utilities.loadImage(vp.label);
                    bim = Utilities.maskIndexedImage(bim, vp.ilabel + 1, original);
                    CompositeButton b = new CompositeButton(new ImageIcon(bim), vp);
                    b.addActionListener(this.sjpanel);
                    this.sjpanel.add(b);
                }
                if (this.sjpanel != null) {
                    this.sjpanel.validate();
                }
            } else {
                String error = "";
                if (this.objectDB.size() == 0) {
                    error = error + "No DB. ";
                }
                if (this.query == null) {
                    error = error + "No query object. ";
                }
                System.err.println("Retrieval thread: timeout! " + error);
            }
        }
        catch (Exception exc) {
            System.err.println("Retrieval thread: " + exc);
        }
    }
}

