/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import titech.db.ImageRetrieval;
import titech.db.Indexer;
import titech.db.Retrieval;
import titech.file.FileUtils;
import titech.image.ScrollableJPanel;
import titech.image.dsp.ObjectImage;
import titech.image.dsp.Segmenter;
import titech.image.matting.Boundary;
import titech.util.Utilities;
import titech.util.ValuePair;
import titech.wt.ClipCanvas;
import titech.wt.CompositeButton;
import titech.wt.CompositeCanvas;
import titech.wt.ModListener;
import titech.wt.SimpleCanvas;
import titech.wt.Task;

public class SketchRC
extends JFrame
implements ChangeListener,
ActionListener,
ModListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle resources;
    public static final String VERSION = "0.92";
    public static final int CANVAS_SIZE = 320;
    public static final int[] COMPOSITE_SIZES;
    public int compositeSize;
    public int defaultSize = 0;
    public static final String[] POISSON_OPTIONS;
    public static final String[] BOUNDARY_OPTIONS;
    public static final String[] GRADIENT_OPTIONS;
    public static final String[] RESOLUTIONS;
    JTextArea textArea;
    PaintCanvas paintCanvas;
    NaviBar naviBar;
    Retrieval retrieval;
    ImageRetrieval imageRetrieval;
    ToolBar toolBar;
    ScrollableJPanel sjpanel;
    ScrollableJPanel isjpanel;
    JFrame retrievalWindow;
    JFrame iretrievalWindow;
    JFrame compositeWindow;
    JFrame clipWindow;
    JFrame parameterWindow;
    JFrame logWindow;
    JFrame debugWindow;
    CompositeCanvas compositeCanvas;
    ClipCanvas clipCanvas;
    JScrollPane scroller;
    SimpleCanvas debugCanvas;
    JTextField keywordField;
    JSlider colorSlider;
    JSlider icolorSlider;
    JSlider posSlider;
    JSlider iposSlider;
    JSlider volSlider;
    JSlider ivolSlider;
    JSlider oriSlider;
    JSlider ioriSlider;
    JComboBox poissonCombo;
    JComboBox boundaryCombo;
    JComboBox gradientCombo;
    JMenuBar menuBar;
    JFileChooser fc;
    JButton clipBigger;
    JButton clipSmaller;
    JSlider clipStrokeSlider;
    JCheckBox alphaCheck;
    JSlider gradientMixSlider;
    JSlider accuracySlider;
    Boundary boundary;
    Thread thread;
    Segmenter segmenter;
    Timer timer = new Timer(1000, new TimerListener());
    Task task;
    ProgressMonitor progressMonitor;
    private boolean macOS = System.getProperty("os.name").contains("Mac");
    private Hashtable<String, JMenuItem> menuItems;

    public SketchRC() {
        this(COMPOSITE_SIZES[0]);
    }

    public SketchRC(int compSize) {
        this.compositeSize = compSize;
        this.boundary = null;
        this.thread = null;
        this.segmenter = new Segmenter();
        this.fc = new JFileChooser(System.getProperty("user.home"));
        this.textArea = new JTextArea(3, 20);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        JScrollPane pane = new JScrollPane(this.textArea);
        this.logWindow = new JFrame();
        this.logWindow.setTitle("Log");
        this.logWindow.add(pane);
        this.logWindow.pack();
        this.naviBar = new NaviBar();
        this.naviBar.setLog(this.textArea);
        this.paintCanvas = new PaintCanvas(320);
        this.toolBar = new ToolBar();
        this.toolBar.setPaintCanvas(this.paintCanvas);
        this.toolBar.setParentWindow(this);
        this.toolBar.setLog(this.textArea);
        this.naviBar.setToolBar(this.toolBar);
        this.toolBar.setMode(2);
        JSeparator jsep1 = new JSeparator(1);
        jsep1.setPreferredSize(new Dimension(10, 10));
        JSeparator jsep2 = new JSeparator(1);
        jsep2.setPreferredSize(new Dimension(10, 10));
        JPanel keywordPanel = new JPanel();
        keywordPanel.add(new JLabel("Keyword: "));
        this.keywordField = new JTextField(20);
        keywordPanel.add(this.keywordField);
        JPanel jpe = new JPanel(new BorderLayout());
        jpe.add((Component)this.paintCanvas, "Center");
        JPanel tools = new JPanel(new BorderLayout());
        tools.add((Component)this.toolBar, "Center");
        tools.add((Component)keywordPanel, "South");
        jpe.add((Component)tools, "South");
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)jsep1, "West");
        jp.add((Component)jpe, "Center");
        jpe.add((Component)jsep2, "East");
        Container contentPane = this.getContentPane();
        contentPane.add(jp);
        this.menuItems = new Hashtable();
        this.menuBar = this.createMenuBar();
        if (this.macOS) {
            this.setJMenuBar(this.menuBar);
        } else {
            tools.add((Component)this.menuBar, "North");
        }
        this.compositeWindow = new JFrame();
        this.compositeWindow.setTitle("Composite");
        this.compositeCanvas = new CompositeCanvas(this.compositeSize);
        this.compositeCanvas.maxObjectWidth = this.compositeSize;
        this.compositeCanvas.maxObjectHeight = this.compositeSize;
        this.compositeCanvas.setModListener(this);
        this.compositeWindow.add(this.compositeCanvas);
        this.compositeWindow.pack();
        this.clipCanvas = new ClipCanvas(this.compositeSize);
        this.clipCanvas.setModListener(this);
        JPanel clipPanel = new JPanel(new BorderLayout());
        clipPanel.add((Component)this.clipCanvas, "Center");
        this.clipWindow = new JFrame();
        this.clipWindow.setTitle("Clipping");
        this.clipWindow.add(clipPanel);
        this.clipWindow.pack();
        this.sjpanel = new ScrollableJPanel(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                try {
                    String name = e.getSource().getClass().getSimpleName();
                    if (name.equals("CompositeButton")) {
                        CompositeButton b = (CompositeButton)e.getSource();
                        ValuePair vp = b.getValuePair();
                        if ((e.getModifiers() & 1) != 0) {
                            SketchRC.this.newf(vp.label);
                        } else {
                            SketchRC.this.addToClipCanvas(vp);
                        }
                    } else if (name.equals("JButton")) {
                        JButton source = (JButton)e.getSource();
                        SketchRC.this.sjpanel.remove(source.getParent().getParent().getParent());
                        SketchRC.this.retrievalWindow.validate();
                    }
                }
                catch (Exception exc) {
                    System.out.println(exc);
                }
            }
        };
        this.scroller = new JScrollPane(this.sjpanel, 20, 31);
        this.retrievalWindow = new JFrame();
        this.retrievalWindow.setTitle("Retrieval");
        this.retrievalWindow.setLayout(new BorderLayout());
        this.retrievalWindow.add((Component)this.scroller, "Center");
        this.setParameterWindow();
        this.isjpanel = new ScrollableJPanel(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                try {
                    if (e.getSource().getClass().getSimpleName().equals("CompositeButton")) {
                        CompositeButton b = (CompositeButton)e.getSource();
                        ValuePair vp = b.getValuePair();
                        if ((e.getModifiers() & 1) != 0) {
                            SketchRC.this.newf(vp.label);
                        } else {
                            SketchRC.this.addToClipCanvas(vp);
                        }
                    }
                }
                catch (Exception exc) {
                    System.out.println(exc);
                }
            }
        };
        JScrollPane iscroller = new JScrollPane(this.isjpanel, 21, 30);
        iscroller.setPreferredSize(new Dimension(360, 200));
        this.iretrievalWindow = new JFrame();
        this.iretrievalWindow.setTitle("Image match");
        this.iretrievalWindow.setLayout(new BorderLayout());
        this.iretrievalWindow.add((Component)iscroller, "Center");
        this.iretrievalWindow.pack();
        this.debugCanvas = new SimpleCanvas(this.compositeSize);
        this.debugWindow = new JFrame();
        this.debugWindow.setTitle("Debug");
        this.debugWindow.add(this.debugCanvas);
        this.debugWindow.pack();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SketchRC.this.exitAction();
            }
        });
    }

    void setParameterWindow() {
        this.parameterWindow = new JFrame();
        this.parameterWindow.setTitle("Parameters");
        JTabbedPane tabbedPane = new JTabbedPane();
        JLabel lb1 = new JLabel("Object substraction");
        Font font = lb1.getFont();
        Font smallerFont = new Font(font.getFamily(), 1, 10);
        tabbedPane.setFont(smallerFont);
        this.boundaryCombo = new JComboBox<String>(BOUNDARY_OPTIONS);
        this.boundaryCombo.setSelectedIndex(2);
        this.boundaryCombo.addActionListener(this);
        this.gradientCombo = new JComboBox<String>(GRADIENT_OPTIONS);
        this.gradientCombo.addActionListener(this);
        JLabel lb2 = new JLabel("Optimization criterium");
        lb2.setFont(smallerFont);
        lb1.setFont(smallerFont);
        JSeparator sb1 = new JSeparator();
        JLabel lb3 = new JLabel("Clip Window size");
        lb3.setFont(smallerFont);
        this.clipBigger = new JButton("+");
        this.clipSmaller = new JButton("-");
        this.clipBigger.setFont(smallerFont);
        this.clipSmaller.setFont(smallerFont);
        this.clipBigger.addActionListener(this);
        this.clipSmaller.addActionListener(this);
        JLabel lb4 = new JLabel("Stroke size");
        lb4.setFont(smallerFont);
        this.clipStrokeSlider = new JSlider(5, 80, 50);
        this.clipStrokeSlider.addChangeListener(this);
        GridBagLayout gbBoundary = new GridBagLayout();
        GridBagConstraints cBoundary = new GridBagConstraints();
        JPanel boundaryPanel = new JPanel(gbBoundary);
        cBoundary.gridwidth = 0;
        cBoundary.weightx = 1.0;
        gbBoundary.setConstraints(lb1, cBoundary);
        gbBoundary.setConstraints(this.boundaryCombo, cBoundary);
        gbBoundary.setConstraints(lb2, cBoundary);
        gbBoundary.setConstraints(this.gradientCombo, cBoundary);
        cBoundary.fill = 2;
        gbBoundary.setConstraints(sb1, cBoundary);
        cBoundary.fill = 0;
        cBoundary.gridwidth = 1;
        gbBoundary.setConstraints(lb3, cBoundary);
        gbBoundary.setConstraints(this.clipBigger, cBoundary);
        cBoundary.gridwidth = 0;
        gbBoundary.setConstraints(this.clipSmaller, cBoundary);
        cBoundary.gridwidth = 1;
        gbBoundary.setConstraints(lb4, cBoundary);
        cBoundary.gridwidth = 0;
        cBoundary.fill = 2;
        gbBoundary.setConstraints(this.clipStrokeSlider, cBoundary);
        boundaryPanel.add(lb1);
        boundaryPanel.add(this.boundaryCombo);
        boundaryPanel.add(lb2);
        boundaryPanel.add(this.gradientCombo);
        boundaryPanel.add(sb1);
        boundaryPanel.add(lb3);
        boundaryPanel.add(this.clipBigger);
        boundaryPanel.add(this.clipSmaller);
        boundaryPanel.add(lb4);
        boundaryPanel.add(this.clipStrokeSlider);
        this.poissonCombo = new JComboBox<String>(POISSON_OPTIONS);
        this.poissonCombo.addActionListener(this);
        this.gradientMixSlider = new JSlider(1, 200, 50);
        this.gradientMixSlider.addChangeListener(this);
        this.accuracySlider = new JSlider(1, 100, 50);
        this.accuracySlider.addChangeListener(this);
        this.alphaCheck = new JCheckBox("Alpha", false);
        this.alphaCheck.addItemListener(this);
        JLabel l1 = new JLabel("Poisson");
        l1.setFont(smallerFont);
        JLabel l2 = new JLabel("Accuracy");
        l2.setFont(smallerFont);
        JLabel l3 = new JLabel("Mixture amount");
        l3.setFont(smallerFont);
        JSeparator s1 = new JSeparator();
        GridBagLayout gbBlend = new GridBagLayout();
        GridBagConstraints cBlend = new GridBagConstraints();
        JPanel blendPanel = new JPanel(gbBlend);
        cBlend.gridwidth = 0;
        cBlend.weightx = 1.0;
        gbBlend.setConstraints(l1, cBlend);
        gbBlend.setConstraints(this.poissonCombo, cBlend);
        gbBlend.setConstraints(l2, cBlend);
        cBlend.fill = 2;
        gbBlend.setConstraints(this.accuracySlider, cBlend);
        cBlend.fill = 0;
        gbBlend.setConstraints(l3, cBlend);
        cBlend.fill = 2;
        gbBlend.setConstraints(this.gradientMixSlider, cBlend);
        gbBlend.setConstraints(s1, cBlend);
        cBlend.fill = 0;
        gbBlend.setConstraints(this.alphaCheck, cBlend);
        blendPanel.add(l1);
        blendPanel.add(this.poissonCombo);
        blendPanel.add(l2);
        blendPanel.add(this.accuracySlider);
        blendPanel.add(l3);
        blendPanel.add(this.gradientMixSlider);
        blendPanel.add(s1);
        blendPanel.add(this.alphaCheck);
        GridBagLayout gbRetrieval = new GridBagLayout();
        GridBagConstraints cRetrieval = new GridBagConstraints();
        JPanel retrievalPanel = new JPanel(gbRetrieval);
        this.iposSlider = new JSlider(0, 100, (int)(100.0 * ImageRetrieval.DEFAULT_WEIGHTS[0]));
        this.ivolSlider = new JSlider(0, 100, (int)(100.0 * ImageRetrieval.DEFAULT_WEIGHTS[1]));
        this.ioriSlider = new JSlider(0, 100, (int)(100.0 * ImageRetrieval.DEFAULT_WEIGHTS[2]));
        this.icolorSlider = new JSlider(0, 200, (int)(100.0 * ImageRetrieval.DEFAULT_WEIGHTS[3]));
        this.icolorSlider.addChangeListener(this);
        this.iposSlider.addChangeListener(this);
        this.ivolSlider.addChangeListener(this);
        this.ioriSlider.addChangeListener(this);
        this.colorSlider = new JSlider(0, 100, 25);
        this.posSlider = new JSlider(0, 100, 12);
        this.volSlider = new JSlider(0, 100, 25);
        this.oriSlider = new JSlider(0, 100, 25);
        this.colorSlider.addChangeListener(this);
        this.posSlider.addChangeListener(this);
        this.volSlider.addChangeListener(this);
        this.oriSlider.addChangeListener(this);
        Dimension minSize = new Dimension(90, 30);
        this.colorSlider.setPreferredSize(minSize);
        this.posSlider.setPreferredSize(minSize);
        this.volSlider.setPreferredSize(minSize);
        this.oriSlider.setPreferredSize(minSize);
        this.icolorSlider.setPreferredSize(minSize);
        this.iposSlider.setPreferredSize(minSize);
        this.ivolSlider.setPreferredSize(minSize);
        this.ioriSlider.setPreferredSize(minSize);
        JLabel lr1 = new JLabel("Feature");
        lr1.setFont(smallerFont);
        JLabel lr2 = new JLabel("Image");
        lr2.setFont(smallerFont);
        JLabel lr3 = new JLabel("Object");
        lr3.setFont(smallerFont);
        JSeparator sr1 = new JSeparator();
        JLabel icolorLabel = new JLabel("color", 0);
        icolorLabel.setFont(smallerFont);
        JLabel iposLabel = new JLabel("x,y", 0);
        iposLabel.setFont(smallerFont);
        JLabel ivolLabel = new JLabel("volume", 0);
        ivolLabel.setFont(smallerFont);
        JLabel ioriLabel = new JLabel("shape", 0);
        ioriLabel.setFont(smallerFont);
        cRetrieval.weightx = 1.0;
        cRetrieval.gridwidth = 1;
        cRetrieval.fill = 0;
        gbRetrieval.setConstraints(lr1, cRetrieval);
        gbRetrieval.setConstraints(lr2, cRetrieval);
        cRetrieval.gridwidth = 0;
        gbRetrieval.setConstraints(lr3, cRetrieval);
        cRetrieval.fill = 2;
        gbRetrieval.setConstraints(sr1, cRetrieval);
        cRetrieval.gridwidth = 1;
        gbRetrieval.setConstraints(icolorLabel, cRetrieval);
        cRetrieval.fill = 2;
        gbRetrieval.setConstraints(this.icolorSlider, cRetrieval);
        cRetrieval.gridwidth = 0;
        gbRetrieval.setConstraints(this.colorSlider, cRetrieval);
        cRetrieval.gridwidth = 1;
        cRetrieval.fill = 0;
        gbRetrieval.setConstraints(iposLabel, cRetrieval);
        cRetrieval.fill = 2;
        gbRetrieval.setConstraints(this.iposSlider, cRetrieval);
        cRetrieval.gridwidth = 0;
        gbRetrieval.setConstraints(this.posSlider, cRetrieval);
        cRetrieval.gridwidth = 1;
        cRetrieval.fill = 0;
        gbRetrieval.setConstraints(ivolLabel, cRetrieval);
        cRetrieval.fill = 2;
        gbRetrieval.setConstraints(this.ivolSlider, cRetrieval);
        cRetrieval.gridwidth = 0;
        gbRetrieval.setConstraints(this.volSlider, cRetrieval);
        cRetrieval.gridwidth = 1;
        cRetrieval.fill = 0;
        gbRetrieval.setConstraints(ioriLabel, cRetrieval);
        cRetrieval.fill = 2;
        gbRetrieval.setConstraints(this.ioriSlider, cRetrieval);
        cRetrieval.gridwidth = 0;
        gbRetrieval.setConstraints(this.oriSlider, cRetrieval);
        retrievalPanel.add(lr1);
        retrievalPanel.add(lr2);
        retrievalPanel.add(lr3);
        retrievalPanel.add(sr1);
        retrievalPanel.add(icolorLabel);
        retrievalPanel.add(this.icolorSlider);
        retrievalPanel.add(this.colorSlider);
        retrievalPanel.add(iposLabel);
        retrievalPanel.add(this.iposSlider);
        retrievalPanel.add(this.posSlider);
        retrievalPanel.add(ivolLabel);
        retrievalPanel.add(this.ivolSlider);
        retrievalPanel.add(this.volSlider);
        retrievalPanel.add(ioriLabel);
        retrievalPanel.add(this.ioriSlider);
        retrievalPanel.add(this.oriSlider);
        tabbedPane.addTab("Boundary", boundaryPanel);
        tabbedPane.addTab("Blending", blendPanel);
        tabbedPane.addTab("Retrieval", retrievalPanel);
        JPanel container = new JPanel(new GridLayout(1, 1));
        container.add(tabbedPane);
        this.parameterWindow.add((Component)container, "Center");
        this.parameterWindow.pack();
    }

    void addToClipCanvas(ValuePair vp) throws IOException, InterruptedException {
        BufferedImage bim = Utilities.loadImage(ObjectImage.thumbFromLocation(vp.label));
        BufferedImage original = Utilities.loadImage(vp.label);
        BufferedImage ccat = Utilities.loadImage(ObjectImage.ccatFromLocation(vp.label));
        this.addToClipCanvas(bim, original, ccat, vp.ilabel);
        System.out.println(vp);
    }

    void addToClipCanvas(BufferedImage bim, BufferedImage original, BufferedImage ccat, int index) throws IOException, InterruptedException {
        Dimension resized = Utilities.resizeDimension(original, this.compositeSize);
        this.clipCanvas.setMaxSize(resized);
        this.clipCanvas.setImage(original);
        if (index >= 0) {
            this.boundary = new Boundary(bim, index + 1, resized, this.clipCanvas.getClipArea());
            this.boundary.setPoissonType(this.poissonCombo.getSelectedIndex());
            this.boundary.setPoissonParameters(this.getMixtureValue(), this.getAccuracyValue());
            this.boundary.setComposite(this.compositeCanvas);
            this.boundary.setCanvas(this.clipCanvas);
            this.boundary.setDebugCanvas(this.debugCanvas);
            this.boundary.setSource(this.clipCanvas.getImage());
            this.boundary.setTarget(this.compositeCanvas.getImage());
            this.boundary.setSegmented(ccat);
            this.boundary.setMethod(this.boundaryCombo.getSelectedIndex());
            this.boundary.alphaMatting = this.alphaCheck.isSelected();
            this.compositeCanvas.add(this.boundary.maskImage());
            if (this.thread != null) {
                this.thread.join();
            }
            this.thread = new Thread(this.boundary);
            this.thread.start();
        } else {
            this.fullclip();
            this.boundary = new Boundary(bim, 0, resized, this.clipCanvas.getClipArea());
            this.boundary.setPoissonType(this.poissonCombo.getSelectedIndex());
            this.boundary.setPoissonParameters(this.getMixtureValue(), this.getAccuracyValue());
            this.boundary.setComposite(this.compositeCanvas);
            this.boundary.setCanvas(this.clipCanvas);
            this.boundary.setDebugCanvas(this.debugCanvas);
            this.boundary.setSource(this.clipCanvas.getClippedImage());
            this.boundary.setTarget(this.compositeCanvas.getImage());
            this.boundary.setSegmented(ccat);
            this.boundary.setMethod(this.boundaryCombo.getSelectedIndex());
            this.boundary.alphaMatting = this.alphaCheck.isSelected();
        }
    }

    public void arrangeWindows() {
        Utilities.placeRight(this.compositeWindow);
        Utilities.placeBelow(this.clipWindow, this.compositeWindow);
        Utilities.fitBetween(this.retrievalWindow, this, this.compositeWindow, 320);
        Utilities.placeBelow(this.iretrievalWindow, this);
        Utilities.placeBottomLeft(this.parameterWindow);
        this.sjpanel.setPreferredSize(new Dimension(this.retrievalWindow.getWidth() - 18, 2000));
        this.retrieval.setWidth(this.retrievalWindow.getWidth() - 18);
        this.retrievalWindow.setVisible(true);
        this.clipWindow.setVisible(true);
        this.compositeWindow.setVisible(true);
        this.iretrievalWindow.setVisible(true);
        this.parameterWindow.setVisible(true);
    }

    public void fullclip() {
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException exc) {
                System.err.println("clip: " + exc);
            }
        }
        this.boundary = null;
        this.compositeCanvas.add(this.clipCanvas.getClippedImage());
    }

    public void clip() {
        if (this.boundary != null) {
            if (this.thread != null) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException exc) {
                    System.err.println("clip: " + exc);
                }
            }
            this.boundary.setExternalContour(this.clipCanvas.getContour());
            this.clipCanvas.moved = false;
            this.thread = new Thread(this.boundary);
            this.thread.start();
        }
    }

    public void shifted() {
        if (this.boundary != null) {
            if (this.thread != null) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException exc) {
                    System.err.println("clip: " + exc);
                }
            }
            this.clipCanvas.moved = false;
            this.boundary.update(this.clipCanvas.getClipArea());
            this.boundary.clearExternalContour();
            this.thread = new Thread(this.boundary);
            this.thread.start();
        }
    }

    public void moved() {
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException exc) {
                System.err.println("clip: " + exc);
            }
        }
        this.clipCanvas.moved = false;
        this.boundary.setExternalContour(this.clipCanvas.getContour());
        this.thread = new Thread(this.boundary);
        this.thread.start();
    }

    public void imageRetrieved() {
        this.iretrievalWindow.validate();
    }

    double getMixtureValue() {
        return (double)this.gradientMixSlider.getValue() / 100.0;
    }

    double getAccuracyValue() {
        return (double)this.accuracySlider.getValue() / 1000.0;
    }

    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.gradientMixSlider || src == this.accuracySlider) {
            if (this.boundary != null) {
                this.boundary.setPoissonParameters(this.getMixtureValue(), this.getAccuracyValue());
                if (this.poissonCombo.getSelectedIndex() == 3) {
                    this.moved();
                }
            }
        } else if (src == this.clipStrokeSlider) {
            this.clipCanvas.setStroke(this.clipStrokeSlider.getValue());
        } else if (this.retrieval != null) {
            if (src == this.colorSlider) {
                this.retrieval.colW = (double)this.colorSlider.getValue() / (double)this.colorSlider.getMaximum() / 4.0;
            } else if (src == this.posSlider) {
                this.retrieval.posW = (double)this.posSlider.getValue() / (double)this.posSlider.getMaximum() / 4.0;
            } else if (src == this.volSlider) {
                this.retrieval.volW = (double)this.volSlider.getValue() / (double)this.volSlider.getMaximum() / 4.0;
            } else if (src == this.oriSlider) {
                this.retrieval.oriW = (double)this.oriSlider.getValue() / (double)this.oriSlider.getMaximum() / 4.0;
            } else if (src == this.icolorSlider) {
                this.imageRetrieval.colW = 2.0 * (double)this.icolorSlider.getValue() / (double)this.icolorSlider.getMaximum();
            } else if (src == this.iposSlider) {
                this.imageRetrieval.posW = (double)this.iposSlider.getValue() / (double)this.iposSlider.getMaximum();
            } else if (src == this.ivolSlider) {
                this.imageRetrieval.volW = (double)this.ivolSlider.getValue() / (double)this.ivolSlider.getMaximum();
            } else if (src == this.ioriSlider) {
                this.imageRetrieval.oriW = (double)this.ioriSlider.getValue() / (double)this.ioriSlider.getMaximum();
            }
        } else {
            System.err.println("SketchRC: No Retrieval object!");
        }
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.alphaCheck) {
            this.boundary.alphaMatting = this.alphaCheck.isSelected();
            this.moved();
        }
    }

    public void setRetrieval(Retrieval ret) {
        this.retrieval = ret;
        while (this.paintCanvas == null) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exc) {
                System.out.println("SketchRC: " + exc);
            }
        }
        ret.setSJPanel(this.sjpanel);
        ret.setLog(this.textArea);
        ret.setTextField(this.keywordField);
        this.paintCanvas.setRetrieval(ret);
    }

    public void setImageRetrieval(ImageRetrieval iret) {
        this.imageRetrieval = iret;
        while (this.paintCanvas == null) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exc) {
                System.out.println("SketchRC: " + exc);
            }
        }
        iret.setSJPanel(this.isjpanel);
        iret.setModListener(this);
        iret.setLog(this.textArea);
        iret.setTextField(this.keywordField);
        this.paintCanvas.setImageRetrieval(iret);
    }

    public void exitAction() {
        int n = JOptionPane.showOptionDialog(this.getFocusCycleRootAncestor(), "Do you want to save your current collage?", "Before you leave...", 1, 3, null, null, null);
        switch (n) {
            case 0: {
                this.saveAction();
                System.exit(0);
            }
            case 1: {
                System.exit(0);
            }
        }
    }

    public void renderAction() {
    }

    void newCollage(int width, int height) {
        this.compositeCanvas.setbgColor(this.paintCanvas.getbgColor());
        this.compositeCanvas.setSize(width, height);
        this.compositeCanvas.repaint();
        this.compositeWindow.pack();
    }

    void load(String file) throws IOException, InterruptedException {
        BufferedImage original = Utilities.loadImage(file);
        this.segmenter.getKMedianRegions(original);
        this.debugCanvas.add(this.segmenter.getSegmentedImage());
        this.addToClipCanvas(this.segmenter.getSegmentedImage(), original, this.segmenter.getQuantizedImage(), -1);
    }

    void loadSketch(String file) throws IOException, InterruptedException {
        BufferedImage original = Utilities.loadImage(file);
        this.paintCanvas.set(original);
    }

    void save(String file) throws IOException, InterruptedException {
        String format = "png";
        BufferedImage collage = this.compositeCanvas.getCollage();
        Utilities.saveImage(collage, format, file + "." + format);
    }

    void saveSketch(String file) throws IOException, InterruptedException {
        String format = "png";
        BufferedImage sketch = this.paintCanvas.getImage();
        Utilities.saveImage(sketch, format, file + "." + format);
    }

    void newAction() {
        String s = (String)JOptionPane.showInputDialog(this.getFocusCycleRootAncestor(), "Resolution:", "New collage", 3, null, RESOLUTIONS, RESOLUTIONS[0]);
        if (s != null && s.length() > 0) {
            StringTokenizer stk = new StringTokenizer(s, "x");
            this.newCollage(Integer.parseInt(stk.nextToken()), Integer.parseInt(stk.nextToken()));
        }
    }

    void loadAction() {
        try {
            this.fc.setFileSelectionMode(2);
            this.fc.setDialogType(0);
            int returnVal = this.fc.showOpenDialog(this.getFocusCycleRootAncestor());
            if (returnVal == 0) {
                String path = this.fc.getSelectedFile().getAbsolutePath();
                this.load(path);
            } else {
                System.out.println("Open command cancelled by user.");
            }
        }
        catch (Exception e) {
            System.err.println("load: " + e);
        }
    }

    void loadSketchAction() {
        try {
            this.fc.setFileSelectionMode(2);
            this.fc.setDialogType(0);
            int returnVal = this.fc.showOpenDialog(this.getFocusCycleRootAncestor());
            if (returnVal == 0) {
                String path = this.fc.getSelectedFile().getAbsolutePath();
                this.loadSketch(path);
            } else {
                System.out.println("Open command cancelled by user.");
            }
        }
        catch (Exception e) {
            System.err.println("load sketch: " + e);
        }
    }

    void newf(String path) throws IOException {
        BufferedImage original = Utilities.loadImage(path);
        this.newCollage(original.getWidth(), original.getHeight());
        this.compositeCanvas.setBackground(original);
    }

    void newfAction() {
        try {
            this.fc.setFileSelectionMode(2);
            this.fc.setDialogType(0);
            int returnVal = this.fc.showOpenDialog(this.getFocusCycleRootAncestor());
            if (returnVal == 0) {
                String path = this.fc.getSelectedFile().getAbsolutePath();
                this.newf(path);
            } else {
                System.out.println("Open command cancelled by user.");
            }
        }
        catch (Exception e) {
            System.err.println("load: " + e);
        }
    }

    void saveAction() {
        try {
            this.fc.setFileSelectionMode(2);
            this.fc.setDialogType(1);
            int returnVal = this.fc.showSaveDialog(this.getFocusCycleRootAncestor());
            if (returnVal == 0) {
                String path = this.fc.getSelectedFile().getAbsolutePath();
                this.save(path);
            } else {
                System.out.println("Save command cancelled by user.");
            }
        }
        catch (Exception e) {
            System.err.println("save: " + e);
        }
    }

    void saveSketchAction() {
        try {
            this.fc.setFileSelectionMode(2);
            this.fc.setDialogType(1);
            int returnVal = this.fc.showSaveDialog(this.getFocusCycleRootAncestor());
            if (returnVal == 0) {
                String path = this.fc.getSelectedFile().getAbsolutePath();
                this.saveSketch(path);
            } else {
                System.out.println("Save command cancelled by user.");
            }
        }
        catch (Exception e) {
            System.err.println("save sketch: " + e);
        }
    }

    void showAction() {
        Vector<String> locations = this.retrieval.getLocations();
        String locs = "";
        if (this.imageRetrieval != null) {
            locs = locs + this.imageRetrieval.getLength() + " images in the database.\n";
        }
        for (int i = 0; i < locations.size(); ++i) {
            locs = locs + locations.get(i) + "\n";
        }
        JOptionPane.showMessageDialog(this.getFocusCycleRootAncestor(), locs, "List of locations", 1);
    }

    void adddirAction() {
        try {
            this.fc.setFileSelectionMode(1);
            this.fc.setDialogType(0);
            int returnVal = this.fc.showOpenDialog(this.getFocusCycleRootAncestor());
            if (returnVal == 0) {
                String path = this.fc.getSelectedFile().getAbsolutePath();
                this.task = new Indexer(path, this.retrieval, this.imageRetrieval);
                this.progressMonitor = new ProgressMonitor(this.retrievalWindow, "Indexing directory " + path, "", 0, this.task.getLengthOfTask());
                this.progressMonitor.setProgress(0);
                this.progressMonitor.setMillisToDecideToPopup(2000);
                this.task.go();
                this.timer.start();
            } else {
                System.out.println("Open command cancelled by user.");
            }
        }
        catch (Exception e) {
            System.err.println("add folder: " + e);
        }
    }

    void addlocationAction() {
    }

    void addlistAction() {
        try {
            this.fc.setFileSelectionMode(2);
            this.fc.setDialogType(0);
            int returnVal = this.fc.showOpenDialog(this.getFocusCycleRootAncestor());
            if (returnVal == 0) {
                String path = this.fc.getSelectedFile().getAbsolutePath();
                this.task = new Indexer(path, this.retrieval, this.imageRetrieval);
                this.progressMonitor = new ProgressMonitor(this.retrievalWindow, "Indexing directories " + path, "", 0, this.task.getLengthOfTask());
                this.progressMonitor.setProgress(0);
                this.progressMonitor.setMillisToDecideToPopup(2000);
                this.task.go();
                this.timer.start();
            } else {
                System.out.println("Open command cancelled by user.");
            }
        }
        catch (Exception e) {
            System.err.println("add folder: " + e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this.menuItems.get("new") == source) {
            this.newAction();
        } else if (this.menuItems.get("newf") == source) {
            this.newfAction();
        } else if (this.menuItems.get("load") == source) {
            this.loadAction();
        } else if (this.menuItems.get("save") == source) {
            this.saveAction();
        } else if (this.menuItems.get("loads") == source) {
            this.loadSketchAction();
        } else if (this.menuItems.get("saves") == source) {
            this.saveSketchAction();
        } else if (this.menuItems.get("render") == source) {
            this.renderAction();
        } else if (this.menuItems.get("exit") == source) {
            this.exitAction();
        } else if (this.menuItems.get("show") == source) {
            this.showAction();
        } else if (this.menuItems.get("addlist") == source) {
            this.addlistAction();
        } else if (this.menuItems.get("adddir") == source) {
            this.adddirAction();
        } else if (this.menuItems.get("addlocation") == source) {
            this.addlocationAction();
        } else if (this.menuItems.get("continuous") == source) {
            this.toolBar.setContinuousPalette();
        } else if (this.menuItems.get("discrete") == source) {
            this.toolBar.setDiscretePalette();
        } else if (this.menuItems.get("parameters") == source) {
            this.parameterWindow.setVisible(true);
        } else if (this.menuItems.get("iretrieval") == source) {
            this.iretrievalWindow.setVisible(true);
        } else if (this.menuItems.get("retrieval") == source) {
            this.retrievalWindow.setVisible(true);
        } else if (this.menuItems.get("composite") == source) {
            this.compositeWindow.setVisible(true);
        } else if (this.menuItems.get("clip") == source) {
            this.clipWindow.setVisible(true);
        } else if (this.menuItems.get("log") == source) {
            this.logWindow.setVisible(true);
        } else if (this.menuItems.get("debug") == source) {
            this.debugWindow.setVisible(true);
        } else if (source == this.poissonCombo) {
            if (this.boundary != null) {
                this.boundary.setPoissonType(this.poissonCombo.getSelectedIndex());
                this.moved();
            }
        } else if (source == this.boundaryCombo) {
            if (this.boundary != null) {
                this.boundary.setMethod(this.boundaryCombo.getSelectedIndex());
                this.moved();
            }
        } else if (source == this.gradientCombo) {
            if (this.boundary != null) {
                this.boundary.setGradientMethod(this.gradientCombo.getSelectedIndex());
                this.moved();
            }
        } else if (source == this.clipBigger) {
            if (this.defaultSize < COMPOSITE_SIZES.length - 1) {
                ++this.defaultSize;
                this.compositeCanvas.maxObjectWidth = this.compositeSize = COMPOSITE_SIZES[this.defaultSize];
                this.compositeCanvas.maxObjectHeight = this.compositeSize;
                this.clipCanvas.setSize(this.compositeSize, this.compositeSize);
                this.clipWindow.pack();
            }
        } else if (source == this.clipSmaller && this.defaultSize > 0) {
            --this.defaultSize;
            this.compositeCanvas.maxObjectWidth = this.compositeSize = COMPOSITE_SIZES[this.defaultSize];
            this.compositeCanvas.maxObjectHeight = this.compositeSize;
            this.clipCanvas.setSize(this.compositeSize, this.compositeSize);
            this.clipWindow.pack();
        }
    }

    protected String getResourceString(String nm) {
        String str;
        try {
            str = resources.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    protected URL getResource(String key) {
        String name = this.getResourceString(key);
        if (name != null) {
            URL url = this.getClass().getResource(name);
            return url;
        }
        return null;
    }

    protected String[] tokenize(String input) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] cmd = new String[v.size()];
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)v.elementAt(i);
        }
        return cmd;
    }

    protected JMenuItem createMenuItem(String cmd) {
        String lab = this.getResourceString(cmd + "Label");
        String img = this.getResourceString(cmd + "Image");
        JMenuItem mi = img != null ? this.addItem(lab, img) : this.addItem(lab);
        this.menuItems.put(cmd, mi);
        return mi;
    }

    JMenuItem addItem(String s) {
        JMenuItem menuItem = new JMenuItem(s);
        menuItem.addActionListener(this);
        return menuItem;
    }

    JMenuItem addItem(String s, String img) {
        JMenuItem menuItem = new JMenuItem(s, new ImageIcon(img));
        menuItem.addActionListener(this);
        return menuItem;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar mb = new JMenuBar();
        String[] menuKeys = this.tokenize(this.getResourceString("menubar"));
        for (int i = 0; i < menuKeys.length; ++i) {
            JMenu m = this.createMenu(menuKeys[i]);
            if (m == null) continue;
            mb.add(m);
        }
        return mb;
    }

    protected JMenu createMenu(String key) {
        String[] itemKeys = this.tokenize(this.getResourceString(key));
        JMenu menu = new JMenu(this.getResourceString(key + "Label"));
        for (int i = 0; i < itemKeys.length; ++i) {
            if (itemKeys[i].equals("-")) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = this.createMenuItem(itemKeys[i]);
            menu.add(mi);
        }
        return menu;
    }

    public void print(String text) {
        this.textArea.append(text);
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    public static void main(String[] s) {
        ImageRetrieval iret;
        Retrieval ret;
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        catch (Exception e) {
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        }
        SketchRC window = null;
        window = s.length > 1 ? new SketchRC(Integer.parseInt(s[1])) : new SketchRC();
        if (s.length > 0) {
            try {
                ret = new Retrieval();
                iret = new ImageRetrieval();
                File[] recList = FileUtils.lsDirsR(s[0]);
                for (int i = 0; i < recList.length; ++i) {
                    ret.addLocalDB(recList[i].getAbsolutePath());
                    iret.addLocalDB(recList[i].getAbsolutePath());
                }
                window.setRetrieval(ret);
                window.setImageRetrieval(iret);
                File fp = new File(s[0] + File.separator + "thumbs");
                if (!fp.exists()) {
                    fp.mkdir();
                    System.out.println("Created preview directory: " + fp.getAbsolutePath());
                }
            }
            catch (Exception exc) {
                System.err.println("Couldn't read index: " + exc);
            }
        } else {
            ret = new Retrieval();
            iret = new ImageRetrieval();
            window.setRetrieval(ret);
            window.setImageRetrieval(iret);
        }
        String app = resources.getString("Title");
        String ver = System.getProperty("java.version");
        String os = System.getProperty("os.name");
        window.setTitle(app + " v." + VERSION + " [JRE: " + ver + "/" + os + "]");
        window.pack();
        window.setVisible(true);
        window.arrangeWindows();
    }

    static {
        try {
            resources = ResourceBundle.getBundle("resources.SketchRC", Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            System.err.println("resources/SketchRC.properties not found");
            System.exit(1);
        }
        COMPOSITE_SIZES = new int[]{320, 480, 640, 800, 1024};
        POISSON_OPTIONS = new String[]{"OFF", "Gradient import", "Gradient mix", "Weighted gradient", "Alpha"};
        BOUNDARY_OPTIONS = new String[]{"No optimization", "Hard segmentation", "Intelligent Scissors", "Intelligent Band"};
        GRADIENT_OPTIONS = new String[]{"Color difference", "Gradient of the difference"};
        RESOLUTIONS = new String[]{"320x320", "600x800", "640x480", "800x320", "800x480", "800x600", "800x800", "1024x480", "1024x768", "1280x320", "1280x480", "1280x800"};
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            SketchRC.this.progressMonitor.setProgress(SketchRC.this.task.getCurrent());
            String s = SketchRC.this.task.getMessage();
            if (s != null) {
                SketchRC.this.progressMonitor.setNote(s);
            }
            if (SketchRC.this.progressMonitor.isCanceled() || SketchRC.this.task.isDone()) {
                SketchRC.this.progressMonitor.close();
                SketchRC.this.task.halt();
                Toolkit.getDefaultToolkit().beep();
                SketchRC.this.timer.stop();
                if (SketchRC.this.task.isDone()) {
                    SketchRC.this.print(SketchRC.this.task.getMessage() + "\n");
                } else {
                    SketchRC.this.print("Task canceled.\n");
                }
            }
        }
    }
}

