/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToolBar
extends JPanel
implements MouseListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    Color[] palette = new Color[]{new Color(0, 0, 0), new Color(128, 128, 128), new Color(255, 255, 255), new Color(112, 58, 30), new Color(221, 160, 117), new Color(235, 89, 149), new Color(162, 24, 22), new Color(228, 116, 42), new Color(155, 71, 200), new Color(141, 170, 225), new Color(43, 80, 124), new Color(234, 222, 59), new Color(142, 178, 114), new Color(38, 65, 43)};
    public static final int WAIT = 0;
    public static final int BLOCK = 1;
    public static final int PAINT = 2;
    public static final int PALETTE_SIZE = 14;
    public static final int CANVAS_WIDTH = 160;
    public static final int CANVAS_HEIGHT = 160;
    byte[][] colormap;
    JButton[] cbuttons = new JButton[14];
    int selected = 0;
    JButton ccButton;
    ImageIcon[] ccIcon = new ImageIcon[14];
    private BufferedImage ccBuffer;
    public static final int ICON_WIDTH = 28;
    public static final int ICON_HEIGHT = 28;
    PaintCanvas paintCanvas = null;
    Window parentWindow = null;
    JTextArea log = null;
    JSlider strokeSize = new JSlider(5, 80, 50);
    JLabel image = null;
    int mode;

    public BufferedImage getDrawing() {
        if (this.paintCanvas == null) {
            return null;
        }
        return this.paintCanvas.getImage();
    }

    public void setPaintCanvas(PaintCanvas pc) {
        this.paintCanvas = pc;
        this.setMode(this.mode);
    }

    public void setParentWindow(Window pw) {
        this.parentWindow = pw;
    }

    public void setLog(JTextArea l) {
        this.log = l;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
        if (this.paintCanvas != null) {
            switch (mode) {
                case 0: 
                case 1: {
                    this.paintCanvas.block();
                    break;
                }
                case 2: {
                    this.clearCanvas();
                    this.paintCanvas.release();
                }
            }
        }
    }

    public void clearCanvas() {
        this.paintCanvas.setBackColor(this.palette[0]);
        this.paintCanvas.clear();
    }

    public void setPic(Image img) {
        BufferedImage im = Utilities.makeBufferedImage(img);
        int h = im.getHeight() * 160 / im.getWidth();
        img = im.getScaledInstance(160, h, 4);
        this.image.setIcon(new ImageIcon(img));
        this.revalidate();
    }

    private JButton createColorButton(int number) {
        JButton boton = null;
        try {
            if (Class.forName("javax.swing.plaf.metal.MetalLookAndFeel").isInstance(UIManager.getLookAndFeel())) {
                boton = new JButton("");
                boton.setBackground(this.palette[number]);
                boton.setPreferredSize(new Dimension(28, 28));
            } else {
                BufferedImage img = new BufferedImage(24, 23, 1);
                Graphics2D g2 = img.createGraphics();
                g2.setColor(this.palette[number]);
                g2.fillRect(0, 0, 24, 23);
                boton = new JButton(new ImageIcon(img));
                boton.setPreferredSize(new Dimension(32, 33));
            }
            if (boton != null) {
                boton.setActionCommand("" + number);
                boton.addMouseListener(this);
            }
        }
        catch (Exception exc) {
            System.err.println("button: " + exc);
        }
        return boton;
    }

    private void changeColorButton(JButton boton, Color color) {
        try {
            if (Class.forName("javax.swing.plaf.metal.MetalLookAndFeel").isInstance(UIManager.getLookAndFeel())) {
                boton.setBackground(color);
            } else {
                BufferedImage img = new BufferedImage(24, 23, 1);
                Graphics2D g2 = img.createGraphics();
                g2.setColor(color);
                g2.fillRect(0, 0, 24, 23);
                boton.setIcon(new ImageIcon(img));
            }
        }
        catch (Exception exc) {
            System.err.println("button: " + exc);
        }
    }

    public ToolBar() {
        int i;
        this.strokeSize.addChangeListener(this);
        for (int i2 = 0; i2 < 14; ++i2) {
            this.cbuttons[i2] = this.createColorButton(i2);
        }
        this.image = new JLabel();
        this.setContinuousPalette();
        this.ccButton = new JButton(this.ccIcon[0]);
        this.ccButton.addMouseListener(this);
        this.ccBuffer = new BufferedImage(this.ccIcon[0].getIconWidth(), this.ccIcon[0].getIconHeight(), 1);
        this.setccBuffer(this.ccIcon[0]);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints cgb = new GridBagConstraints();
        this.setLayout(gridbag);
        cgb.insets = new Insets(2, 2, 2, 2);
        cgb.weightx = 1.0;
        cgb.gridheight = 1;
        cgb.gridwidth = 1;
        cgb.gridwidth = 0;
        cgb.fill = 2;
        gridbag.setConstraints(this.strokeSize, cgb);
        cgb.fill = 0;
        cgb.gridwidth = 2;
        cgb.gridheight = 2;
        cgb.weighty = 1.0;
        gridbag.setConstraints(this.ccButton, cgb);
        cgb.fill = 2;
        cgb.gridwidth = 1;
        cgb.gridheight = 1;
        int endRow = 0;
        for (i = 0; i < 14; ++i) {
            if (++endRow > 6) {
                endRow = 0;
                cgb.gridwidth = 0;
                gridbag.setConstraints(this.cbuttons[i], cgb);
                cgb.gridwidth = 1;
                continue;
            }
            gridbag.setConstraints(this.cbuttons[i], cgb);
        }
        cgb.gridwidth = 0;
        this.add(this.strokeSize);
        this.add(this.ccButton);
        for (i = 0; i < 14; ++i) {
            this.add(this.cbuttons[i]);
        }
        this.setMode(1);
    }

    public void setDiscretePalette() {
        this.setPalette("K");
    }

    public void setContinuousPalette() {
        this.setPalette("SOM-CC");
    }

    private void setPalette(String loc) {
        int[] order = new int[]{1, 2, 3, 4, 5, 6, 13, 7, 8, 9, 10, 11, 12, 12};
        for (int i = 0; i < 14; ++i) {
            String rr = "/resources/" + loc + order[i] + ".png";
            this.ccIcon[i] = new ImageIcon(this.getClass().getResource(rr));
        }
    }

    public void mouseClicked(MouseEvent me) {
        try {
            JButton jb = (JButton)me.getSource();
            if (jb == this.ccButton) {
                Insets insets = this.ccButton.getMargin();
                int x = me.getX() - insets.left;
                int y = me.getY() - insets.top;
                int n = x < 0 ? 0 : (x = x >= this.ccBuffer.getWidth() ? this.ccBuffer.getWidth() - 1 : x);
                y = y < 0 ? 0 : (y >= this.ccBuffer.getHeight() ? this.ccBuffer.getHeight() - 1 : y);
                Color ccHue = new Color(this.ccBuffer.getRGB(x, y));
                this.changeColorButton(this.cbuttons[this.selected], ccHue);
                this.palette[this.selected] = ccHue;
                this.revalidate();
            } else {
                int i;
                String s = jb.getActionCommand();
                this.selected = i = Integer.parseInt(s);
                this.ccButton.setIcon(this.ccIcon[i]);
                this.setccBuffer(this.ccIcon[i]);
                this.revalidate();
            }
            if (SwingUtilities.isRightMouseButton(me)) {
                this.paintCanvas.setBackColor(this.palette[this.selected]);
                this.paintCanvas.clear();
            } else {
                this.paintCanvas.setPaintColor(this.palette[this.selected]);
            }
        }
        catch (Exception e) {
            this.log.append("Exception " + e + "\n");
        }
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        if (!SwingUtilities.isRightMouseButton(me)) {
            this.mouseClicked(me);
        }
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.strokeSize) {
            this.paintCanvas.setStroke(this.strokeSize.getValue());
        }
    }

    public Image adjustImage(Image img) {
        return img;
    }

    private void setccBuffer(ImageIcon ii) {
        Graphics2D g2d = this.ccBuffer.createGraphics();
        g2d.drawImage(ii.getImage(), 0, 0, this);
    }
}

