/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import titech.image.math.AMath;

public class Utilities {
    private static final Component sComponent = new Component(){};
    private static final MediaTracker sTracker = new MediaTracker(sComponent);
    private static int sID = 0;
    public static float[] D65XYZ = new float[]{0.950166f, 1.0f, 1.087654f};
    public static final String jpeg = "jpeg";
    public static final String jpg = "jpg";
    public static final String gif = "gif";
    public static final String tiff = "tiff";
    public static final String tif = "tif";
    public static final String png = "png";

    public static String getExtension(File f) {
        return Utilities.getExtension(f.getName());
    }

    public static String getExtension(String s) {
        String ext = null;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String clearExtension(String s) {
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            return s.substring(0, i);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForImage(Image image) {
        int id;
        Component component = sComponent;
        synchronized (component) {
            id = sID++;
        }
        sTracker.addImage(image, id);
        try {
            sTracker.waitForID(id);
        }
        catch (InterruptedException ie) {
            return false;
        }
        return !sTracker.isErrorID(id);
    }

    public static Image blockingLoad(String path) {
        Image image = Toolkit.getDefaultToolkit().getImage(path);
        if (!Utilities.waitForImage(image)) {
            return null;
        }
        return image;
    }

    public static BufferedImage loadImage(File f) throws IOException {
        return ImageIO.read(f);
    }

    public static BufferedImage loadImage(String filepath) throws IOException {
        return Utilities.loadImage(new File(filepath));
    }

    public static BufferedImage loadIndexedImage(String filepath) throws Exception {
        return Utilities.loadIndexedImage(new File(filepath));
    }

    public static BufferedImage loadIndexedImage(File f) throws Exception {
        Iterator<ImageReader> itimr = ImageIO.getImageReadersBySuffix(png);
        BufferedImage out = null;
        if (itimr.hasNext()) {
            ImageReader imr = itimr.next();
            imr.setInput(new FileImageInputStream(f));
            ImageReadParam param = imr.getDefaultReadParam();
            param.setDestinationType(imr.getRawImageType(0));
            out = imr.read(0, param);
            System.out.println(out.getColorModel());
        } else {
            System.err.println("Utilities: Can't read PNG files!");
        }
        return out;
    }

    public static void saveImage(BufferedImage img, String format, File f) throws IOException {
        ImageIO.write((RenderedImage)img, format, f);
    }

    public static Image blockingLoad(URL url) {
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        if (!Utilities.waitForImage(image)) {
            return null;
        }
        return image;
    }

    public static BufferedImage makeBufferedImage(Image image) {
        return Utilities.makeBufferedImage(image, 1);
    }

    public static BufferedImage makeBufferedImage(Image image, int imageType) {
        if (!Utilities.waitForImage(image)) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), imageType);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, null, null);
        return bufferedImage;
    }

    public static BufferedImage maskIndexedImage(BufferedImage image, int index, BufferedImage original) {
        return Utilities.maskIndexedImage(image, index, original, true, true);
    }

    public static BufferedImage maskIndexedImage(BufferedImage image, int index, BufferedImage original, boolean togray, boolean rescale) {
        int transparent = 0;
        int noalpha = -16777216;
        Raster rasta = image.getData();
        int minx = rasta.getMinX();
        int miny = rasta.getMinY();
        int width = rasta.getWidth();
        int height = rasta.getHeight();
        BufferedImage source = image;
        if (original != null) {
            source = original;
            if ((original.getWidth() != image.getWidth() || original.getHeight() != image.getHeight()) && rescale) {
                source = Utilities.resize(original, image.getWidth(), image.getHeight());
            }
        }
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), 2);
        int x = 0;
        int y = 0;
        double scalex = (double)width / (double)source.getWidth();
        double scaley = (double)height / (double)source.getHeight();
        for (y = 0; y < source.getHeight(); ++y) {
            for (x = 0; x < source.getWidth(); ++x) {
                int i = minx + (int)((double)x * scalex);
                int j = miny + (int)((double)y * scaley);
                int pixel = rasta.getSample(i, j, 0);
                if (pixel == index) {
                    out.setRGB(x, y, source.getRGB(x, y));
                    continue;
                }
                if (togray) {
                    out.setRGB(x, y, noalpha | Utilities.toGray(source.getRGB(x, y)));
                    continue;
                }
                out.setRGB(x, y, transparent);
            }
        }
        return out;
    }

    public static BufferedImage maskIndexedImage(BufferedImage image, int index) {
        return Utilities.maskIndexedImage(image, index, null);
    }

    public static BufferedImage resize(BufferedImage image, int newSize) {
        double w = image.getWidth();
        double h = image.getHeight();
        double scale = 1.0;
        int newWidth = newSize;
        int newHeight = newSize;
        if (w < h) {
            scale = (double)newWidth / w;
            newHeight = (int)(h * scale);
        } else {
            scale = (double)newHeight / h;
            newWidth = (int)(w * scale);
        }
        BufferedImage result = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g = result.createGraphics();
        AffineTransform xform = AffineTransform.getScaleInstance(scale, scale);
        g.drawRenderedImage(image, xform);
        g.dispose();
        return result;
    }

    public static BufferedImage resize(BufferedImage image, int newWidth, int newHeight) {
        BufferedImage result = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g = result.createGraphics();
        double scaleX = (double)newWidth / (double)image.getWidth();
        double scaleY = (double)newHeight / (double)image.getHeight();
        AffineTransform xform = AffineTransform.getScaleInstance(scaleX, scaleY);
        g.drawRenderedImage(image, xform);
        g.dispose();
        return result;
    }

    public static void colorToGray(BufferedImage image) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = image.getRGB(x, y);
                image.setRGB(x, y, Utilities.toGray(pixel));
            }
        }
    }

    public static int toGray(int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        int gray = (r + g + b) / 3;
        return gray << 16 | gray << 8 | gray;
    }

    public static float[] sRGBtoRGB(float[] srgb) {
        float[] rgb = new float[]{(double)srgb[0] > 0.04045 ? (float)Math.pow(((double)srgb[0] + 0.055) / 1.055, 2.4) : (float)((double)srgb[0] / 12.92), (double)srgb[1] > 0.04045 ? (float)Math.pow(((double)srgb[1] + 0.055) / 1.055, 2.4) : (float)((double)srgb[1] / 12.92), (double)srgb[2] > 0.04045 ? (float)Math.pow(((double)srgb[2] + 0.055) / 1.055, 2.4) : (float)((double)srgb[2] / 12.92)};
        return rgb;
    }

    public static float[] XYZtoLab(float[] xyz) {
        xyz[0] = xyz[0] / D65XYZ[0];
        xyz[1] = xyz[1] / D65XYZ[1];
        xyz[2] = xyz[2] / D65XYZ[2];
        float e = 0.008856452f;
        float k = 903.2963f;
        for (int i = 0; i < 3; ++i) {
            xyz[i] = xyz[i] > e ? (float)Math.pow(xyz[i], 0.3333333333333333) : (float)(((double)(k * xyz[i]) + 16.0) / 116.0);
        }
        float[] Lab = new float[]{116.0f * xyz[1] - 16.0f, 500.0f * (xyz[0] - xyz[1]), 200.0f * (xyz[1] - xyz[2])};
        return Lab;
    }

    public static float[] RGBtoXYZ(float[] rgb) {
        float[][] M = new float[][]{{0.412424f, 0.357579f, 0.180464f}, {0.212656f, 0.715158f, 0.0721856f}, {0.0193324f, 0.119193f, 0.950444f}};
        return AMath.fmultV(rgb, M);
    }

    public static float[] sRGBtoLab(float[] srgb) {
        return Utilities.XYZtoLab(Utilities.RGBtoXYZ(Utilities.sRGBtoRGB(srgb)));
    }

    public static float[] sRGBtoLab(int rgb) {
        float[] srgb = new float[]{(float)((rgb & 0xFF0000) >> 16) / 255.0f, (float)((rgb & 0xFF00) >> 8) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
        return Utilities.XYZtoLab(Utilities.RGBtoXYZ(Utilities.sRGBtoRGB(srgb)));
    }

    public static float[][] loadPaletteLab(InputStream stream) throws FileNotFoundException {
        float[][] labmap = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        Vector<float[]> map = new Vector<float[]>();
        try {
            while (true) {
                String str = br.readLine();
                StringTokenizer tzer = new StringTokenizer(str);
                float[] rgb = new float[3];
                for (int c = 0; c < 3; ++c) {
                    int ii = Integer.parseInt(tzer.nextToken());
                    rgb[c] = (float)ii / 255.0f;
                }
                float[] lab = Utilities.sRGBtoLab(rgb);
                map.add(lab);
            }
        }
        catch (Exception exc) {
            labmap = new float[map.size()][3];
            for (int i = 0; i < map.size(); ++i) {
                float[] lab = (float[])map.get(i);
                for (int c = 0; c < 3; ++c) {
                    labmap[i][c] = lab[c];
                }
            }
            return labmap;
        }
    }

    public static Frame getNonClearingFrame(String name, Component c) {
        final Frame f = new Frame(name){

            public void update(Graphics g) {
                this.paint(g);
            }
        };
        Utilities.sizeContainerToComponent(f, c);
        Utilities.centerFrame(f);
        f.setLayout(new BorderLayout());
        f.add(c, "Center");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                f.dispose();
            }
        });
        return f;
    }

    public static void sizeContainerToComponent(Container container, Component component) {
        if (!container.isDisplayable()) {
            container.addNotify();
        }
        Insets insets = container.getInsets();
        Dimension size = component.getPreferredSize();
        int width = insets.left + insets.right + size.width;
        int height = insets.top + insets.bottom + size.height;
        container.setSize(width, height);
    }

    public static void centerFrame(Frame f) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = f.getSize();
        int x = (screen.width - d.width) / 2;
        int y = (screen.height - d.height) / 2;
        f.setLocation(x, y);
    }

    public static void placeRightTo(Frame f, Frame reference) {
        Dimension d = reference.getSize();
        Point origin = reference.getLocation();
        f.setLocation((int)(origin.getX() + d.getWidth()), (int)origin.getY());
    }

    public static void fitBetween(Frame f, Frame left, Frame right) {
        Dimension d = left.getSize();
        Point origin = left.getLocation();
        Point maxr = right.getLocation();
        f.setSize((int)(maxr.getX() - origin.getX() - d.getWidth()), Toolkit.getDefaultToolkit().getScreenSize().height);
        f.setLocation((int)(origin.getX() + d.getWidth()), (int)origin.getY());
    }

    public static void placeRight(Frame f) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = f.getSize();
        Point origin = f.getLocation();
        f.setLocation((int)((double)screen.width - d.getWidth()), (int)origin.getY());
    }

    public static void placeBelow(Frame f, Frame reference) {
        Dimension d = reference.getSize();
        Point origin = reference.getLocation();
        f.setLocation((int)origin.getX(), (int)(origin.getY() + d.getHeight()));
    }
}

