/*
 * Decompiled with CFR 0.152.
 */
package titech.cluster;

import titech.image.math.AMath;

public class KMeans {
    public static final int MAXITERS = 100;
    int K;
    int[] cAssignment;
    double[][] mu;

    public int[] getAssignments() {
        return this.cAssignment;
    }

    public double[][] getMeans() {
        return this.mu;
    }

    public KMeans(int k, double[][] data) {
        this(k, data, null);
    }

    public KMeans(int k, double[][] data, int[] initialAssignment) {
        this.K = k;
        int n = data.length;
        int d = data[0].length;
        this.mu = new double[k][d];
        if (initialAssignment == null) {
            this.cAssignment = new int[n];
            this.randomInit();
        } else {
            this.cAssignment = initialAssignment;
        }
        this.cluster(k, data);
    }

    void randomInit() {
        for (int i = 0; i < this.cAssignment.length; ++i) {
            this.cAssignment[i] = (int)Math.floor(Math.random() * (double)this.K) + 1;
        }
    }

    void cluster(int k, double[][] data) {
        int n = data.length;
        int d = data[0].length;
        int e = 1;
        int[] count = new int[k];
        double[] dist = new double[k];
        for (int iter = 0; e > 0 && iter < 100; ++iter) {
            int j;
            int v;
            int i;
            for (i = 0; i < k; ++i) {
                count[i] = 0;
                for (v = 0; v < d; ++v) {
                    this.mu[i][v] = 0.0;
                }
            }
            for (j = 0; j < n; ++j) {
                int member = this.cAssignment[j];
                if (member <= 0) continue;
                int n2 = member - 1;
                count[n2] = count[n2] + 1;
                for (int v2 = 0; v2 < d; ++v2) {
                    double[] dArray = this.mu[member - 1];
                    int n3 = v2;
                    dArray[n3] = dArray[n3] + data[j][v2];
                }
            }
            for (i = 0; i < k; ++i) {
                if (count[i] <= 0) continue;
                v = 0;
                while (v < d) {
                    double[] dArray = this.mu[i];
                    int n4 = v++;
                    dArray[n4] = dArray[n4] / (double)count[i];
                }
            }
            e = 0;
            for (j = 0; j < n; ++j) {
                for (int i2 = 0; i2 < k; ++i2) {
                    dist[i2] = 0.0;
                    for (int v3 = 0; v3 < d; ++v3) {
                        int n5 = i2;
                        dist[n5] = dist[n5] + (data[j][v3] - this.mu[i2][v3]) * (data[j][v3] - this.mu[i2][v3]);
                    }
                }
                int clase = 1;
                double min = dist[clase - 1];
                for (int i3 = 1; i3 < k; ++i3) {
                    if (!(dist[i3] < min)) continue;
                    clase = i3 + 1;
                    min = dist[i3];
                }
                if (this.cAssignment[j] != clase) {
                    ++e;
                }
                this.cAssignment[j] = clase;
            }
        }
    }

    public static void main(String[] s) {
        double[][] data = new double[7][2];
        for (int i = 0; i < 7; ++i) {
            data[i][0] = i;
            data[i][1] = Math.sin(i);
        }
        KMeans cluster = new KMeans(2, data);
        System.out.println(AMath.showMatrix(cluster.getMeans()));
        System.out.println(AMath.showVector(cluster.getAssignments()));
    }
}

