/*
 * Decompiled with CFR 0.152.
 */
package titech.db;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import titech.file.FileUtils;
import titech.file.ImageFileFilter;
import titech.image.ScrollableJPanel;
import titech.image.dsp.ObjectImage;
import titech.image.math.AMath;
import titech.util.Utilities;
import titech.util.ValuePair;
import titech.wt.CompositeButton;
import titech.wt.ModListener;

public class ImageRetrieval
implements Runnable {
    public static final String INDEX_NAME = ".histogram";
    public static final String THUMBSDIR = ".bthumbs";
    public static final double[] DEFAULT_WEIGHTS = new double[]{0.840067, 0.438318, 0.015638, 1.125841};
    private int[] equivalences = new int[]{0, 1, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10};
    public static final int TIMEOUT = 10;
    public double threshold = 1.0;
    public int maxImages = 10;
    ImageFileFilter filter;
    double[][] imageDB = null;
    double[][] univHistoDB;
    String[] paths;
    Vector retrieved;
    public double posW = DEFAULT_WEIGHTS[0];
    public double volW = DEFAULT_WEIGHTS[1];
    public double oriW = DEFAULT_WEIGHTS[2];
    public double colW = DEFAULT_WEIGHTS[3];
    double[] query;
    ScrollableJPanel sjpanel;
    ModListener modListener;
    JTextArea log = null;
    JTextField textField = null;

    public ImageRetrieval(double[] query) {
        this.retrieved = new Vector();
        this.query = query;
        this.filter = new ImageFileFilter();
        this.filter.addExtension("jpg");
        this.filter.addExtension("png");
        this.filter.addExtension("jpeg");
        this.filter.addExtension("bmp");
        this.filter.addExtension("tiff");
    }

    public ImageRetrieval() {
        this(null);
    }

    public int getLength() {
        if (this.paths == null) {
            return 0;
        }
        return this.paths.length;
    }

    public void setTextField(JTextField textField) {
        this.textField = textField;
    }

    public void setLog(JTextArea l) {
        this.log = l;
    }

    public void setModListener(ModListener modListener) {
        this.modListener = modListener;
    }

    public void setQuery(double[] query) {
        this.query = query;
    }

    public void setSJPanel(ScrollableJPanel sjpanel) {
        this.sjpanel = sjpanel;
    }

    public ScrollableJPanel getSJPanel() {
        return this.sjpanel;
    }

    public double[][] getImageDB() {
        return this.imageDB;
    }

    public void setImageDB(double[][] imageDB) {
        this.imageDB = imageDB;
    }

    public void addLocalDB(String path) throws FileNotFoundException, IOException {
        int i;
        File indexFile = new File(path + File.separator + INDEX_NAME);
        this.print(path);
        File[] fileList = FileUtils.ls(path, this.filter);
        BufferedReader reader = new BufferedReader(new FileReader(indexFile));
        int initialSize = 0;
        if (this.imageDB != null) {
            initialSize = this.imageDB.length;
        }
        double[][] idb = new double[initialSize + fileList.length][];
        double[][] hdb = new double[initialSize + fileList.length][];
        String[] ps = new String[initialSize + fileList.length];
        for (i = 0; i < fileList.length; ++i) {
            File f = fileList[i];
            String descriptor = reader.readLine();
            idb[initialSize + i] = AMath.vectorDouble(descriptor);
            hdb[initialSize + i] = this.universalHistogram(idb[initialSize + i]);
            ps[initialSize + i] = f.getAbsolutePath();
        }
        if (initialSize > 0) {
            for (i = 0; i < initialSize; ++i) {
                idb[i] = this.imageDB[i];
                hdb[i] = this.univHistoDB[i];
                ps[i] = this.paths[i];
            }
        }
        this.imageDB = idb;
        this.univHistoDB = hdb;
        this.paths = ps;
        reader.close();
        this.print("ImageRetrieval: " + this.imageDB.length + " images in the DB.");
    }

    double[] universalHistogram(double[] h) {
        double[] univHisto = new double[11];
        for (int i = 0; i < 52; ++i) {
            int cat;
            int n = cat = this.equivalences[i];
            univHisto[n] = univHisto[n] + h[22 + i];
        }
        return univHisto;
    }

    public void clear() {
        this.sjpanel.removeAll();
        this.sjpanel.repaint();
    }

    public void run() {
        try {
            for (int timeout = 0; (this.query == null || this.imageDB == null) && timeout < 10; ++timeout) {
                Thread.sleep(500L);
            }
            String keyword = this.textField == null ? "" : this.textField.getText();
            long time = System.currentTimeMillis();
            TreeMap<Double, Integer> treemap = new TreeMap<Double, Integer>();
            for (int i = 0; i < this.imageDB.length; ++i) {
                double univdist;
                double cdist;
                double sdist;
                double vdist;
                double pdist;
                double distance;
                if (keyword != "" && !this.paths[i].contains(keyword) || !((distance = this.posW * (pdist = AMath.distance(this.query, this.imageDB[i], 0, 8)) + this.volW * (vdist = AMath.distance(this.query, this.imageDB[i], 9, 18)) + this.oriW * (sdist = AMath.distance(this.query, this.imageDB[i], 19, 21)) + this.colW * (cdist = AMath.distance(this.query, this.imageDB[i], 22, this.query.length - 1)) * (univdist = AMath.distance(this.universalHistogram(this.query), this.univHistoDB[i]))) < this.threshold)) continue;
                treemap.put(new Double(distance), new Integer(i));
            }
            time = System.currentTimeMillis() - time;
            double t = (double)time / 1000.0;
            this.print("Image query time: " + t + " secs.");
            if (this.sjpanel != null) {
                this.clear();
                String minmax = "";
                Double k = null;
                for (int i = 0; i < this.maxImages && treemap.size() > 0; ++i) {
                    k = (Double)treemap.firstKey();
                    Integer v = (Integer)treemap.remove(k);
                    if (i == 0) {
                        minmax = minmax + k;
                    }
                    String loc = this.paths[v];
                    String preview = ObjectImage.previewFromLocation(loc);
                    File fp = new File(preview);
                    BufferedImage icon = null;
                    if (fp.exists()) {
                        icon = Utilities.loadImage(preview);
                    } else {
                        icon = Utilities.resize(Utilities.loadImage(loc), 120);
                        Utilities.saveImage(icon, Utilities.getExtension(loc), fp);
                    }
                    ValuePair vp = new ValuePair(0, 0.0, -1, loc);
                    CompositeButton b = new CompositeButton(new ImageIcon(icon), vp);
                    b.addActionListener(this.sjpanel);
                    this.sjpanel.add(b);
                }
                minmax = minmax + ", " + k;
                this.print("Image distance interval: (" + minmax + ")");
                if (this.modListener != null) {
                    this.modListener.imageRetrieved();
                } else {
                    this.sjpanel.validate();
                }
            }
        }
        catch (Exception exc) {
            this.print("ImageRetrieval thread: " + exc);
        }
    }

    public void print(String text) {
        if (this.log == null) {
            System.out.println(text);
        } else {
            this.log.append(text + "\n");
            this.log.setCaretPosition(this.log.getDocument().getLength());
        }
    }
}

