/*
 * Decompiled with CFR 0.152.
 */
package titech.db;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import titech.db.ImageRetrieval;
import titech.db.Retrieval;
import titech.file.FileUtils;
import titech.file.ImageFileFilter;
import titech.image.dsp.ObjectImage;
import titech.image.dsp.Segmenter;
import titech.image.math.AMath;
import titech.util.Utilities;
import titech.wt.Task;

public class Indexer
implements Runnable,
Task {
    String path;
    boolean done;
    boolean halt;
    String statMessage;
    int current;
    ImageFileFilter filter;
    File[] fileList;
    File locationList;
    ImageRetrieval iretrieval;
    Retrieval retrieval;
    private boolean isDirectory;
    private boolean rebuild;

    public Indexer(String path) {
        this(path, null, null);
    }

    public Indexer(String path, Retrieval retrieval, ImageRetrieval iretrieval) {
        this.path = path;
        this.retrieval = retrieval;
        this.iretrieval = iretrieval;
        this.isDirectory = false;
        this.rebuild = false;
        this.done = false;
        this.halt = false;
        this.current = 0;
        this.filter = new ImageFileFilter();
        this.filter.addExtension("jpg");
        this.filter.addExtension("png");
        this.filter.addExtension("jpeg");
        this.filter.addExtension("bmp");
        this.filter.addExtension("tiff");
        this.fileList = null;
        this.locationList = null;
        File f = new File(path);
        if (f.isDirectory()) {
            this.isDirectory = true;
        } else {
            this.locationList = f;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public String getMessage() {
        return this.statMessage;
    }

    public void go() {
        Thread t = new Thread(this);
        t.start();
    }

    public void halt() {
        this.halt = true;
    }

    public int getLengthOfTask() {
        if (this.isDirectory) {
            File[] ll = FileUtils.lsR(this.path, this.filter);
            return ll.length;
        }
        if (this.locationList != null) {
            return FileUtils.lsLength(this.locationList, this.filter);
        }
        return 0;
    }

    public int getCurrent() {
        return this.current;
    }

    public boolean indexDir(String currentPath) throws IOException {
        File pdir;
        boolean sameDate;
        File indexFile = new File(currentPath + File.separator + ".blobs");
        File histogramFile = new File(currentPath + File.separator + ".histogram");
        boolean bl = sameDate = indexFile.lastModified() >= new File(currentPath).lastModified();
        if (indexFile.exists() && histogramFile.exists() && sameDate && !this.rebuild) {
            return false;
        }
        if (!indexFile.exists()) {
            indexFile.createNewFile();
        }
        PrintWriter iWriter = new PrintWriter(new FileOutputStream(indexFile));
        if (!histogramFile.exists()) {
            histogramFile.createNewFile();
        }
        PrintWriter ihWriter = new PrintWriter(new FileOutputStream(histogramFile));
        File bdir = new File(currentPath + File.separator + ".bthumbs");
        if (bdir.mkdir()) {
            System.out.println("Directory " + currentPath + File.separator + ".bthumbs" + " created.\n");
        }
        if ((pdir = new File(currentPath + File.separator + "thumbs")).mkdir()) {
            System.out.println("Directory " + currentPath + File.separator + "thumbs" + " created.\n");
        }
        Segmenter segmenter = new Segmenter();
        for (int i = 0; i < this.fileList.length && !this.halt; ++i) {
            ++this.current;
            File f = this.fileList[i];
            BufferedImage img = Utilities.loadImage(f.getAbsolutePath());
            this.statMessage = currentPath + "\n";
            this.statMessage = this.statMessage + "indexing... " + (i + 1) + "/" + this.fileList.length;
            ObjectImage objectImage = segmenter.getKMedianRegions(img);
            String descriptor = objectImage.getDescriptor();
            iWriter.println(descriptor);
            iWriter.flush();
            double[] rh = objectImage.getHistogram();
            descriptor = AMath.showVector(rh);
            ihWriter.println(descriptor);
            ihWriter.flush();
            Utilities.saveImage(segmenter.getSegmentedImage(), "png", currentPath + File.separator + ".bthumbs" + File.separator + FileUtils.nameWOExtension(f.getName()) + ".png");
            Utilities.saveImage(segmenter.getQuantizedImage(), "png", currentPath + File.separator + ".bthumbs" + File.separator + FileUtils.nameWOExtension(f.getName()) + "-ccat.png");
        }
        iWriter.close();
        return true;
    }

    public void run() {
        try {
            long totalTime = 0L;
            long time = System.currentTimeMillis();
            if (this.isDirectory) {
                File[] recList = FileUtils.lsDirsR(this.path);
                for (int i = 0; i < recList.length; ++i) {
                    String dpath = recList[i].getAbsolutePath();
                    this.fileList = FileUtils.ls(dpath, this.filter);
                    this.indexDir(dpath);
                    if (!this.halt) {
                        if (this.retrieval != null) {
                            this.retrieval.addLocalDB(dpath);
                        }
                        if (this.iretrieval == null) continue;
                        this.iretrieval.addLocalDB(dpath);
                        continue;
                    }
                    break;
                }
            } else {
                BufferedReader br = new BufferedReader(new FileReader(this.locationList));
                this.path = br.readLine();
                while (this.path != null) {
                    this.fileList = FileUtils.ls(this.path, this.filter);
                    this.indexDir(this.path);
                    if (!this.halt) {
                        if (this.retrieval != null) {
                            this.retrieval.addLocalDB(this.path);
                        }
                        if (this.iretrieval != null) {
                            this.iretrieval.addLocalDB(this.path);
                        }
                        this.path = br.readLine();
                        continue;
                    }
                    break;
                }
            }
            double t = (double)(totalTime += System.currentTimeMillis() - time) / 1000.0;
            this.statMessage = !this.halt ? "Computed index for " + this.fileList.length + " images in " + t + " secs. in " + this.path : "Indexing interrupted";
            this.done = true;
        }
        catch (FileNotFoundException e) {
            this.statMessage = "Location not found!";
        }
        catch (Exception e) {
            this.statMessage = "Indexing interrupted";
        }
    }
}

