/*
 * Decompiled with CFR 0.152.
 */
package titech.db;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import titech.file.FileUtils;
import titech.file.ImageFileFilter;
import titech.image.ScrollableJPanel;
import titech.image.dsp.ObjectImage;
import titech.image.dsp.Region;
import titech.util.Utilities;
import titech.util.ValuePair;
import titech.wt.CompositeButton;
import titech.wt.CursorController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Retrieval
implements Runnable {
    public static final String INDEX_NAME = ".blobs";
    public static final String THUMBSDIR = ".bthumbs";
    public static final String PREVIEWDIR = "thumbs";
    public static final int TIMEOUT = 10;
    ImageFileFilter filter;
    double regionThreshold = 1.0;
    public int maxImages = 10;
    Vector<ObjectImage> objectDB = new Vector();
    Vector<ValuePair> retrieved = new Vector();
    Vector<String> locations = new Vector();
    public double posW = 0.25;
    public double volW = 0.25;
    public double colW = 0.25;
    public double oriW = 0.25;
    Region query;
    ScrollableJPanel sjpanel;
    JTextArea log = null;
    private ActionListener busyListener;
    JTextField textField = null;
    Dimension componentSize;

    public Retrieval(Region query) {
        this.query = query;
        this.componentSize = new Dimension(300, 100);
        this.filter = new ImageFileFilter();
        this.filter.addExtension("jpg");
        this.filter.addExtension("png");
        this.filter.addExtension("jpeg");
        this.filter.addExtension("bmp");
        this.filter.addExtension("tiff");
    }

    public Retrieval() {
        this(null);
    }

    public void setWidth(int w) {
        this.componentSize = new Dimension(w, 110);
    }

    public void setTextField(JTextField textField) {
        this.textField = textField;
    }

    public void setLog(JTextArea l) {
        this.log = l;
    }

    public void setQuery(Region query) {
        this.query = query;
    }

    public void setSJPanel(ScrollableJPanel sjpanel) {
        this.sjpanel = sjpanel;
        this.busyListener = CursorController.createListener(sjpanel.getFocusCycleRootAncestor(), sjpanel);
    }

    public ScrollableJPanel getSJPanel() {
        return this.sjpanel;
    }

    public Vector<String> getLocations() {
        return this.locations;
    }

    public Vector<ObjectImage> getObjectDB() {
        return this.objectDB;
    }

    public void setObjectDB(Vector<ObjectImage> objectDB) {
        this.objectDB = objectDB;
    }

    public void addLocalDB(String path) throws FileNotFoundException, IOException {
        File indexFile = new File(path + File.separator + INDEX_NAME);
        System.out.println(path);
        File[] fileList = FileUtils.ls(path, this.filter);
        BufferedReader reader = new BufferedReader(new FileReader(indexFile));
        for (int i = 0; i < fileList.length; ++i) {
            File f = fileList[i];
            String descriptor = reader.readLine();
            ObjectImage obi = new ObjectImage(descriptor);
            obi.setLocation(f.getAbsolutePath());
            this.objectDB.add(obi);
        }
        reader.close();
        this.locations.add(path);
        this.print("Retrieval: " + this.objectDB.size() + " images in the DB.");
    }

    public Vector<ValuePair> retrieveRegions(Region query) {
        this.retrieved.clear();
        String keyword = this.textField == null ? "" : this.textField.getText();
        for (int i = 0; i < this.objectDB.size(); ++i) {
            ObjectImage obi = this.objectDB.get(i);
            if (keyword != "" && !obi.getLocation().contains(keyword)) continue;
            obi.setWeights(this.posW, this.volW, this.colW, this.oriW);
            int index = obi.minDistanceRegion(query);
            if (!(obi.getMinDist() < this.regionThreshold)) continue;
            this.retrieved.add(new ValuePair(i, obi.getMinDist(), index, obi.getLocation()));
        }
        Collections.sort(this.retrieved);
        return this.retrieved;
    }

    public void cloneFrom(Retrieval ret) {
        this.setObjectDB(ret.getObjectDB());
        this.setSJPanel(ret.getSJPanel());
        this.colW = ret.colW;
        this.posW = ret.posW;
        this.volW = ret.volW;
        this.oriW = ret.oriW;
        this.componentSize = ret.componentSize;
        this.log = ret.log;
        this.textField = ret.textField;
    }

    public void clear() {
        this.sjpanel.removeAll();
        this.sjpanel.repaint();
    }

    @Override
    public void run() {
        try {
            int timeout;
            for (timeout = 0; (this.query == null || this.objectDB.size() == 0) && timeout < 10; ++timeout) {
                Thread.sleep(500L);
            }
            if (timeout < 10) {
                long time = System.currentTimeMillis();
                this.retrieveRegions(this.query);
                time = System.currentTimeMillis() - time;
                double t = (double)time / 1000.0;
                this.print("Object query time: " + t + " secs.");
                ScrollableJPanel srpanel = new ScrollableJPanel();
                JScrollPane scroller = new JScrollPane(srpanel, 21, 30);
                scroller.setPreferredSize(this.componentSize);
                String rr = "/resources/fileclose.png";
                JButton closeButton = new JButton(new ImageIcon(this.getClass().getResource(rr)));
                closeButton.addActionListener(this.busyListener);
                srpanel.add(closeButton);
                int i = 0;
                String minmax = "";
                double distance = 0.0;
                while (i < this.maxImages && i < this.retrieved.size()) {
                    ValuePair vp = this.retrieved.get(i);
                    distance = vp.value;
                    if (i == 0) {
                        minmax = minmax + distance;
                    }
                    ++i;
                    if (this.sjpanel == null) continue;
                    BufferedImage bim = Utilities.loadImage(ObjectImage.thumbFromLocation(vp.label));
                    String preview = ObjectImage.previewFromLocation(vp.label);
                    File fp = new File(preview);
                    BufferedImage icon = null;
                    if (fp.exists()) {
                        icon = Utilities.loadImage(preview);
                    } else {
                        icon = Utilities.loadImage(vp.label);
                        Utilities.saveImage(Utilities.resize(icon, 120), Utilities.getExtension(vp.label), fp);
                    }
                    bim = Utilities.maskIndexedImage(bim, vp.ilabel + 1, icon);
                    CompositeButton b = new CompositeButton(new ImageIcon(bim), vp);
                    b.addActionListener(this.busyListener);
                    srpanel.add(b);
                }
                minmax = minmax + ", " + distance;
                this.print("Region distance interval: (" + minmax + ")");
                if (this.sjpanel != null) {
                    this.sjpanel.add(scroller);
                    this.sjpanel.getTopLevelAncestor().validate();
                }
            } else {
                String error = "";
                if (this.objectDB.size() == 0) {
                    error = error + "No DB. ";
                }
                if (this.query == null) {
                    error = error + "No query object. ";
                }
                this.print("Retrieval thread: timeout! " + error);
            }
        }
        catch (Exception exc) {
            this.print("Retrieval thread: " + exc);
        }
    }

    public void print(String text) {
        if (this.log == null) {
            System.out.println(text);
        } else {
            this.log.append(text + "\n");
            this.log.setCaretPosition(this.log.getDocument().getLength());
        }
    }
}

