/*
 * Decompiled with CFR 0.152.
 */
package titech.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.util.Collections;
import java.util.Vector;

public class FileUtils {
    public static File[] ls(String path, FileFilter filter) {
        int i;
        File sf = new File(path);
        File[] fileList = sf.listFiles(filter);
        Vector<File> fileVector = new Vector<File>(fileList.length);
        for (i = 0; i < fileList.length; ++i) {
            fileVector.add(fileList[i]);
        }
        Collections.sort(fileVector);
        for (i = 0; i < fileList.length; ++i) {
            fileList[i] = (File)fileVector.get(i);
        }
        return fileList;
    }

    public static File[] lsR(String path, FileFilter filter) {
        File[] list = null;
        try {
            int i;
            File sf = new File(path);
            if (!sf.exists()) {
                return null;
            }
            File[] fileList = sf.listFiles(filter);
            Vector<File> fileVector = new Vector<File>(fileList.length);
            for (i = 0; i < fileList.length; ++i) {
                fileVector.add(fileList[i]);
            }
            fileList = sf.listFiles();
            for (i = 0; i < fileList.length; ++i) {
                File ff = fileList[i];
                String ss = ff.getCanonicalPath();
                if (!ff.isDirectory() || ss.startsWith(".") || ss.contains("thumb")) continue;
                File[] ffList = FileUtils.lsR(ff.getAbsolutePath(), filter);
                for (int j = 0; j < ffList.length; ++j) {
                    fileVector.add(ffList[j]);
                }
            }
            Collections.sort(fileVector);
            list = new File[fileVector.size()];
            for (i = 0; i < list.length; ++i) {
                list[i] = (File)fileVector.get(i);
            }
        }
        catch (Exception e) {
            System.err.println("lsR: " + e);
        }
        return list;
    }

    public static File[] lsDirsR(String path) {
        File[] list = null;
        try {
            int i;
            File sf = new File(path);
            if (!sf.exists()) {
                return null;
            }
            File[] fileList = sf.listFiles();
            Vector<File> fileVector = new Vector<File>(fileList.length);
            for (i = 0; i < fileList.length; ++i) {
                File ff = fileList[i];
                String ss = ff.getCanonicalPath();
                if (!ff.isDirectory() || ss.startsWith(".") || ss.contains("thumb")) continue;
                fileVector.add(ff);
                File[] ffList = FileUtils.lsDirsR(ff.getAbsolutePath());
                for (int j = 0; j < ffList.length; ++j) {
                    fileVector.add(ffList[j]);
                }
            }
            Collections.sort(fileVector);
            list = new File[fileVector.size()];
            for (i = 0; i < list.length; ++i) {
                list[i] = (File)fileVector.get(i);
            }
        }
        catch (Exception e) {
            System.err.println("lsDirsR: " + e);
        }
        return list;
    }

    public static int lsLength(File locationList, FileFilter filter) {
        int total = 0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(locationList));
            String path = br.readLine();
            while (path != null && path.length() != 0) {
                File sf = new File(path);
                File[] fileList = sf.listFiles(filter);
                total += fileList.length;
                path = br.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return total;
    }

    public static final String getExtension(String file) {
        int pos = file.lastIndexOf(46);
        return file.substring(pos).toLowerCase();
    }

    public static final String nameWOExtension(String file) {
        int pos = file.lastIndexOf(46);
        return file.substring(0, pos);
    }

    public static void main(String[] args) {
        File[] list = FileUtils.ls(args[0], null);
        for (int i = 0; i < list.length; ++i) {
            System.out.println(list[i].getAbsolutePath());
        }
    }
}

