/*
 * Decompiled with CFR 0.152.
 */
package titech.image;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class ScrollableJPanel
extends JPanel
implements Scrollable,
ActionListener {
    private static final long serialVersionUID = 1L;
    int minXIncrement = 600;
    int minYIncrement = 600;

    public ScrollableJPanel() {
    }

    public ScrollableJPanel(LayoutManager layout) {
        super(layout);
    }

    public Component add(Component comp) {
        Component c = super.add(comp);
        Dimension d = comp.getPreferredSize();
        if (d.width / 2 < this.minXIncrement) {
            this.minXIncrement = d.width / 2;
        }
        if (d.height / 2 < this.minYIncrement) {
            this.minYIncrement = d.height / 2;
        }
        return c;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.minYIncrement;
        }
        return this.minXIncrement;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.minYIncrement;
        }
        return this.minXIncrement;
    }

    public void actionPerformed(ActionEvent e) {
        System.out.println(e.getSource().getClass().getSimpleName());
    }
}

