/*
 * Decompiled with CFR 0.152.
 */
package titech.image.dsp;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Vector;
import titech.image.dsp.Region;
import titech.image.dsp.Segmenter;
import titech.util.Utilities;

public class ColorLabel {
    private int nlabels;
    private int[] equivalences = null;
    int[][] labeled;
    int width;
    int height;

    public ColorLabel(BufferedImage indexedImage) {
        this.labeled = this.colorLabel(indexedImage);
    }

    public ColorLabel(BufferedImage indexedImage, int color) {
        this.labeled = this.colorLabel(indexedImage, new Color(color));
    }

    public int getNLabels() {
        return this.nlabels;
    }

    public int[][] getLabeledMatrix() {
        return this.labeled;
    }

    private int[][] colorLabel(BufferedImage src) {
        return this.colorLabel(src, null);
    }

    private int[][] colorLabel(BufferedImage src, Color background) {
        this.width = src.getWidth();
        this.height = src.getHeight();
        int[][] dst = new int[this.width][this.height];
        int[] nb = new int[4];
        int[] nbl = new int[4];
        this.equivalences = new int[this.width * this.height];
        for (int i = 0; i < this.equivalences.length; ++i) {
            this.equivalences[i] = i;
        }
        int bgColor = 0;
        if (background != null) {
            bgColor = background.getRGB();
        }
        int label = 1;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int i;
                int color = src.getRGB(x, y);
                if (background != null && bgColor == color) {
                    dst[x][y] = 0;
                    continue;
                }
                nb[0] = this.getSample(src, x - 1, y);
                nb[1] = this.getSample(src, x, y - 1);
                nb[2] = this.getSample(src, x - 1, y - 1);
                nb[3] = this.getSample(src, x + 1, y - 1);
                nbl[0] = this.getSample(dst, x - 1, y);
                nbl[1] = this.getSample(dst, x, y - 1);
                nbl[2] = this.getSample(dst, x - 1, y - 1);
                nbl[3] = this.getSample(dst, x + 1, y - 1);
                if (nb[0] != color && nb[1] != color && nb[2] != color && nb[3] != color) {
                    dst[x][y] = label++;
                    continue;
                }
                int count = 0;
                int found = -1;
                for (i = 0; i < 4; ++i) {
                    if (nb[i] != color) continue;
                    ++count;
                    found = i;
                }
                dst[x][y] = nbl[found];
                if (count <= 1) continue;
                for (i = 0; i < 4; ++i) {
                    if (nb[i] != color || nbl[i] == dst[x][y]) continue;
                    this.associate(nbl[i], dst[x][y]);
                }
            }
        }
        for (int i = label - 1; i > 0; --i) {
            this.equivalences[i] = this.reduce(i);
        }
        int[] condensed = new int[label];
        int count = 0;
        for (int i = 0; i < label; ++i) {
            if (i != this.equivalences[i]) continue;
            condensed[i] = count++;
        }
        this.nlabels = count;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int i;
                dst[x][y] = i = condensed[this.equivalences[dst[x][y]]];
            }
        }
        this.equivalences = null;
        return dst;
    }

    private int getSample(BufferedImage src, int x, int y) {
        int w = src.getWidth();
        int h = src.getHeight();
        return x < 0 || x >= w || y < 0 || y >= h ? 0 : src.getRGB(x, y);
    }

    private int getSample(int[][] src, int x, int y) {
        int w = src.length;
        int h = src[0].length;
        return x < 0 || x >= w || y < 0 || y >= h ? 0 : src[x][y];
    }

    private int reduce(int a) {
        if (this.equivalences[a] == a) {
            return a;
        }
        return this.reduce(this.equivalences[a]);
    }

    private void associate(int a, int b) {
        if (a > b) {
            this.associate(b, a);
            return;
        }
        if (a == b || this.equivalences[b] == a) {
            return;
        }
        if (this.equivalences[b] == b) {
            this.equivalences[b] = a;
        } else {
            this.associate(this.equivalences[b], a);
            this.equivalences[b] = a;
        }
    }

    BufferedImage getAsImage(Vector regions, int[] equiv) {
        int j;
        byte[][] colormap = new byte[3][256];
        int n = regions.size();
        colormap[0][0] = 80;
        colormap[1][0] = 80;
        colormap[2][0] = 80;
        double colorNorm = 100.0;
        for (int i = 0; i < n; ++i) {
            Region r = (Region)regions.get(i);
            float[] col = new float[3];
            for (j = 0; j < 3; ++j) {
                col[j] = (float)(colorNorm * r.color[j]);
            }
            col = Utilities.LabtosRGB(col);
            for (j = 0; j < 3; ++j) {
                int n2 = j;
                col[n2] = col[n2] * 255.0f;
                colormap[j][i + 1] = (byte)col[j];
            }
        }
        BufferedImage outImage = Segmenter.createIndexedImage(this.width, this.height, colormap);
        WritableRaster wrasta = outImage.getRaster();
        for (int i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                wrasta.setSample(i, j, 0, equiv[this.labeled[i][j]]);
            }
        }
        return outImage;
    }

    public BufferedImage getAsImage() {
        byte[][] colormap = new byte[3][256];
        colormap[0][255] = 0;
        colormap[1][255] = 0;
        colormap[2][255] = 0;
        for (int i = 1; i < 255; ++i) {
            colormap[0][i] = (byte)(256.0 * Math.random());
            colormap[1][i] = (byte)(256.0 * Math.random());
            colormap[2][i] = (byte)(256.0 * Math.random());
        }
        BufferedImage outImage = Segmenter.createIndexedImage(this.width, this.height, colormap);
        WritableRaster wrasta = outImage.getRaster();
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                int l = this.labeled[i][j];
                wrasta.setSample(i, j, 0, l >= 255 ? 255 : l);
            }
        }
        return outImage;
    }
}

