/*
 * Decompiled with CFR 0.152.
 */
package titech.image.dsp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.TreeSet;
import java.util.Vector;
import titech.image.dsp.ColorLabel;
import titech.image.dsp.ObjectImage;
import titech.image.dsp.Region;
import titech.image.math.AMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MOps2D {
    public static BufferedImage equal(BufferedImage source, int index) {
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        Raster rasta = source.getData();
        WritableRaster wrasta = out.getRaster();
        int width = source.getWidth();
        int height = source.getHeight();
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int pixel = rasta.getSample(i, j, 0);
                if (pixel != index) continue;
                wrasta.setSample(i, j, 0, 1);
            }
        }
        return out;
    }

    public static BufferedImage equalNot(BufferedImage source, int color) {
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        WritableRaster wrasta = out.getRaster();
        int width = source.getWidth();
        int height = source.getHeight();
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int pixel = source.getRGB(i, j);
                if (pixel == color) continue;
                wrasta.setSample(i, j, 0, 1);
            }
        }
        return out;
    }

    public static BufferedImage equal(BufferedImage source, int index, Dimension size) {
        BufferedImage out = new BufferedImage((int)size.getWidth(), (int)size.getHeight(), 12);
        Raster rasta = source.getData();
        WritableRaster wrasta = out.getRaster();
        double scalex = (double)source.getWidth() / size.getWidth();
        double scaley = (double)source.getHeight() / size.getHeight();
        int y = 0;
        while ((double)y < size.getHeight()) {
            int x = 0;
            while ((double)x < size.getWidth()) {
                int i = (int)((double)x * scalex);
                int j = (int)((double)y * scaley);
                int pixel = rasta.getSample(i, j, 0);
                if (pixel == index) {
                    wrasta.setSample(x, y, 0, 1);
                }
                ++x;
            }
            ++y;
        }
        return out;
    }

    public static BufferedImage equal(BufferedImage source, int[] inds, Dimension size) {
        BufferedImage out = new BufferedImage((int)size.getWidth(), (int)size.getHeight(), 12);
        Raster rasta = source.getData();
        WritableRaster wrasta = out.getRaster();
        double scalex = (double)source.getWidth() / size.getWidth();
        double scaley = (double)source.getHeight() / size.getHeight();
        int y = 0;
        while ((double)y < size.getHeight()) {
            int x = 0;
            while ((double)x < size.getWidth()) {
                int i = (int)((double)x * scalex);
                int j = (int)((double)y * scaley);
                int pixel = rasta.getSample(i, j, 0);
                if (AMath.inVector(pixel, inds)) {
                    wrasta.setSample(x, y, 0, 1);
                }
                ++x;
            }
            ++y;
        }
        return out;
    }

    public static BufferedImage bw2binary(BufferedImage source) {
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        Graphics gi = out.getGraphics();
        gi.drawImage(source, 0, 0, null);
        gi.dispose();
        return out;
    }

    public static BufferedImage erode(BufferedImage source, int[][] strel) {
        return MOps2D.erode(source, strel, true);
    }

    public static BufferedImage erode(BufferedImage source, int[][] strel, boolean zeroPadding) {
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage out = new BufferedImage(width, height, 12);
        Raster rasta = source.getData();
        WritableRaster wrasta = out.getRaster();
        int shh = strel.length >> 1;
        int swh = strel[0].length >> 1;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                boolean fits = true;
                for (int y = 0; y < strel.length; ++y) {
                    for (int x = 0; x < strel[y].length; ++x) {
                        int ni = i - swh + x;
                        int nj = j - shh + y;
                        if (ni >= 0 && nj >= 0 && ni < width && nj < height) {
                            int pixel = rasta.getSample(ni, nj, 0);
                            if (strel[y][x] != 1 || pixel != 0) continue;
                            fits = false;
                            continue;
                        }
                        if (strel[y][x] != 1 || !zeroPadding) continue;
                        fits = false;
                    }
                }
                if (!fits) continue;
                wrasta.setSample(i, j, 0, 1);
            }
        }
        return out;
    }

    public static BufferedImage erode(BufferedImage source, int[] strel) {
        int pixel;
        boolean fits;
        int i;
        int j;
        BufferedImage aux = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        Raster rasta = source.getData();
        WritableRaster wrasta = aux.getRaster();
        int width = source.getWidth();
        int height = source.getHeight();
        int shh = strel.length >> 1;
        for (j = 0; j < height; ++j) {
            for (i = 0; i < width; ++i) {
                fits = true;
                for (int y = 0; y < strel.length; ++y) {
                    int nj = j - shh + y;
                    if (nj >= 0 && nj < height) {
                        pixel = rasta.getSample(i, nj, 0);
                        if (strel[y] != 1 || pixel != 0) continue;
                        fits = false;
                        break;
                    }
                    fits = false;
                }
                if (!fits) continue;
                wrasta.setSample(i, j, 0, 1);
            }
        }
        rasta = aux.getData();
        wrasta = out.getRaster();
        for (j = 0; j < height; ++j) {
            for (i = 0; i < width; ++i) {
                fits = true;
                for (int x = 0; x < strel.length; ++x) {
                    int ni = i - shh + x;
                    if (ni >= 0 && ni < width) {
                        pixel = rasta.getSample(ni, j, 0);
                        if (strel[x] != 1 || pixel != 0) continue;
                        fits = false;
                        break;
                    }
                    fits = false;
                }
                if (!fits) continue;
                wrasta.setSample(i, j, 0, 1);
            }
        }
        return out;
    }

    public static BufferedImage dilate(BufferedImage source, int[][] strel) {
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        Raster rasta = source.getData();
        WritableRaster wrasta = out.getRaster();
        int width = source.getWidth();
        int height = source.getHeight();
        int shh = strel.length >> 1;
        int swh = strel[0].length >> 1;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                boolean touches = false;
                for (int y = 0; y < strel.length; ++y) {
                    for (int x = 0; x < strel[y].length; ++x) {
                        int ni = i - swh + x;
                        int nj = j - shh + y;
                        if (ni < 0 || nj < 0 || ni >= width || nj >= height) continue;
                        int pixel = rasta.getSample(ni, nj, 0);
                        if (strel[y][x] != 1 || pixel == 0) continue;
                        touches = true;
                        break;
                    }
                    if (touches) break;
                }
                if (!touches) continue;
                wrasta.setSample(i, j, 0, 1);
            }
        }
        return out;
    }

    public static BufferedImage dilate(BufferedImage source, int[] strel) {
        int pixel;
        boolean touches;
        int i;
        int j;
        BufferedImage aux = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        Raster rasta = source.getData();
        WritableRaster wrasta = aux.getRaster();
        int width = source.getWidth();
        int height = source.getHeight();
        int shh = strel.length >> 1;
        for (j = 0; j < height; ++j) {
            for (i = 0; i < width; ++i) {
                touches = false;
                for (int y = 0; y < strel.length; ++y) {
                    int nj = j - shh + y;
                    if (nj < 0 || nj >= height) continue;
                    pixel = rasta.getSample(i, nj, 0);
                    if (strel[y] != 1 || pixel == 0) continue;
                    touches = true;
                    break;
                }
                if (!touches) continue;
                wrasta.setSample(i, j, 0, 1);
            }
        }
        rasta = aux.getData();
        wrasta = out.getRaster();
        for (j = 0; j < height; ++j) {
            for (i = 0; i < width; ++i) {
                touches = false;
                for (int x = 0; x < strel.length; ++x) {
                    int ni = i - shh + x;
                    if (ni < 0 || ni >= width) continue;
                    pixel = rasta.getSample(ni, j, 0);
                    if (strel[x] != 1 || pixel == 0) continue;
                    touches = true;
                    break;
                }
                if (!touches) continue;
                wrasta.setSample(i, j, 0, 1);
            }
        }
        return out;
    }

    public static BufferedImage erode(BufferedImage source) {
        return MOps2D.erode(source, true);
    }

    public static BufferedImage erode(BufferedImage source, boolean zeroPadding) {
        return MOps2D.erode(source, new int[][]{{0, 1, 0}, {1, 1, 1}, {0, 1, 0}}, zeroPadding);
    }

    public static BufferedImage erode(BufferedImage source, int index) {
        return MOps2D.erode(MOps2D.equal(source, index), new int[][]{{0, 1, 0}, {1, 1, 1}, {0, 1, 0}});
    }

    public static BufferedImage dilate(BufferedImage source) {
        return MOps2D.dilate(source, new int[][]{{0, 1, 0}, {1, 1, 1}, {0, 1, 0}});
    }

    public static BufferedImage dilate(BufferedImage source, int index) {
        return MOps2D.dilate(MOps2D.equal(source, index), new int[][]{{0, 1, 0}, {1, 1, 1}, {0, 1, 0}});
    }

    public static BufferedImage difference(BufferedImage s1, BufferedImage s2) {
        int width = s1.getWidth();
        int height = s1.getHeight();
        BufferedImage out = new BufferedImage(width, height, 12);
        Raster r1 = s1.getData();
        Raster r2 = s2.getData();
        WritableRaster wrasta = out.getRaster();
        if (s2.getWidth() < width || s2.getHeight() < height) {
            System.err.println("MOps2D.difference: Size mismatch! " + width + "x" + height + ", " + s2.getWidth() + "x" + s2.getHeight());
            return out;
        }
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int p2;
                int p1 = r1.getSample(i, j, 0);
                if (p1 == (p2 = r2.getSample(i, j, 0))) continue;
                wrasta.setSample(i, j, 0, 1);
            }
        }
        return out;
    }

    public static BufferedImage colorMask(BufferedImage binary, int argb) {
        BufferedImage out = new BufferedImage(binary.getWidth(), binary.getHeight(), 2);
        Raster r = binary.getData();
        int width = binary.getWidth();
        int height = binary.getHeight();
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int p1 = r.getSample(i, j, 0);
                if (p1 != 1) continue;
                out.setRGB(i, j, argb);
            }
        }
        return out;
    }

    public static BufferedImage maskImage(BufferedImage source, BufferedImage mask) {
        return MOps2D.maskImage(source, mask, new Point(0, 0));
    }

    public static BufferedImage maskImage(BufferedImage source, BufferedImage mask, Point offset) {
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage out = new BufferedImage(width, height, 2);
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int v = source.getRGB(i, j);
                int m = 0;
                int im = i + offset.x;
                int jm = j + offset.y;
                if (im >= 0 && im < mask.getWidth() && jm >= 0 && jm < mask.getHeight()) {
                    m = mask.getRGB(im, jm);
                }
                out.setRGB(i, j, v & m);
            }
        }
        return out;
    }

    public static void alphaMask(BufferedImage source, BufferedImage mask) {
        int w = source.getWidth();
        int h = source.getHeight();
        if (w != mask.getWidth() || h != mask.getHeight()) {
            System.err.println("MOps2D.alphaMask: Sizes differ! " + w + "x" + h + ", " + mask.getWidth() + "x" + mask.getHeight());
            return;
        }
        WritableRaster wrasta = source.getAlphaRaster();
        if (wrasta == null) {
            System.err.println("MOps2D.alphaMask: no alpha channel!");
            return;
        }
        int[] samples = new int[w * h];
        mask.getData().getSamples(0, 0, w, h, 0, samples);
        wrasta.setSamples(0, 0, w, h, 0, samples);
    }

    public static BufferedImage plot(Vector points, int width, int height) {
        BufferedImage out = new BufferedImage(width, height, 12);
        WritableRaster wr = out.getRaster();
        for (int i = 0; i < points.size(); ++i) {
            Point p = (Point)points.get(i);
            if (p.x < 0 || p.y < 0 || p.x >= width || p.y >= height) {
                System.err.println("MOps2D.plot: Coordinate out of bounds! " + p);
                return out;
            }
            wr.setSample(p.x, p.y, 0, 1);
        }
        return out;
    }

    public static void orImage(BufferedImage source, BufferedImage binary, int argb) {
        Graphics gi = source.getGraphics();
        gi.drawImage(MOps2D.colorMask(binary, argb), 0, 0, null);
        gi.dispose();
    }

    public static void or(BufferedImage source, BufferedImage mask) {
        Raster r2 = mask.getData();
        WritableRaster wrasta = source.getRaster();
        int width = mask.getWidth();
        int height = mask.getHeight();
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int p2 = r2.getSample(i, j, 0);
                if (p2 != 1) continue;
                wrasta.setSample(i, j, 0, 1);
            }
        }
    }

    public static void and(BufferedImage source, BufferedImage mask) {
        Raster r2 = mask.getData();
        WritableRaster wrasta = source.getRaster();
        int width = source.getWidth();
        int height = source.getHeight();
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int p2 = r2.getSample(i, j, 0);
                if (p2 != 0) continue;
                wrasta.setSample(i, j, 0, 0);
            }
        }
    }

    public static BufferedImage gradient(BufferedImage source) {
        return MOps2D.difference(source, MOps2D.erode(source));
    }

    public static BufferedImage gradient(BufferedImage source, int index) {
        BufferedImage binary = MOps2D.equal(source, index);
        return MOps2D.difference(binary, MOps2D.erode(binary));
    }

    public static BufferedImage gradient(BufferedImage source, int index, Dimension dim) {
        BufferedImage binary = MOps2D.equal(source, index, dim);
        return MOps2D.difference(binary, MOps2D.erode(binary));
    }

    public static BufferedImage gradient(BufferedImage source, int[] inds, Dimension dim) {
        BufferedImage binary = MOps2D.equal(source, inds, dim);
        return MOps2D.difference(binary, MOps2D.erode(binary));
    }

    public static byte[][] getGradient(BufferedImage source) {
        BufferedImage contour = MOps2D.difference(source, MOps2D.erode(source));
        Raster r1 = source.getData();
        Raster r2 = contour.getData();
        int width = contour.getWidth();
        int height = contour.getHeight();
        byte[][] out = new byte[width][height];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int p1 = r1.getSample(i, j, 0);
                int p2 = r2.getSample(i, j, 0);
                out[i][j] = p1 == 0 ? -1 : (p2 == 0 ? 1 : 0);
            }
        }
        return out;
    }

    public static Rectangle getBB(BufferedImage source) {
        Raster rasta = source.getData();
        int mx = rasta.getMinX();
        int my = rasta.getMinY();
        int width = rasta.getWidth();
        int height = rasta.getHeight();
        int minx = width - 1;
        int miny = height - 1;
        int maxx = 0;
        int maxy = 0;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int pixel = rasta.getSample(i + mx, j + my, 0);
                if (pixel == 0) continue;
                if (i < minx) {
                    minx = i;
                }
                if (i > maxx) {
                    maxx = i;
                }
                if (j < miny) {
                    miny = j;
                }
                if (j <= maxy) continue;
                maxy = j;
            }
        }
        if (maxx - minx + 1 < 0 || maxy - miny + 1 < 0) {
            minx = 0;
            miny = 0;
            maxx = width - 1;
            maxy = height - 1;
        }
        return new Rectangle(minx, miny, maxx - minx + 1, maxy - miny + 1);
    }

    public static BufferedImage fill4(BufferedImage source, int ox, int oy, int color) {
        int target = ox < 0 || oy < 0 ? -16777216 : source.getRGB(ox, oy);
        return MOps2D.fill4(source, ox, oy, color, target);
    }

    public static BufferedImage fill4(BufferedImage source, int ox, int oy, int color, int target) {
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage out = new BufferedImage(width, height, 2);
        boolean[][] added = new boolean[width + 1][height + 1];
        Vector<Point> q = new Vector<Point>();
        q.add(new Point(ox, oy));
        added[ox + 1][oy + 1] = true;
        while (!q.isEmpty()) {
            Point np;
            Point p = (Point)q.remove(0);
            if (p.x >= 0 && p.y >= 0) {
                out.setRGB(p.x, p.y, color);
            }
            if (p.x > 0 && p.y >= 0 && source.getRGB(p.x - 1, p.y) == target && out.getRGB(p.x - 1, p.y) != color) {
                np = new Point(p.x - 1, p.y);
                if (!added[p.x][p.y + 1]) {
                    q.add(np);
                    added[p.x][p.y + 1] = true;
                }
            }
            if (p.x < width - 1) {
                if (p.y >= 0) {
                    if (source.getRGB(p.x + 1, p.y) == target && out.getRGB(p.x + 1, p.y) != color) {
                        np = new Point(p.x + 1, p.y);
                        if (!added[p.x + 2][p.y + 1]) {
                            q.add(np);
                            added[p.x + 2][p.y + 1] = true;
                        }
                    }
                } else {
                    np = new Point(p.x + 1, p.y);
                    if (!added[p.x + 2][p.y + 1]) {
                        q.add(np);
                        added[p.x + 2][p.y + 1] = true;
                    }
                }
            }
            if (p.y > 0 && p.x >= 0 && source.getRGB(p.x, p.y - 1) == target && out.getRGB(p.x, p.y - 1) != color) {
                np = new Point(p.x, p.y - 1);
                if (!added[p.x + 1][p.y]) {
                    q.add(np);
                    added[p.x + 1][p.y] = true;
                }
            }
            if (p.y >= height - 1) continue;
            if (p.x >= 0) {
                if (source.getRGB(p.x, p.y + 1) != target || out.getRGB(p.x, p.y + 1) == color) continue;
                np = new Point(p.x, p.y + 1);
                if (added[p.x + 1][p.y + 2]) continue;
                q.add(np);
                added[p.x + 1][p.y + 2] = true;
                continue;
            }
            np = new Point(p.x, p.y + 1);
            if (added[p.x + 1][p.y + 2]) continue;
            q.add(np);
            added[p.x + 1][p.y + 2] = true;
        }
        return out;
    }

    public static BufferedImage fill4(BufferedImage source, BufferedImage mask) {
        Raster mrasta = mask.getData();
        Raster srasta = source.getData();
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage out = new BufferedImage(width, height, 12);
        Graphics gi = out.getGraphics();
        gi.setColor(Color.WHITE);
        gi.fillRect(0, 0, width, height);
        gi.dispose();
        WritableRaster wrasta = out.getRaster();
        boolean[][] added = new boolean[width + 1][height + 1];
        Vector<Point> q = new Vector<Point>();
        TreeSet<Integer> inds = new TreeSet<Integer>();
        q.add(new Point(-1, -1));
        added[0][0] = true;
        while (!q.isEmpty()) {
            Point np;
            int index;
            Point p = (Point)q.remove(0);
            if (p.x >= 0 && p.y >= 0) {
                wrasta.setSample(p.x, p.y, 0, 0);
            }
            if (p.x > 0 && p.y >= 0) {
                index = srasta.getSample(p.x - 1, p.y, 0);
                if (wrasta.getSample(p.x - 1, p.y, 0) != 0) {
                    if (mrasta.getSample(p.x - 1, p.y, 0) == 0) {
                        np = new Point(p.x - 1, p.y);
                        if (!added[p.x][p.y + 1]) {
                            q.add(np);
                            added[p.x][p.y + 1] = true;
                        }
                        if (!inds.contains(index)) {
                            inds.add(index);
                        }
                    } else if (inds.contains(index)) {
                        np = new Point(p.x - 1, p.y);
                        if (!added[p.x][p.y + 1]) {
                            q.add(np);
                            added[p.x][p.y + 1] = true;
                        }
                    }
                }
            }
            if (p.x < width - 1) {
                if (p.y >= 0) {
                    index = srasta.getSample(p.x + 1, p.y, 0);
                    if (wrasta.getSample(p.x + 1, p.y, 0) != 0) {
                        if (mrasta.getSample(p.x + 1, p.y, 0) == 0) {
                            np = new Point(p.x + 1, p.y);
                            if (!added[p.x + 2][p.y + 1]) {
                                q.add(np);
                                added[p.x + 2][p.y + 1] = true;
                            }
                            if (!inds.contains(index)) {
                                inds.add(index);
                            }
                        } else if (inds.contains(index)) {
                            np = new Point(p.x + 1, p.y);
                            if (!added[p.x + 2][p.y + 1]) {
                                q.add(np);
                                added[p.x + 2][p.y + 1] = true;
                            }
                        }
                    }
                } else {
                    Point np2 = new Point(p.x + 1, p.y);
                    if (!added[p.x + 2][p.y + 1]) {
                        q.add(np2);
                        added[p.x + 2][p.y + 1] = true;
                    }
                }
            }
            if (p.y > 0 && p.x >= 0) {
                int index2 = srasta.getSample(p.x, p.y - 1, 0);
                if (wrasta.getSample(p.x, p.y - 1, 0) != 0) {
                    if (mrasta.getSample(p.x, p.y - 1, 0) == 0) {
                        np = new Point(p.x, p.y - 1);
                        if (!added[p.x + 1][p.y]) {
                            q.add(np);
                            added[p.x + 1][p.y] = true;
                        }
                        if (!inds.contains(index2)) {
                            inds.add(index2);
                        }
                    } else if (inds.contains(index2)) {
                        np = new Point(p.x, p.y - 1);
                        if (!added[p.x + 1][p.y]) {
                            q.add(np);
                            added[p.x + 1][p.y] = true;
                        }
                    }
                }
            }
            if (p.y >= height - 1) continue;
            if (p.x >= 0) {
                int index3 = srasta.getSample(p.x, p.y + 1, 0);
                if (wrasta.getSample(p.x, p.y + 1, 0) == 0) continue;
                if (mrasta.getSample(p.x, p.y + 1, 0) == 0) {
                    np = new Point(p.x, p.y + 1);
                    if (!added[p.x + 1][p.y + 2]) {
                        q.add(np);
                        added[p.x + 1][p.y + 2] = true;
                    }
                    if (inds.contains(index3)) continue;
                    inds.add(index3);
                    continue;
                }
                if (!inds.contains(index3)) continue;
                np = new Point(p.x, p.y + 1);
                if (added[p.x + 1][p.y + 2]) continue;
                q.add(np);
                added[p.x + 1][p.y + 2] = true;
                continue;
            }
            Point np3 = new Point(p.x, p.y + 1);
            if (added[p.x + 1][p.y + 2]) continue;
            q.add(np3);
            added[p.x + 1][p.y + 2] = true;
        }
        return out;
    }

    public static BufferedImage fill4(int[][] source, BufferedImage mask) {
        Raster mrasta = mask.getData();
        int width = source.length;
        int height = source[0].length;
        BufferedImage out = new BufferedImage(width, height, 12);
        Graphics gi = out.getGraphics();
        gi.setColor(Color.WHITE);
        gi.fillRect(0, 0, width, height);
        gi.dispose();
        WritableRaster wrasta = out.getRaster();
        boolean[][] added = new boolean[width + 1][height + 1];
        Vector<Point> q = new Vector<Point>();
        TreeSet<Integer> inds = new TreeSet<Integer>();
        q.add(new Point(-1, -1));
        added[0][0] = true;
        while (!q.isEmpty()) {
            Point np;
            int index;
            Point p = (Point)q.remove(0);
            if (p.x >= 0 && p.y >= 0) {
                wrasta.setSample(p.x, p.y, 0, 0);
            }
            if (p.x > 0 && p.y >= 0) {
                index = source[p.x - 1][p.y];
                if (wrasta.getSample(p.x - 1, p.y, 0) != 0) {
                    if (mrasta.getSample(p.x - 1, p.y, 0) == 0) {
                        np = new Point(p.x - 1, p.y);
                        if (!added[p.x][p.y + 1]) {
                            q.add(np);
                            added[p.x][p.y + 1] = true;
                        }
                        if (!inds.contains(index)) {
                            inds.add(index);
                        }
                    } else if (inds.contains(index)) {
                        np = new Point(p.x - 1, p.y);
                        if (!added[p.x][p.y + 1]) {
                            q.add(np);
                            added[p.x][p.y + 1] = true;
                        }
                    }
                }
            }
            if (p.x < width - 1) {
                if (p.y >= 0) {
                    index = source[p.x + 1][p.y];
                    if (wrasta.getSample(p.x + 1, p.y, 0) != 0) {
                        if (mrasta.getSample(p.x + 1, p.y, 0) == 0) {
                            np = new Point(p.x + 1, p.y);
                            if (!added[p.x + 2][p.y + 1]) {
                                q.add(np);
                                added[p.x + 2][p.y + 1] = true;
                            }
                            if (!inds.contains(index)) {
                                inds.add(index);
                            }
                        } else if (inds.contains(index)) {
                            np = new Point(p.x + 1, p.y);
                            if (!added[p.x + 2][p.y + 1]) {
                                q.add(np);
                                added[p.x + 2][p.y + 1] = true;
                            }
                        }
                    }
                } else {
                    Point np2 = new Point(p.x + 1, p.y);
                    if (!added[p.x + 2][p.y + 1]) {
                        q.add(np2);
                        added[p.x + 2][p.y + 1] = true;
                    }
                }
            }
            if (p.y > 0 && p.x >= 0) {
                int index2 = source[p.x][p.y];
                if (wrasta.getSample(p.x, p.y - 1, 0) != 0) {
                    if (mrasta.getSample(p.x, p.y - 1, 0) == 0) {
                        np = new Point(p.x, p.y - 1);
                        if (!added[p.x + 1][p.y]) {
                            q.add(np);
                            added[p.x + 1][p.y] = true;
                        }
                        if (!inds.contains(index2)) {
                            inds.add(index2);
                        }
                    } else if (inds.contains(index2)) {
                        np = new Point(p.x, p.y - 1);
                        if (!added[p.x + 1][p.y]) {
                            q.add(np);
                            added[p.x + 1][p.y] = true;
                        }
                    }
                }
            }
            if (p.y >= height - 1) continue;
            if (p.x >= 0) {
                int index3 = source[p.x][p.y + 1];
                if (wrasta.getSample(p.x, p.y + 1, 0) == 0) continue;
                if (mrasta.getSample(p.x, p.y + 1, 0) == 0) {
                    np = new Point(p.x, p.y + 1);
                    if (!added[p.x + 1][p.y + 2]) {
                        q.add(np);
                        added[p.x + 1][p.y + 2] = true;
                    }
                    if (inds.contains(index3)) continue;
                    inds.add(index3);
                    continue;
                }
                if (!inds.contains(index3)) continue;
                np = new Point(p.x, p.y + 1);
                if (added[p.x + 1][p.y + 2]) continue;
                q.add(np);
                added[p.x + 1][p.y + 2] = true;
                continue;
            }
            Point np3 = new Point(p.x, p.y + 1);
            if (added[p.x + 1][p.y + 2]) continue;
            q.add(np3);
            added[p.x + 1][p.y + 2] = true;
        }
        return out;
    }

    public static void floodfill4(BufferedImage binary, int ox, int oy) {
        WritableRaster wrasta = binary.getRaster();
        int width = wrasta.getWidth();
        int height = wrasta.getHeight();
        boolean[][] added = new boolean[width + 1][height + 1];
        Vector<Point> q = new Vector<Point>();
        q.add(new Point(ox, oy));
        added[ox + 1][oy + 1] = true;
        while (!q.isEmpty()) {
            Point np;
            Point p = (Point)q.remove(0);
            if (p.x >= 0 && p.y >= 0) {
                wrasta.setSample(p.x, p.y, 0, 1);
            }
            if (p.x > 0 && p.y >= 0 && wrasta.getSample(p.x - 1, p.y, 0) == 0) {
                np = new Point(p.x - 1, p.y);
                if (!added[p.x][p.y + 1]) {
                    q.add(np);
                    added[p.x][p.y + 1] = true;
                }
            }
            if (p.x < width - 1) {
                if (p.y >= 0) {
                    if (wrasta.getSample(p.x + 1, p.y, 0) == 0) {
                        np = new Point(p.x + 1, p.y);
                        if (!added[p.x + 2][p.y + 1]) {
                            q.add(np);
                            added[p.x + 2][p.y + 1] = true;
                        }
                    }
                } else {
                    np = new Point(p.x + 1, p.y);
                    if (!added[p.x + 2][p.y + 1]) {
                        q.add(np);
                        added[p.x + 2][p.y + 1] = true;
                    }
                }
            }
            if (p.y > 0 && p.x >= 0 && wrasta.getSample(p.x, p.y - 1, 0) == 0) {
                np = new Point(p.x, p.y - 1);
                if (!added[p.x + 1][p.y]) {
                    q.add(np);
                    added[p.x + 1][p.y] = true;
                }
            }
            if (p.y >= height - 1) continue;
            if (p.x >= 0) {
                if (wrasta.getSample(p.x, p.y + 1, 0) != 0) continue;
                np = new Point(p.x, p.y + 1);
                if (added[p.x + 1][p.y + 2]) continue;
                q.add(np);
                added[p.x + 1][p.y + 2] = true;
                continue;
            }
            np = new Point(p.x, p.y + 1);
            if (added[p.x + 1][p.y + 2]) continue;
            q.add(np);
            added[p.x + 1][p.y + 2] = true;
        }
    }

    public static void not(BufferedImage binary) {
        WritableRaster wrasta = binary.getRaster();
        int width = binary.getWidth();
        int height = binary.getHeight();
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int v = wrasta.getSample(i, j, 0);
                wrasta.setSample(i, j, 0, v == 0 ? 1 : 0);
            }
        }
    }

    public static void not(BufferedImage rgb, int bgcolor, int fgcolor) {
        int width = rgb.getWidth();
        int height = rgb.getHeight();
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int c = rgb.getRGB(i, j);
                if (c == bgcolor) {
                    rgb.setRGB(i, j, fgcolor);
                    continue;
                }
                rgb.setRGB(i, j, bgcolor);
            }
        }
    }

    public static BufferedImage fill8(BufferedImage source, int ox, int oy, int color) {
        int width = source.getWidth();
        int height = source.getHeight();
        int target = source.getRGB(ox, oy);
        BufferedImage out = new BufferedImage(width, height, 2);
        Vector<Point> q = new Vector<Point>();
        q.add(new Point(ox, oy));
        while (!q.isEmpty()) {
            Point np;
            Point p = (Point)q.remove(0);
            out.setRGB(p.x, p.y, color);
            if (p.x > 0 && source.getRGB(p.x - 1, p.y) == target && out.getRGB(p.x - 1, p.y) != color && !q.contains(np = new Point(p.x - 1, p.y))) {
                q.add(np);
            }
            if (p.x < width - 1 && source.getRGB(p.x + 1, p.y) == target && out.getRGB(p.x + 1, p.y) != color && !q.contains(np = new Point(p.x + 1, p.y))) {
                q.add(np);
            }
            if (p.y > 0 && source.getRGB(p.x, p.y - 1) == target && out.getRGB(p.x, p.y - 1) != color && !q.contains(np = new Point(p.x, p.y - 1))) {
                q.add(np);
            }
            if (p.y < height - 1 && source.getRGB(p.x, p.y + 1) == target && out.getRGB(p.x, p.y + 1) != color && !q.contains(np = new Point(p.x, p.y + 1))) {
                q.add(np);
            }
            if (p.x > 0 && p.y > 0 && source.getRGB(p.x - 1, p.y - 1) == target && out.getRGB(p.x - 1, p.y - 1) != color && !q.contains(np = new Point(p.x - 1, p.y - 1))) {
                q.add(np);
            }
            if (p.x < width - 1 && p.y > 0 && source.getRGB(p.x + 1, p.y - 1) == target && out.getRGB(p.x + 1, p.y - 1) != color && !q.contains(np = new Point(p.x + 1, p.y - 1))) {
                q.add(np);
            }
            if (p.y < height - 1 && p.x > 0 && source.getRGB(p.x - 1, p.y + 1) == target && out.getRGB(p.x - 1, p.y + 1) != color && !q.contains(np = new Point(p.x - 1, p.y + 1))) {
                q.add(np);
            }
            if (p.y >= height - 1 || p.x >= width - 1 || source.getRGB(p.x + 1, p.y + 1) != target || out.getRGB(p.x + 1, p.y + 1) == color || q.contains(np = new Point(p.x + 1, p.y + 1))) continue;
            q.add(np);
        }
        return out;
    }

    public static Vector<Point> listPoints(BufferedImage binary) {
        Vector<Point> v = new Vector<Point>();
        WritableRaster r = binary.getRaster();
        int width = binary.getWidth();
        int height = binary.getHeight();
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int value = r.getSample(i, j, 0);
                if (value != 1) continue;
                v.add(new Point(i, j));
            }
        }
        return v;
    }

    public static Vector<Point> listPoints(BufferedImage source, int rgb) {
        Vector<Point> v = new Vector<Point>();
        for (int j = 0; j < source.getHeight(); ++j) {
            for (int i = 0; i < source.getWidth(); ++i) {
                int value = source.getRGB(i, j);
                if (value != rgb) continue;
                v.add(new Point(i, j));
            }
        }
        return v;
    }

    public static Vector<Point> listPointsNot(BufferedImage source, int rgb) {
        Vector<Point> v = new Vector<Point>();
        for (int j = 0; j < source.getHeight(); ++j) {
            for (int i = 0; i < source.getWidth(); ++i) {
                int value = source.getRGB(i, j);
                if (value == rgb) continue;
                v.add(new Point(i, j));
            }
        }
        return v;
    }

    public static int maxValue(BufferedImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        int max = 0;
        Raster r = img.getData();
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                int v = r.getSample(i, j, 0);
                if (v <= max) continue;
                max = v;
            }
        }
        return max;
    }

    public static BufferedImage maxPercentil(BufferedImage img, int size) {
        return MOps2D.maxPercentil(MOps2D.maxValue(img) + 1, img, size);
    }

    public static BufferedImage maxPercentil(int n, BufferedImage img, int size) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage result = new BufferedImage(w, h, 13, (IndexColorModel)img.getColorModel());
        Raster r = img.getData();
        WritableRaster wr = result.getRaster();
        int hf = size >> 1;
        int[] votes = new int[n];
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                for (int v = 0; v < votes.length; ++v) {
                    votes[v] = 0;
                }
                for (int k = Math.max(0, i - hf); k <= Math.min(i + hf, w - 1); ++k) {
                    for (int l = Math.max(0, j - hf); l <= Math.min(j + hf, h - 1); ++l) {
                        int sample = r.getSample(k, l, 0);
                        if (sample < 0 || sample >= n) continue;
                        int n2 = sample;
                        votes[n2] = votes[n2] + 1;
                    }
                }
                wr.setSample(i, j, 0, AMath.indexMax(votes));
            }
        }
        return result;
    }

    public static BufferedImage connectRegions(BufferedImage binary) {
        ColorLabel cl = new ColorLabel(binary);
        ObjectImage obi = new ObjectImage(cl.getLabeledMatrix(), cl.getNLabels(), binary);
        BufferedImage out = new BufferedImage(binary.getWidth(), binary.getHeight(), 12);
        Graphics gi = out.getGraphics();
        gi.setColor(Color.WHITE);
        int w = out.getWidth();
        int h = out.getHeight();
        Vector regions = obi.getRegions();
        if (regions.size() == 0) {
            return out;
        }
        regions.remove(regions.get(0));
        if (regions.size() == 0) {
            return out;
        }
        Region a = (Region)regions.get(0);
        regions.remove(a);
        while (regions.size() > 0) {
            Region b = a.closest(regions);
            int ax = (int)(a.cx * (double)w);
            int ay = (int)(a.cy * (double)h);
            int bx = (int)(b.cx * (double)w);
            int by = (int)(b.cy * (double)h);
            gi.drawLine(ax, ay, bx, by);
            a = (Region)regions.get(0);
            regions.remove(a);
        }
        gi.dispose();
        out = MOps2D.dilate(out);
        MOps2D.or(out, binary);
        return out;
    }

    public static BufferedImage discardRegions(BufferedImage binary, double minSize) {
        ObjectImage obi = new ObjectImage();
        obi.setRegions(binary);
        return MOps2D.bw2binary(obi.getLabeledImage());
    }

    public static BufferedImage equal(int[][] labels, TreeSet acceptable) {
        int w = labels.length;
        int h = labels[0].length;
        BufferedImage out = new BufferedImage(w, h, 12);
        WritableRaster wrasta = out.getRaster();
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                int v = labels[i][j];
                if (!acceptable.contains(v)) continue;
                wrasta.setSample(i, j, 0, 1);
            }
        }
        return out;
    }

    public static int objSize(BufferedImage source, int index) {
        Raster rasta = source.getData();
        int width = source.getWidth();
        int height = source.getHeight();
        int out = 0;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int pixel = rasta.getSample(i, j, 0);
                if (pixel != index) continue;
                ++out;
            }
        }
        return out;
    }

    public static int objSize(BufferedImage source) {
        return MOps2D.objSize(source, 1);
    }
}

