/*
 * Decompiled with CFR 0.152.
 */
package titech.image.dsp;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import titech.file.FileUtils;
import titech.image.dsp.ColorLabel;
import titech.image.dsp.Region;
import titech.image.math.AMath;
import titech.util.Utilities;

public class ObjectImage {
    public static final int NFEATURES = 15;
    public static final int RHISTO_SIZE = 22;
    public static final int CHISTO_SIZE = 52;
    double volAcceptance = 0.01;
    Vector<Region> regions;
    double contourCount = -1.0;
    double[] pwdistances = null;
    String location;
    String keywords;
    double[] histogram = null;
    double[] weights = new double[]{0.25, 0.25, 0.25, 0.25};
    double minDist;
    private int nlabels;
    private float[][] labmap;
    private int[] equivalences;
    BufferedImage labeledImage;
    BufferedImage original;

    public ObjectImage() {
        this.regions = new Vector();
        this.original = null;
        this.histogram = new double[74];
        try {
            InputStream stream = this.getClass().getResourceAsStream("/resources/histogram.palette");
            this.labmap = Utilities.loadPaletteLab(stream);
        }
        catch (Exception ex) {
            System.err.println("ObjectImage: " + ex);
        }
    }

    public ObjectImage(String os) {
        this.regions = new Vector();
        this.original = null;
        StringTokenizer stok = new StringTokenizer(os);
        try {
            int nregions = Integer.parseInt(stok.nextToken());
            this.contourCount = Double.parseDouble(stok.nextToken());
            this.pwdistances = new double[4];
            for (int k = 0; k < 4; ++k) {
                this.pwdistances[k] = Double.parseDouble(stok.nextToken());
            }
            for (int i = 1; i < nregions; ++i) {
                Region region = new Region();
                region.setColorCat(Integer.parseInt(stok.nextToken()));
                this.regions.add(region);
            }
            double[] features = new double[15];
            for (int i = 1; i < nregions; ++i) {
                for (int f = 0; f < 15; ++f) {
                    features[f] = Double.parseDouble(stok.nextToken());
                }
                Region region = this.regions.get(i - 1);
                region.setFeatures(features);
            }
        }
        catch (Exception e) {
            System.err.println("ObjectImage: " + e);
        }
    }

    public ObjectImage(int[][] labeledImage, int nlabels, BufferedImage source) {
        this(labeledImage, nlabels, source, 0.01);
    }

    public ObjectImage(int[][] labeledImage, int nlabels, BufferedImage source, double vol) {
        this.regions = new Vector();
        this.nlabels = nlabels;
        this.volAcceptance = vol;
        this.setRegions(labeledImage, source);
    }

    public void setOriginalImage(BufferedImage src) {
        this.original = src;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBThumbLocation() {
        return ObjectImage.thumbFromLocation(this.location);
    }

    public static String thumbFromLocation(String location) {
        String path = location.substring(0, location.lastIndexOf(File.separator));
        String filename = location.substring(location.lastIndexOf(File.separator) + 1);
        return path + File.separator + ".bthumbs" + File.separator + FileUtils.nameWOExtension(filename) + ".png";
    }

    public static String previewFromLocation(String location) {
        String path = location.substring(0, location.lastIndexOf(File.separator));
        String filename = location.substring(location.lastIndexOf(File.separator) + 1);
        return path + File.separator + "thumbs" + File.separator + filename;
    }

    public static String ccatFromLocation(String location) {
        String path = location.substring(0, location.lastIndexOf(File.separator));
        String filename = location.substring(location.lastIndexOf(File.separator) + 1);
        return path + File.separator + ".bthumbs" + File.separator + FileUtils.nameWOExtension(filename) + "-ccat.png";
    }

    public Region addRegion(BufferedImage img, Color stroke) {
        Region region = this.calculateFeatures(img);
        region.setColor(stroke);
        this.regions.add(region);
        return region;
    }

    public Region getRegion(int index) {
        return this.regions.get(index);
    }

    public Vector getRegions() {
        return this.regions;
    }

    public void clear() {
        this.regions.clear();
    }

    public Region calculateFeatures(BufferedImage img) {
        int r;
        int i;
        int j;
        int width = img.getWidth();
        int height = img.getHeight();
        int n = 0;
        double vol = 0.0;
        int minx = width;
        int maxx = 0;
        int miny = height;
        int maxy = 0;
        int momentX = 0;
        int momentY = 0;
        double momentXX = 0.0;
        double momentXY = 0.0;
        double momentYY = 0.0;
        double centerX = 0.0;
        double centerY = 0.0;
        double relativeVol = 0.0;
        double orientation = 0.0;
        double elongation = 0.0;
        for (j = 0; j < height; ++j) {
            for (i = 0; i < width; ++i) {
                r = img.getRGB(i, j) & 0xFFFFFF;
                if (r == 0) continue;
                ++n;
                if (i < minx) {
                    minx = i;
                }
                if (i > maxx) {
                    maxx = i;
                }
                if (j < miny) {
                    miny = j;
                }
                if (j > maxy) {
                    maxy = j;
                }
                momentX += i;
                momentY += j;
            }
        }
        if (n > 0) {
            centerX = (double)momentX / (double)n;
            centerY = (double)momentY / (double)n;
            for (j = miny; j < maxy; ++j) {
                for (i = minx; i < maxx; ++i) {
                    r = img.getRGB(i, j) & 0xFFFFFF;
                    if (r == 0) continue;
                    double pX = (double)i - centerX;
                    double pY = (double)j - centerY;
                    momentXX += pX * pX;
                    momentXY += pX * pY;
                    momentYY += pY * pY;
                }
            }
            orientation = Math.atan(((momentYY /= (double)n) - (momentXY *= 2.0 / (double)n)) / ((momentXX /= (double)n) - momentXY));
            if (momentYY < momentXY) {
                orientation = Math.abs(orientation) - 1.5707963267948966;
            }
            elongation = (Math.abs(momentXX - momentYY) + Math.abs(momentXY)) / AMath.max(momentXX, Math.abs(momentXY), momentYY);
            elongation = Math.min(elongation, 1.0);
            int w = maxx - minx + 1;
            int h = maxy - miny + 1;
            if (w * h > 0) {
                relativeVol = (double)n / (double)(w * h);
            }
            vol = (double)n / (double)(width * height);
            centerX /= (double)width;
            centerY /= (double)height;
        }
        Region region = new Region();
        region.setCenter(centerX, centerY);
        region.setVolume(vol, relativeVol);
        region.setOrientation(orientation);
        region.setElongation(elongation);
        return region;
    }

    public void setRegions(BufferedImage bim) {
        ColorLabel cl = new ColorLabel(bim);
        this.nlabels = cl.getNLabels();
        this.setRegions(cl.getLabeledMatrix(), bim);
        this.labeledImage = cl.getAsImage(this.regions, this.equivalences);
    }

    public void setRegions(int[][] img, BufferedImage bim) {
        int r;
        int i;
        int j;
        this.clear();
        int width = img.length;
        int height = img[0].length;
        int[] n = new int[this.nlabels];
        double[] vol = new double[this.nlabels];
        int[] minx = new int[this.nlabels];
        for (int i2 = 0; i2 < this.nlabels; ++i2) {
            minx[i2] = width;
        }
        int[] maxx = new int[this.nlabels];
        int[] miny = new int[this.nlabels];
        for (int i3 = 0; i3 < this.nlabels; ++i3) {
            miny[i3] = height;
        }
        int[] maxy = new int[this.nlabels];
        int[] momentX = new int[this.nlabels];
        int[] momentY = new int[this.nlabels];
        double[] momentXX = new double[this.nlabels];
        double[] momentYY = new double[this.nlabels];
        double[] momentXY = new double[this.nlabels];
        double[] centerX = new double[this.nlabels];
        double[] centerY = new double[this.nlabels];
        double[] relativeVol = new double[this.nlabels];
        double[] orientation = new double[this.nlabels];
        double[] elongation = new double[this.nlabels];
        double[][] meanColor = new double[this.nlabels][3];
        double[][] deviation = new double[this.nlabels][3];
        double[][] skewness = new double[this.nlabels][3];
        Raster rasta = null;
        if (this.original != null) {
            rasta = this.original.getData();
        }
        int[] color = new int[this.nlabels];
        for (j = 0; j < height; ++j) {
            for (i = 0; i < width; ++i) {
                int n2 = r = img[i][j];
                n[n2] = n[n2] + 1;
                if (r <= 0 || r >= this.nlabels) continue;
                if (i < minx[r]) {
                    minx[r] = i;
                }
                if (i > maxx[r]) {
                    maxx[r] = i;
                }
                if (j < miny[r]) {
                    miny[r] = j;
                }
                if (j > maxy[r]) {
                    maxy[r] = j;
                }
                int n3 = r;
                momentX[n3] = momentX[n3] + i;
                int n4 = r;
                momentY[n4] = momentY[n4] + j;
                if (rasta != null) {
                    double[] dArray = meanColor[r];
                    dArray[0] = dArray[0] + (double)rasta.getSample(i, j, 0);
                    double[] dArray2 = meanColor[r];
                    dArray2[1] = dArray2[1] + (double)rasta.getSample(i, j, 1);
                    double[] dArray3 = meanColor[r];
                    dArray3[2] = dArray3[2] + (double)rasta.getSample(i, j, 2);
                    continue;
                }
                color[r] = bim.getRGB(i, j);
            }
        }
        if (rasta != null) {
            for (int r2 = 1; r2 < this.nlabels; ++r2) {
                if (n[r2] <= 0) continue;
                int c = 0;
                while (c < 3) {
                    double[] dArray = meanColor[r2];
                    int n5 = c++;
                    dArray[n5] = dArray[n5] / (double)n[r2];
                }
            }
            for (j = 0; j < height; ++j) {
                for (i = 0; i < width; ++i) {
                    r = img[i][j];
                    if (r <= 0 || r >= this.nlabels) continue;
                    int c = 0;
                    while (c < 3) {
                        double p = (double)rasta.getSample(i, j, c) - meanColor[r][c];
                        double[] dArray = deviation[r];
                        int n6 = c;
                        dArray[n6] = dArray[n6] + p * p;
                        double[] dArray4 = skewness[r];
                        int n7 = c++;
                        dArray4[n7] = dArray4[n7] + p * p * p;
                    }
                }
            }
        }
        double colorNorm = 255.0;
        this.equivalences = new int[this.nlabels];
        this.equivalences[0] = 0;
        int nobjects = 0;
        for (int r3 = 1; r3 < this.nlabels; ++r3) {
            this.equivalences[r3] = 0;
            if (n[r3] <= 0) continue;
            centerX[r3] = (double)momentX[r3] / (double)n[r3];
            centerY[r3] = (double)momentY[r3] / (double)n[r3];
            for (int c = 0; c < 3; ++c) {
                double[] dArray = meanColor[r3];
                int n8 = c;
                dArray[n8] = dArray[n8] / colorNorm;
                deviation[r3][c] = Math.sqrt(deviation[r3][c] / (double)n[r3]) / colorNorm;
                skewness[r3][c] = AMath.qbic(skewness[r3][c] / (double)n[r3]) / colorNorm;
            }
            for (int j2 = miny[r3]; j2 < maxy[r3]; ++j2) {
                for (int i4 = minx[r3]; i4 < maxx[r3]; ++i4) {
                    if (img[i4][j2] != r3) continue;
                    double pX = (double)i4 - centerX[r3];
                    double pY = (double)j2 - centerY[r3];
                    int n9 = r3;
                    momentXX[n9] = momentXX[n9] + pX * pX;
                    int n10 = r3;
                    momentXY[n10] = momentXY[n10] + pX * pY;
                    int n11 = r3;
                    momentYY[n11] = momentYY[n11] + pY * pY;
                }
            }
            int n12 = r3;
            momentXX[n12] = momentXX[n12] / (double)n[r3];
            int n13 = r3;
            momentXY[n13] = momentXY[n13] * (2.0 / (double)n[r3]);
            int n14 = r3;
            momentYY[n14] = momentYY[n14] / (double)n[r3];
            orientation[r3] = Math.atan((momentYY[r3] - momentXY[r3]) / (momentXX[r3] - momentXY[r3]));
            if (momentYY[r3] < momentXY[r3]) {
                orientation[r3] = Math.abs(orientation[r3]) - 1.5707963267948966;
            }
            elongation[r3] = (Math.abs(momentXX[r3] - momentYY[r3]) + Math.abs(momentXY[r3])) / AMath.max(momentXX[r3], Math.abs(momentXY[r3]), momentYY[r3]);
            elongation[r3] = Math.min(elongation[r3], 1.0);
            int w = maxx[r3] - minx[r3] + 1;
            int h = maxy[r3] - miny[r3] + 1;
            if (w * h > 0) {
                relativeVol[r3] = (double)n[r3] / (double)(w * h);
            }
            vol[r3] = (double)n[r3] / (double)(width * height);
            int n15 = r3;
            centerX[n15] = centerX[n15] / (double)width;
            int n16 = r3;
            centerY[n16] = centerY[n16] / (double)height;
            if (!(vol[r3] > this.volAcceptance)) continue;
            Region region = new Region();
            region.setCenter(centerX[r3], centerY[r3]);
            region.setVolume(vol[r3], relativeVol[r3]);
            region.setOrientation(orientation[r3]);
            region.setElongation(elongation[r3]);
            if (rasta != null) {
                region.setColor(meanColor[r3], deviation[r3], skewness[r3]);
            } else {
                region.setColor(color[r3]);
            }
            this.regions.add(region);
            this.equivalences[r3] = ++nobjects;
        }
        if (this.labmap != null) {
            this.computeColorHistogram(bim, this.labmap);
            this.computeRegionHistogram();
        }
    }

    public int minDistanceRegion(Region query) {
        this.minDist = Double.MAX_VALUE;
        int minR = 0;
        for (int i = 0; i < this.regions.size(); ++i) {
            Region r = this.regions.get(i);
            double d = r.distance(query, this.weights, null);
            if (!(d < this.minDist)) continue;
            minR = i;
            this.minDist = d;
        }
        return minR;
    }

    public void setWeights(double position, double volume, double color, double orientation) {
        this.weights[0] = position;
        this.weights[1] = volume;
        this.weights[2] = color;
        this.weights[3] = orientation;
    }

    public double getMinDist() {
        return this.minDist;
    }

    public double[] getHistogram() {
        return this.histogram;
    }

    private void computeRegionHistogram() {
        for (int i = 0; i < 22; ++i) {
            this.histogram[i] = 0.0;
        }
        double[][] refPos = new double[][]{{0.16666666666666666, 0.16666666666666666}, {0.5, 0.16666666666666666}, {0.8333333333333334, 0.16666666666666666}, {0.16666666666666666, 0.5}, {0.5, 0.5}, {0.8333333333333334, 0.5}, {0.16666666666666666, 0.8333333333333334}, {0.5, 0.8333333333333334}, {0.8333333333333334, 0.8333333333333334}};
        double[] refVols = new double[]{0.6, 0.4, 0.2, 0.1, 0.05};
        double refRVol = 0.5;
        double[] refAngles = new double[]{0.0, 1.5707963267948966, 0.7853981633974483};
        double[] refElongs = new double[]{1.0, 1.0, 0.0};
        int nregions = this.regions.size();
        for (int r = 0; r < nregions; ++r) {
            int i;
            Region rg = this.regions.get(r);
            int n = i = AMath.findMin(new double[]{rg.cx, rg.cy}, refPos);
            this.histogram[n] = this.histogram[n] + rg.vol;
            i = AMath.findMin(rg.vol, refVols);
            int j = rg.rvol <= refRVol ? 0 : 1;
            int n2 = 9 + 2 * i + j;
            this.histogram[n2] = this.histogram[n2] + 1.0;
            i = AMath.findMinAngular(rg.orientation, refAngles, rg.elongation, refElongs);
            int n3 = 19 + i;
            this.histogram[n3] = this.histogram[n3] + rg.vol;
        }
        for (int i = 0; i < 10; ++i) {
            int n = 9 + i;
            this.histogram[n] = this.histogram[n] / (double)nregions;
        }
    }

    private void computeColorHistogram(BufferedImage image, float[][] labmap) {
        int height = image.getHeight();
        int width = image.getWidth();
        int bins = labmap.length;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int rgb = image.getRGB(i, j);
                float[] lab = Utilities.sRGBtoLab(rgb);
                int bin = AMath.findMin(lab, labmap);
                int n = 22 + bin;
                this.histogram[n] = this.histogram[n] + 1.0;
            }
        }
        for (int i = 0; i < bins; ++i) {
            int n = 22 + i;
            this.histogram[n] = this.histogram[n] / (double)(height * width);
        }
    }

    public String getDescriptor() {
        int n = this.regions.size();
        this.getContourSum();
        this.getPairwises();
        String descriptor = "" + (n + 1) + " " + this.contourCount + " ";
        for (int k = 0; k < 4; ++k) {
            descriptor = descriptor + this.pwdistances[k] + " ";
        }
        for (int i = 0; i < n; ++i) {
            Region r = this.regions.get(i);
            descriptor = descriptor + r.ccat + " ";
        }
        double[] ff = new double[15];
        for (int i = 0; i < n; ++i) {
            Region r = this.regions.get(i);
            r.getFeatures(ff);
            for (int f = 0; f < 15; ++f) {
                descriptor = descriptor + ff[f] + " ";
            }
        }
        return descriptor;
    }

    public double getContourSum() {
        return this.contourCount;
    }

    public double[] getPairwises() {
        if (this.pwdistances == null) {
            this.pairwiseDistances();
        }
        return this.pwdistances;
    }

    private void pairwiseDistances() {
        double[] distances = new double[]{0.0, 0.0, 0.0, 0.0};
        this.pwdistances = new double[]{0.0, 0.0, 0.0, 0.0};
        int n = this.regions.size();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                Region r1 = this.regions.get(i);
                Region r2 = this.regions.get(j);
                r1.distance(r2, distances);
                for (int k = 0; k < 4; ++k) {
                    int n2 = k;
                    this.pwdistances[n2] = this.pwdistances[n2] + distances[k];
                }
            }
        }
        if (n > 0) {
            int k = 0;
            while (k < 4) {
                int n3 = k++;
                this.pwdistances[n3] = this.pwdistances[n3] / ((double)n * (double)n);
            }
        }
    }

    BufferedImage getLabeledImage() {
        return this.labeledImage;
    }
}

