/*
 * Decompiled with CFR 0.152.
 */
package titech.image.dsp;

import java.awt.Color;
import java.util.Vector;
import titech.image.math.AMath;
import titech.util.Utilities;

public class Region {
    double cx;
    double cy;
    double vol;
    double rvol;
    double[] color;
    double[] deviation;
    double[] skewness;
    int ccat;
    double orientation;
    double elongation;

    void setCenter(double cx, double cy) {
        this.cx = cx;
        this.cy = cy;
    }

    void setVolume(double vol, double rvol) {
        this.vol = vol;
        this.rvol = rvol;
    }

    void setOrientation(double orientation) {
        this.orientation = orientation;
    }

    void setElongation(double elongation) {
        this.elongation = elongation;
    }

    void setColor(Color rgb) {
        float[] rgbvector = new float[]{(float)rgb.getRed() / 255.0f, (float)rgb.getGreen() / 255.0f, (float)rgb.getBlue() / 255.0f};
        this.color = AMath.multV(AMath.toDouble(Utilities.sRGBtoLab(rgbvector)), 0.01);
    }

    void setColor(int rgb) {
        float[] v = new float[]{rgb >> 16, rgb >> 8 & 0xFF, rgb & 0xFF};
        v[0] = v[0] / 255.0f;
        v[1] = v[1] / 255.0f;
        v[2] = v[2] / 255.0f;
        this.color = AMath.multV(AMath.toDouble(Utilities.sRGBtoLab(v)), 0.01);
    }

    void setColor(double[] mean, double[] dev, double[] skw) {
        int i;
        float[] v = new float[3];
        for (i = 0; i < 3; ++i) {
            v[i] = (float)mean[i];
        }
        this.color = AMath.multV(AMath.toDouble(Utilities.sRGBtoLab(v)), 0.01);
        for (i = 0; i < 3; ++i) {
            v[i] = (float)dev[i];
        }
        this.deviation = AMath.multV(AMath.toDouble(Utilities.sRGBtoLab(v)), 0.01);
        for (i = 0; i < 3; ++i) {
            v[i] = (float)skw[i];
        }
        this.skewness = AMath.multV(AMath.toDouble(Utilities.sRGBtoLab(v)), 0.01);
    }

    void setColorCat(int cat) {
        this.ccat = cat;
    }

    void setFeatures(double[] features) {
        this.cx = features[0];
        this.cy = features[1];
        this.vol = features[2];
        this.rvol = features[3];
        this.color = new double[]{features[4], features[5], features[6]};
        this.deviation = new double[]{features[7], features[8], features[9]};
        this.skewness = new double[]{features[10], features[11], features[12]};
        this.orientation = features[13];
        this.elongation = features[14];
    }

    double[] getFeatures() {
        return this.getFeatures(null);
    }

    double[] getFeatures(double[] ff) {
        if (ff == null) {
            ff = new double[15];
        }
        ff[0] = this.cx;
        ff[1] = this.cy;
        ff[2] = this.vol;
        ff[3] = this.rvol;
        for (int i = 0; i < 3; ++i) {
            ff[4 + i] = this.color[i];
            ff[7 + i] = this.deviation[i];
            ff[10 + i] = this.skewness[i];
        }
        ff[13] = this.orientation;
        ff[14] = this.elongation;
        return ff;
    }

    double distance(Region pair) {
        return this.distance(pair, new double[]{0.25, 0.25, 0.25, 0.25}, null);
    }

    double distance(Region pair, double[] distances) {
        return this.distance(pair, new double[]{0.25, 0.25, 0.25, 0.25}, distances);
    }

    double distance(Region pair, double[] weights, double[] distances) {
        double pd = Math.sqrt((this.cx - pair.cx) * (this.cx - pair.cx) + (this.cy - pair.cy) * (this.cy - pair.cy));
        double vd = Math.sqrt((this.vol - pair.vol) * (this.vol - pair.vol) + (this.rvol - pair.rvol) * (this.rvol - pair.rvol));
        double cd = 0.0;
        if (weights[2] > 0.0) {
            for (int c = 0; c < 3; ++c) {
                cd += (this.color[c] - pair.color[c]) * (this.color[c] - pair.color[c]);
            }
            cd = Math.sqrt(cd);
        }
        double cosa = Math.cos(this.orientation) * Math.cos(pair.orientation) + Math.sin(this.orientation) * Math.sin(pair.orientation);
        double ed = Math.abs(this.elongation - pair.elongation);
        double od = (this.elongation * pair.elongation * (1.0 - Math.abs(cosa)) + ed) / 2.0;
        if (distances != null && distances.length > 3) {
            distances[0] = pd;
            distances[1] = vd;
            distances[2] = cd;
            distances[3] = od;
        }
        double dist = pd * weights[0] + vd * weights[1] + cd * weights[2] + od * weights[3];
        return dist;
    }

    public Region closest(Vector regions) {
        Region min = null;
        double dist = Double.MAX_VALUE;
        for (int i = 0; i < regions.size(); ++i) {
            Region r = (Region)regions.get(i);
            double x = this.cx - r.cx;
            double y = this.cy - r.cy;
            double d = x * x + y * y;
            if (!(d < dist)) continue;
            dist = d;
            min = r;
        }
        return min;
    }

    public String toString() {
        return "{(" + this.cx + "," + this.cy + "), " + "(" + this.vol + "," + this.rvol + "), " + this.orientation + ", " + this.elongation + "}";
    }
}

