/*
 * Decompiled with CFR 0.152.
 */
package titech.image.dsp;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.InputStream;
import titech.cluster.KMeans;
import titech.image.dsp.MOps2D;
import titech.image.dsp.ObjectImage;
import titech.image.math.AMath;
import titech.util.Utilities;

public class Segmenter {
    public static final int IMGLONG = 80;
    public static final double COLOR_MIN_SIZE = 0.05;
    public static final int M_SIZE = 5;
    BufferedImage segmented;
    BufferedImage quantized;
    byte[] catLut = new byte[32768];
    float[] labLut = new float[98304];
    byte[][] univPal = null;

    public BufferedImage getSegmentedImage() {
        return this.segmented;
    }

    public BufferedImage getQuantizedImage() {
        return this.quantized;
    }

    public Segmenter() {
        try {
            InputStream is = this.getClass().getResourceAsStream("/resources/cc14.raw");
            is.read(this.catLut);
            is.close();
            is = this.getClass().getResourceAsStream("/resources/lab15bit.raw");
            DataInputStream din = new DataInputStream(is);
            for (int r = 0; r < 32; ++r) {
                for (int g = 0; g < 32; ++g) {
                    for (int b = 0; b < 32; ++b) {
                        for (int i = 0; i < 3; ++i) {
                            float ff;
                            this.labLut[3072 * r + 96 * g + 3 * b + i] = ff = din.readFloat();
                        }
                    }
                }
            }
            din.close();
            is = this.getClass().getResourceAsStream("/resources/universalEx.palette");
            this.univPal = Utilities.loadPalette(is);
            is.close();
        }
        catch (Exception e) {
            System.err.println("Segmenter: Couldn't load resources!");
        }
    }

    public ObjectImage getKMedianRegions(BufferedImage img) {
        ObjectImage oimg = null;
        try {
            BufferedImage reg;
            BufferedImage rop = Utilities.resize(img, 80);
            BufferedImage ccat = this.colorCategorization(rop);
            int npixels = rop.getWidth() * rop.getHeight();
            int[] initialAssignment = new int[npixels];
            int k = this.countPresentCategories(ccat, initialAssignment);
            k = Math.max(2, k);
            this.quantized = reg = this.clusterKMeans(rop, k, initialAssignment);
            this.segmented = MOps2D.maxPercentil(14, reg, 5);
            oimg = new ObjectImage();
            oimg.setOriginalImage(rop);
            oimg.setRegions(this.segmented);
            this.segmented = oimg.getLabeledImage();
        }
        catch (Exception exc) {
            System.err.println("Segmenter: " + exc);
        }
        return oimg;
    }

    public static BufferedImage createIndexedImage(int width, int height, byte[][] colormap) {
        IndexColorModel indexColorModel = new IndexColorModel(8, colormap[0].length, colormap[0], colormap[1], colormap[2]);
        BufferedImage indexed = new BufferedImage(width, height, 13, indexColorModel);
        return indexed;
    }

    BufferedImage colorCategorization(BufferedImage source) {
        int w = source.getWidth();
        int h = source.getHeight();
        BufferedImage sgm = Segmenter.createIndexedImage(w, h, this.univPal);
        WritableRaster wr = sgm.getRaster();
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                int col = source.getRGB(i, j);
                wr.setSample(i, j, 0, AMath.byteToInt(this.colorCategory(col)));
            }
        }
        return sgm;
    }

    byte colorCategory(int colour) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        byte category = this.catLut[(r >>= 3) * 32 * 32 + (g >>= 3) * 32 + (b >>= 3)];
        return category;
    }

    public BufferedImage clusterKMeans(BufferedImage image, int k, int[] initialClusters) {
        int bands = image.getSampleModel().getNumBands();
        int height = image.getHeight();
        int width = image.getWidth();
        byte[][] colormap = new byte[3][256];
        double[][] data = new double[height * width][bands];
        int i = 0;
        Raster raster = image.getData();
        for (int samp = 0; samp < width; ++samp) {
            for (int line = 0; line < height; ++line) {
                int r = raster.getSample(samp, line, 0);
                int g = raster.getSample(samp, line, 1);
                int b = raster.getSample(samp, line, 2);
                int index = (r >>= 3) * 32 * 32 * 3 + (g >>= 3) * 32 * 3 + (b >>= 3) * 3;
                for (int mi = 0; mi < 3; ++mi) {
                    data[i][mi] = this.labLut[index + mi];
                }
                ++i;
            }
        }
        KMeans cluster = new KMeans(k, data, initialClusters);
        int[] clases = cluster.getAssignments();
        double[][] means = cluster.getMeans();
        colormap[0][0] = 80;
        colormap[1][0] = 80;
        colormap[2][0] = 80;
        double colorNorm = 1.0;
        for (i = 0; i < k; ++i) {
            int j;
            float[] col = new float[3];
            for (j = 0; j < 3; ++j) {
                col[j] = (float)(colorNorm * means[i][j]);
            }
            col = Utilities.LabtosRGB(col);
            j = 0;
            while (j < 3) {
                int n = j++;
                col[n] = col[n] * 255.0f;
            }
            for (j = 0; j < 3; ++j) {
                colormap[j][i + 1] = (byte)col[j];
            }
        }
        BufferedImage outImage = Segmenter.createIndexedImage(image.getWidth(), image.getHeight(), colormap);
        i = 0;
        WritableRaster wrasta = outImage.getRaster();
        for (int samp = 0; samp < width; ++samp) {
            for (int line = 0; line < height; ++line) {
                wrasta.setSample(samp, line, 0, clases[i++]);
            }
        }
        return outImage;
    }

    public int countPresentCategories(BufferedImage ccat, int[] output) {
        int height = ccat.getHeight();
        int width = ccat.getWidth();
        int ncats = 16;
        int[] votes = new int[ncats + 1];
        Raster rasta = ccat.getData();
        for (int samp = 0; samp < width; ++samp) {
            for (int line = 0; line < height; ++line) {
                int value;
                int n = value = rasta.getSample(samp, line, 0);
                votes[n] = votes[n] + 1;
            }
        }
        int r = 0;
        double npixels = height * width;
        for (int i = 0; i <= ncats; ++i) {
            double amount = (double)votes[i] / npixels;
            if (!(amount > 0.05)) continue;
            ++r;
        }
        if (output != null && (double)output.length >= npixels) {
            int j = 0;
            for (int samp = 0; samp < width; ++samp) {
                for (int line = 0; line < height; ++line) {
                    int cc = rasta.getSample(samp, line, 0);
                    output[j++] = cc % r;
                }
            }
        }
        return r;
    }

    public BufferedImage quantizeWithMinLab(BufferedImage src, BufferedImage reference) {
        int w = src.getWidth();
        int h = src.getHeight();
        IndexColorModel icModel = (IndexColorModel)reference.getColorModel();
        BufferedImage out = new BufferedImage(w, h, 13, icModel);
        Raster rasta = src.getData();
        WritableRaster wrasta = out.getRaster();
        int n = MOps2D.maxValue(reference) + 1;
        double[][] colormap = new double[n - 1][3];
        for (int i = 1; i < n; ++i) {
            int r = icModel.getRed(i);
            int g = icModel.getGreen(i);
            int b = icModel.getBlue(i);
            int index = (r >>= 3) * 32 * 32 * 3 + (g >>= 3) * 32 * 3 + (b >>= 3) * 3;
            for (int mi = 0; mi < 3; ++mi) {
                colormap[i - 1][mi] = this.labLut[index + mi];
            }
        }
        double[] lab = new double[3];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int r = rasta.getSample(x, y, 0);
                int g = rasta.getSample(x, y, 1);
                int b = rasta.getSample(x, y, 2);
                int index = (r >>= 3) * 32 * 32 * 3 + (g >>= 3) * 32 * 3 + (b >>= 3) * 3;
                for (int mi = 0; mi < 3; ++mi) {
                    lab[mi] = this.labLut[index + mi];
                }
                int i = AMath.findMin(lab, colormap);
                wrasta.setSample(x, y, 0, i + 1);
            }
        }
        return out;
    }

    public static void main(String[] args) {
        try {
            BufferedImage img = Utilities.loadImage(args[0]);
            Segmenter segm = new Segmenter();
            BufferedImage ccat = segm.colorCategorization(img);
            String output = "ccat.png";
            if (args.length > 1) {
                output = args[1];
            }
            Utilities.saveImage(ccat, "png", output);
        }
        catch (Exception exc) {
            System.err.println("Segmenter: " + exc);
        }
    }
}

