/*
 * Decompiled with CFR 0.152.
 */
package titech.image.math;

import java.util.StringTokenizer;
import java.util.Vector;

public class AMath {
    public static final double NEZERO = 1.0E-10;
    public static final double VERY_BIG = 1.0E10;

    public static double distance(double[] a, double[] b) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double f = a[i] - b[i];
            sum += f * f;
        }
        return Math.sqrt(sum);
    }

    public static double distance(double[] a, double[] b, int dima, int dimb) {
        double sum = 0.0;
        for (int i = dima; i <= dimb; ++i) {
            double f = a[i] - b[i];
            sum += f * f;
        }
        return Math.sqrt(sum);
    }

    public static double distanceSqr(double[] a, double[] b) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double f = a[i] - b[i];
            sum += f * f;
        }
        return sum;
    }

    public static double distanceSqr(double[] a, double[] b, int dima, int dimb) {
        double sum = 0.0;
        for (int i = dima; i <= dimb; ++i) {
            double f = a[i] - b[i];
            sum += f * f;
        }
        return sum;
    }

    public static double distance(int[] a, int[] b) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double f = a[i] - b[i];
            sum += f * f;
        }
        return Math.sqrt(sum);
    }

    public static double atangent(double x, double y) {
        return Math.abs(y) > 1.0E-10 ? Math.atan2(x, y) : (x > 0.0 ? 1.5707963267948966 : -1.5707963267948966);
    }

    public static double sqr(double d) {
        return d * d;
    }

    public static double qbic(double d) {
        double res = d < 0.0 ? -1.0 : 1.0;
        d = Math.abs(d);
        return res *= Math.pow(d, 0.3333333333333333);
    }

    public static double sum(double[][] m) {
        double s = 0.0;
        for (int i = 0; i < m[0].length; ++i) {
            for (int j = 0; j < m.length; ++j) {
                s += m[i][j];
            }
        }
        return s;
    }

    public static double sum(double[] m) {
        double s = 0.0;
        for (int i = 0; i < m.length; ++i) {
            s += m[i];
        }
        return s;
    }

    public static double sum(float[] m) {
        double s = 0.0;
        for (int i = 0; i < m.length; ++i) {
            s += (double)m[i];
        }
        return s;
    }

    public static double[][] mult(double[][] m, double val) {
        for (int i = 0; i < m.length; ++i) {
            int j = 0;
            while (j < m[i].length) {
                double[] dArray = m[i];
                int n = j++;
                dArray[n] = dArray[n] * val;
            }
        }
        return m;
    }

    public static double[][] add(double[][] m, double val) {
        for (int i = 0; i < m.length; ++i) {
            int j = 0;
            while (j < m[i].length) {
                double[] dArray = m[i];
                int n = j++;
                dArray[n] = dArray[n] + val;
            }
        }
        return m;
    }

    public static double[] multV(double[] m, double val) {
        int i = 0;
        while (i < m.length) {
            int n = i++;
            m[n] = m[n] * val;
        }
        return m;
    }

    public static float[] fmultV(float[] v, float[][] M) {
        float[] r = new float[M[0].length];
        for (int i = 0; i < v.length; ++i) {
            r[i] = 0.0f;
            for (int j = 0; j < M.length; ++j) {
                int n = i;
                r[n] = r[n] + v[j] * M[i][j];
            }
        }
        return r;
    }

    public static float[] fmultV(float[] v, float ct) {
        float[] r = new float[v.length];
        for (int i = 0; i < v.length; ++i) {
            r[i] = v[i] * ct;
        }
        return r;
    }

    public static int[][] toInt(double[][] m) {
        int[][] res = new int[m.length][];
        for (int i = 0; i < m.length; ++i) {
            res[i] = new int[m[i].length];
            for (int j = 0; j < m[i].length; ++j) {
                res[i][j] = (int)m[i][j];
            }
        }
        return res;
    }

    public static float[] flattenFloat(double[][] m) {
        if (m == null) {
            return null;
        }
        int width = m[0].length;
        int height = m.length;
        float[] flat = new float[width * height];
        int k = 0;
        for (int i = 0; i < m[0].length; ++i) {
            for (int j = 0; j < m.length; ++j) {
                flat[k++] = (float)m[i][j];
            }
        }
        return flat;
    }

    public static int[] flattenInt(int[][] m) {
        if (m == null) {
            return null;
        }
        int width = m[0].length;
        int height = m.length;
        int[] flat = new int[width * height];
        int k = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                flat[k++] = m[i][j];
            }
        }
        return flat;
    }

    public static int[] flattenInt(byte[][] m) {
        if (m == null) {
            return null;
        }
        int width = m[0].length;
        int height = m.length;
        int[] flat = new int[width * height];
        int k = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                flat[k++] = m[i][j];
            }
        }
        return flat;
    }

    public static int[] vflattenInt(byte[][] m) {
        if (m == null) {
            return null;
        }
        int width = m[0].length;
        int height = m.length;
        int[] flat = new int[width * height];
        int k = 0;
        for (int j = 0; j < width; ++j) {
            for (int i = 0; i < height; ++i) {
                flat[k++] = m[i][j];
            }
        }
        return flat;
    }

    public static String showMatrix(double[][] m) {
        if (m == null) {
            return new String("{ (empty) }");
        }
        String s = new String("{ ");
        for (int i = 0; i < m.length; ++i) {
            s = s + " " + m[i][0];
            for (int j = 1; j < m[i].length; ++j) {
                s = s + ", " + m[i][j];
            }
            s = s + "\n";
        }
        s = s + "}";
        return s;
    }

    public static String showMatrix(byte[][] m) {
        if (m == null) {
            return new String("{ (empty) }");
        }
        String s = new String("{ ");
        for (int i = 0; i < m.length; ++i) {
            s = s + " " + m[i][0];
            for (int j = 1; j < m[i].length; ++j) {
                s = s + ", " + m[i][j];
            }
            s = s + "\n";
        }
        s = s + "}";
        return s;
    }

    public static String showMatrix(int[][] m) {
        if (m == null) {
            return new String("{ (empty) }");
        }
        String s = new String("{ ");
        for (int i = 0; i < m.length; ++i) {
            s = s + " " + m[i][0];
            for (int j = 1; j < m[i].length; ++j) {
                s = s + ", " + m[i][j];
            }
            s = s + "\n";
        }
        s = s + "}";
        return s;
    }

    public static String showVector(int[] m) {
        if (m == null) {
            return new String("{ (empty) }");
        }
        String s = new String("{ " + m[0]);
        for (int i = 1; i < m.length; ++i) {
            s = s + ", " + m[i];
        }
        s = s + "}";
        return s;
    }

    public static String showVector(float[] m) {
        if (m == null) {
            return new String("{ (empty) }");
        }
        String s = new String("{ " + m[0]);
        for (int i = 1; i < m.length; ++i) {
            s = s + ", " + m[i];
        }
        s = s + "}";
        return s;
    }

    public static String showVector(double[] m) {
        if (m == null) {
            return new String("(empty)");
        }
        String s = new String("" + m[0]);
        for (int i = 1; i < m.length; ++i) {
            s = s + ", " + m[i];
        }
        return s;
    }

    public static String showVector(Vector v) {
        if (v == null) {
            return new String("{ (empty) }");
        }
        String s = new String("{ " + v.firstElement());
        for (int i = 1; i < v.size(); ++i) {
            s = s + ", " + v.elementAt(i);
        }
        s = s + "}";
        return s;
    }

    public static boolean inRange(double[] low, double[] vector, double[] top) {
        for (int i = 0; i < vector.length; ++i) {
            if (low[i] > vector[i]) {
                return false;
            }
            if (!(vector[i] > top[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean inRange(float[] low, float[] vector, float[] top) {
        for (int i = 0; i < vector.length; ++i) {
            if (low[i] > vector[i]) {
                return false;
            }
            if (!(vector[i] > top[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean inVector(int value, int[] vector) {
        for (int i = 0; i < vector.length; ++i) {
            if (vector[i] != value) continue;
            return true;
        }
        return false;
    }

    public static void trim(float[] low, float[] vector, float[] top) {
        for (int i = 0; i < vector.length; ++i) {
            if (low[i] > vector[i]) {
                vector[i] = low[i];
            }
            if (!(vector[i] > top[i])) continue;
            vector[i] = top[i];
        }
    }

    public static void trimTop(float[] vector, float[] top) {
        for (int i = 0; i < vector.length; ++i) {
            if (!(vector[i] > top[i])) continue;
            vector[i] = top[i];
        }
    }

    public static double[] toDouble(float[] v) {
        double[] dv = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            dv[i] = v[i];
        }
        return dv;
    }

    public static float[] toFloat(double[] v) {
        float[] fv = new float[v.length];
        for (int i = 0; i < v.length; ++i) {
            fv[i] = (float)v[i];
        }
        return fv;
    }

    public static float[] toFloat(byte[] v) {
        float[] fv = new float[v.length];
        for (int i = 0; i < v.length; ++i) {
            fv[i] = v[i] < 0 ? 256.0f + (float)v[i] : (float)v[i];
        }
        return fv;
    }

    public static double max(double a, double b, double c) {
        return a > b && a > c ? a : (b > c ? b : c);
    }

    public static int byteToInt(byte[] v) {
        int r = 0;
        int i = 0;
        int j = 0;
        while (i < v.length) {
            r |= (v[i] < 0 ? 256 + v[i] : v[i]) << j;
            ++i;
            j += 8;
        }
        return r;
    }

    public static int byteToInt(byte red, byte green, byte blue) {
        return AMath.byteToInt(new byte[]{blue, green, red});
    }

    public static int byteToInt(byte val) {
        return val < 0 ? 256 + val : val;
    }

    public static int findMin(double[] vector, double[][] data) {
        int minIndex = 0;
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            double distance = 0.0;
            for (int j = 0; j < vector.length; ++j) {
                distance += (vector[j] - data[i][j]) * (vector[j] - data[i][j]);
            }
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minIndex = i;
        }
        return minIndex;
    }

    public static int findMin(float[] vector, float[][] data) {
        int minIndex = 0;
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            double distance = 0.0;
            for (int j = 0; j < vector.length; ++j) {
                distance += (double)((vector[j] - data[i][j]) * (vector[j] - data[i][j]));
            }
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minIndex = i;
        }
        return minIndex;
    }

    public static int findMin(double[] vector, double[][] data, int dima, int dimb) {
        int minIndex = 0;
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            double distance = 0.0;
            for (int j = dima; j <= dimb; ++j) {
                distance += (vector[j] - data[i][j]) * (vector[j] - data[i][j]);
            }
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minIndex = i;
        }
        return minIndex;
    }

    public static int findMin(double value, double[] data) {
        int minIndex = 0;
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            double distance = Math.abs(value - data[i]);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minIndex = i;
        }
        return minIndex;
    }

    public static int indexMax(int[] vec) {
        int index = 0;
        int value = vec[0];
        for (int i = 1; i < vec.length; ++i) {
            if (vec[i] <= value) continue;
            index = i;
            value = vec[i];
        }
        return index;
    }

    public static int findMinAngular(double a, double[] adata, double e, double[] edata) {
        int minIndex = 0;
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < adata.length; ++i) {
            double cosa = Math.cos(a) * Math.cos(adata[i]) + Math.sin(a) * Math.sin(adata[i]);
            double distance = 1.0 - Math.abs(cosa);
            if (edata != null) {
                distance = (e * edata[i] * distance + Math.abs(e - edata[i])) / 2.0;
            }
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minIndex = i;
        }
        return minIndex;
    }

    public static double[] vectorDouble(String s) {
        StringTokenizer stok = new StringTokenizer(s, ",");
        int n = stok.countTokens();
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = Double.parseDouble(stok.nextToken());
        }
        return v;
    }
}

