/*
 * Decompiled with CFR 0.152.
 */
package titech.image.matting;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.TreeSet;
import java.util.Vector;
import titech.image.dsp.COps;
import titech.image.dsp.ColorLabel;
import titech.image.dsp.MOps2D;
import titech.image.dsp.Segmenter;
import titech.image.matting.Poisson;
import titech.util.Utilities;
import titech.util.ValuePair;
import titech.wt.ClipCanvas;
import titech.wt.CompositeCanvas;
import titech.wt.SimpleCanvas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Boundary
implements Runnable {
    public static final int NO_OPTIMIZATION = 0;
    public static final int HARD_SEGMENTATION = 1;
    public static final int INTELLIGENT_SCISSORS = 2;
    public static final int INTELLIGENT_ERODE = 3;
    public static final int DILATION = 25;
    public static final float SIGMA = 4.0f;
    public static final int PADDING = 50;
    public static final Kernel KERNEL = Utilities.gaussian2Dkernel(4.0f);
    public static final int MIN_LENGTH = 50;
    BufferedImage indexedImage;
    BufferedImage segmented;
    BufferedImage contour;
    BufferedImage mask;
    BufferedImage resultMask;
    BufferedImage sourceImage;
    BufferedImage targetImage;
    BufferedImage externalContour;
    Vector<Point> contourPoints;
    Rectangle clipArea;
    Rectangle maskBB;
    Dimension dim;
    int index;
    int poissonType;
    int method;
    double sGradient;
    double poissonAccuracy;
    public boolean alphaMatting;
    public boolean gradientDifference;
    boolean debugging = false;
    String debuggingDirectory = "/Users/david/Desktop/debug";
    ClipCanvas canvas = null;
    CompositeCanvas compositeCanvas = null;
    SimpleCanvas debugCanvas = null;
    private BufferedImage roughSegmentation = null;
    Segmenter segmenter;

    void debug(BufferedImage img, String name) {
        if (this.debugging) {
            try {
                name = Utilities.dateStamp() + "-" + name;
                Utilities.saveImage(img, "png", this.debuggingDirectory + "/" + name + ".png");
            }
            catch (Exception e) {
                System.err.println("Boundary debug: " + e);
            }
        }
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public void setGradientMethod(int method) {
        this.gradientDifference = method != 0;
    }

    public void setExternalContour(BufferedImage lineImage) {
        if (lineImage == null) {
            this.externalContour = null;
            return;
        }
        BufferedImage mask = MOps2D.equalNot(lineImage, 0);
        BufferedImage inner = MOps2D.bw2binary(mask);
        this.debug(mask, "contour01");
        MOps2D.floodfill4(inner, -1, -1);
        MOps2D.not(inner);
        MOps2D.or(mask, inner);
        this.externalContour = MOps2D.gradient(mask);
        BufferedImage out = null;
        if (this.method == 1 || this.method == 2) {
            BufferedImage outside = MOps2D.dilate(mask);
            BufferedImage resized = this.canvas.getImage();
            this.maskBB = MOps2D.getBB(outside);
            BufferedImage sgm = this.createClipped(resized, 1);
            sgm = this.segmenter.quantizeWithMinLab(sgm, this.segmented);
            sgm = MOps2D.maxPercentil(sgm, 3);
            BufferedImage outclipped = this.createClipped(outside, 12);
            MOps2D.and(sgm, outclipped);
            this.debug(sgm);
            this.debug(sgm, "CQ");
            ColorLabel cl = new ColorLabel(sgm);
            out = this.createClipped(mask, 12);
            out = MOps2D.fill4(cl.getLabeledMatrix(), out);
            out = MOps2D.discardRegions(out, 0.01);
            if (this.method == 2) {
                out = MOps2D.connectRegions(out);
            }
            this.externalContour = this.createClipped(this.externalContour, 12);
        } else if (this.method == 3) {
            this.maskBB = MOps2D.getBB(MOps2D.dilate(mask));
            this.externalContour = this.createClipped(this.externalContour, 12);
            BufferedImage lineMask = this.createClipped(MOps2D.equalNot(lineImage, 0), 12);
            int[] strel = new int[31];
            for (int i = 0; i < 31; ++i) {
                strel[i] = 1;
            }
            BufferedImage inside = MOps2D.bw2binary(lineMask);
            MOps2D.floodfill4(inside, -1, -1);
            MOps2D.not(inside);
            this.debug(inside);
            out = inside;
        } else {
            this.maskBB = MOps2D.getBB(MOps2D.dilate(mask));
            this.externalContour = this.createClipped(this.externalContour, 12);
            out = mask = this.createClipped(mask, 12);
        }
        this.debug(mask, "contour02");
        this.debug(out, "contour03");
        this.debug(this.externalContour, "contour04");
        this.dim = null;
        this.update(null, out, 1);
        this.updateGraphics(this.contour);
    }

    public void clearExternalContour() {
        this.externalContour = null;
    }

    public void setCanvas(ClipCanvas canvas) {
        this.canvas = canvas;
    }

    public void setDebugCanvas(SimpleCanvas dbug) {
        this.debugCanvas = dbug;
    }

    public void setComposite(CompositeCanvas canvas) {
        this.compositeCanvas = canvas;
    }

    public void setSource(BufferedImage source) {
        this.sourceImage = source;
    }

    public void setSegmented(BufferedImage ccat) {
        BufferedImage inside;
        this.segmented = ccat;
        this.roughSegmentation = inside = MOps2D.equal(this.indexedImage, this.index, this.canvas.getMaxSize());
        this.update(null, inside, 1);
    }

    public void setSegmentedThreaded() {
        BufferedImage inside = this.roughSegmentation;
        this.debug(inside, "sst01");
        int[] strel = new int[31];
        for (int i = 0; i < 31; ++i) {
            strel[i] = 1;
        }
        BufferedImage outside = MOps2D.dilate(inside, strel);
        inside = MOps2D.erode(outside, false);
        BufferedImage resized = this.canvas.getImage();
        this.maskBB = MOps2D.getBB(outside);
        int w = (int)this.maskBB.getWidth();
        int h = (int)this.maskBB.getHeight();
        BufferedImage sgm = new BufferedImage(w, h, 1);
        Graphics gi = sgm.getGraphics();
        gi.drawImage(resized, (int)(-this.maskBB.getMinX()), (int)(-this.maskBB.getMinY()), null);
        gi.dispose();
        sgm = this.segmenter.quantizeWithMinLab(sgm, this.segmented);
        sgm = MOps2D.maxPercentil(sgm, 3);
        BufferedImage outclipped = new BufferedImage(w, h, 12);
        gi = outclipped.getGraphics();
        gi.drawImage(outside, (int)(-this.maskBB.getMinX()), (int)(-this.maskBB.getMinY()), null);
        gi.dispose();
        MOps2D.and(sgm, outclipped);
        this.debug(sgm);
        ColorLabel cl = new ColorLabel(sgm);
        System.out.println("setSegmented: " + cl.getNLabels() + " labels");
        BufferedImage out = new BufferedImage(w, h, 12);
        gi = out.getGraphics();
        gi.drawImage(inside, (int)(-this.maskBB.getMinX()), (int)(-this.maskBB.getMinY()), null);
        gi.dispose();
        out = MOps2D.fill4(cl.getLabeledMatrix(), out);
        out = MOps2D.discardRegions(out, 0.01);
        double newsize = MOps2D.objSize(out) + 1;
        double oldsize = MOps2D.objSize(inside) + 1;
        if (newsize / oldsize < 0.5) {
            gi = out.getGraphics();
            gi.clearRect(0, 0, w, h);
            gi.drawImage(this.roughSegmentation, (int)(-this.maskBB.getMinX()), (int)(-this.maskBB.getMinY()), null);
            gi.dispose();
        }
        if (this.compositeCanvas != null) {
            this.compositeCanvas.addOffset((int)this.maskBB.getMinX(), (int)this.maskBB.getMinY());
        }
        this.roughSegmentation = null;
        this.dim = null;
        this.update(null, out, 1);
    }

    public void setTarget(BufferedImage target) {
        this.targetImage = target;
    }

    public BufferedImage getContour() {
        return this.contour;
    }

    public Boundary(BufferedImage indexedImage, int index) {
        this(indexedImage, index, null);
    }

    public Boundary(BufferedImage indexedImage, int index, Dimension dim) {
        this(indexedImage, index, dim, null);
    }

    public Boundary(BufferedImage indexedImage, int index, Dimension dim, Rectangle clip) {
        this.dim = dim;
        this.indexedImage = indexedImage;
        this.index = index;
        this.poissonType = 0;
        this.poissonAccuracy = 0.05;
        this.sGradient = 0.0;
        this.method = 0;
        this.externalContour = null;
        this.alphaMatting = false;
        this.gradientDifference = false;
        this.clipArea = clip;
        this.segmenter = new Segmenter();
    }

    public void update() {
        this.update(this.clipArea);
    }

    public void update(Rectangle clip) {
        this.clipArea = clip;
        this.setSegmented(this.segmented);
    }

    public void update(Rectangle clip, BufferedImage indexedImage, int index) {
        BufferedImage gr;
        this.clipArea = clip;
        if (this.dim != null) {
            gr = MOps2D.gradient(indexedImage, index, this.dim);
        } else {
            gr = MOps2D.gradient(indexedImage, index);
            this.dim = new Dimension(indexedImage.getWidth(), indexedImage.getHeight());
        }
        if (clip != null && this.canvas == null) {
            gr = gr.getSubimage(clip.x, clip.y, clip.width, clip.height);
        }
        this.debug(gr, "update01");
        BufferedImage ccaux = MOps2D.bw2binary(gr);
        MOps2D.floodfill4(ccaux, -1, -1);
        MOps2D.not(ccaux);
        this.debug(ccaux, "update02");
        MOps2D.or(ccaux, gr);
        this.mask = MOps2D.colorMask(ccaux, -1);
        this.debug(this.mask, "update03");
        this.contour = MOps2D.gradient(ccaux);
        this.contour = MOps2D.colorMask(this.contour, -16711936);
        this.debug(this.contour, "update04");
        this.contourPoints = MOps2D.listPoints(this.contour, -16711936);
        this.resultMask = this.mask;
        this.debug(this.resultMask, "update05");
    }

    public BufferedImage maskImage() {
        return this.maskImage(this.sourceImage);
    }

    public BufferedImage maskImage(BufferedImage source) {
        return MOps2D.maskImage(source, this.resultMask);
    }

    public double colorDifference(BufferedImage gradient) {
        return this.colorDifference(this.contourPoints, gradient);
    }

    public double colorDifference(BufferedImage source, BufferedImage target) {
        return this.colorDifference(this.contourPoints, source, target);
    }

    public double colorDifference(Vector<Point> boundary, BufferedImage source, BufferedImage target) {
        double k = 0.0;
        for (int i = 0; i < boundary.size(); ++i) {
            Point p = boundary.get(i);
            if (p.x < 0 || p.x >= target.getWidth() || p.y < 0 || p.y >= target.getHeight()) continue;
            k += Boundary.colorDistance(target.getRGB(p.x, p.y), source.getRGB(p.x, p.y));
        }
        return k /= (double)boundary.size();
    }

    public double colorDifference(Vector<Point> boundary, BufferedImage gradient) {
        double k = 0.0;
        for (int i = 0; i < boundary.size(); ++i) {
            Point p = boundary.get(i);
            if (p.x < 0 || p.x >= gradient.getWidth() || p.y < 0 || p.y >= gradient.getHeight()) continue;
            k += Boundary.colorToGray(gradient.getRGB(p.x, p.y));
        }
        return k /= (double)boundary.size();
    }

    public double colorDifference(Vector<Point> boundary, double ka, BufferedImage source, BufferedImage target) {
        double en = 0.0;
        for (int i = 0; i < boundary.size(); ++i) {
            Point p = boundary.get(i);
            if (p.x < 0 || p.x >= target.getWidth() || p.y < 0 || p.y >= target.getHeight()) continue;
            double d = Boundary.colorDistance(target.getRGB(p.x, p.y), source.getRGB(p.x, p.y)) - ka;
            en += d * d;
        }
        return en;
    }

    public double colorDifference(Vector<Point> boundary, double ka, BufferedImage gradient) {
        double en = 0.0;
        for (int i = 0; i < boundary.size(); ++i) {
            Point p = boundary.get(i);
            if (p.x < 0 || p.x >= gradient.getWidth() || p.y < 0 || p.y >= gradient.getHeight()) continue;
            double d = Boundary.colorToGray(gradient.getRGB(p.x, p.y)) - ka;
            en += d * d;
        }
        return en;
    }

    public double colorDifference(ValuePair bStart, double ka, BufferedImage source, BufferedImage target) {
        Point p = (Point)bStart.getObject();
        double d = 0.0;
        if (p.x >= 0 && p.x < target.getWidth() && p.y >= 0 && p.y < target.getHeight()) {
            d = Boundary.colorDistance(target.getRGB(p.x, p.y), source.getRGB(p.x, p.y)) - ka;
        }
        double en = d * d;
        while (bStart.pointer != null) {
            bStart = bStart.pointer;
            p = (Point)bStart.getObject();
            if (p.x < 0 || p.x >= target.getWidth() || p.y < 0 || p.y >= target.getHeight()) continue;
            d = Boundary.colorDistance(target.getRGB(p.x, p.y), source.getRGB(p.x, p.y)) - ka;
            en += d * d;
        }
        return en;
    }

    public double colorDifference(ValuePair bStart, double ka, BufferedImage gradient) {
        Point p = (Point)bStart.getObject();
        double d = 0.0;
        if (p.x >= 0 && p.x < gradient.getWidth() && p.y >= 0 && p.y < gradient.getHeight()) {
            d = Boundary.colorToGray(gradient.getRGB(p.x, p.y)) - ka;
        }
        double en = d * d;
        while (bStart.pointer != null) {
            bStart = bStart.pointer;
            p = (Point)bStart.getObject();
            if (p.x < 0 || p.x >= gradient.getWidth() || p.y < 0 || p.y >= gradient.getHeight()) continue;
            d = Boundary.colorToGray(gradient.getRGB(p.x, p.y)) - ka;
            en += d * d;
        }
        return en;
    }

    public double colorDifference(Point start, byte[][] pointers, double ka, BufferedImage source, BufferedImage target) {
        int i = start.x;
        int j = start.y;
        byte p = pointers[i][j];
        double d = 0.0;
        if (i >= 0 && i < target.getWidth() && j >= 0 && j < target.getHeight()) {
            d = Boundary.colorDistance(target.getRGB(i, j), source.getRGB(i, j)) - ka;
        }
        double en = d * d;
        while (p > 0) {
            switch (p) {
                case 1: {
                    --i;
                    break;
                }
                case 2: {
                    ++i;
                    break;
                }
                case 3: {
                    --j;
                    break;
                }
                case 4: {
                    ++j;
                    break;
                }
                case 5: {
                    --i;
                    --j;
                    break;
                }
                case 6: {
                    --i;
                    ++j;
                    break;
                }
                case 7: {
                    ++i;
                    --j;
                    break;
                }
                case 8: {
                    ++i;
                    ++j;
                }
            }
            if (i >= 0 && i < target.getWidth() && j >= 0 && j < target.getHeight()) {
                d = Boundary.colorDistance(target.getRGB(i, j), source.getRGB(i, j)) - ka;
            }
            en += d * d;
            p = pointers[i][j];
        }
        return en;
    }

    public double colorDifference(Point start, byte[][] pointers, double ka, BufferedImage gradient) {
        int i = start.x;
        int j = start.y;
        byte p = pointers[i][j];
        double d = 0.0;
        if (i >= 0 && i < gradient.getWidth() && j >= 0 && j < gradient.getHeight()) {
            d = Boundary.colorToGray(gradient.getRGB(i, j)) - ka;
        }
        double en = d * d;
        while (p > 0) {
            switch (p) {
                case 1: {
                    --i;
                    break;
                }
                case 2: {
                    ++i;
                    break;
                }
                case 3: {
                    --j;
                    break;
                }
                case 4: {
                    ++j;
                    break;
                }
                case 5: {
                    --i;
                    --j;
                    break;
                }
                case 6: {
                    --i;
                    ++j;
                    break;
                }
                case 7: {
                    ++i;
                    --j;
                    break;
                }
                case 8: {
                    ++i;
                    ++j;
                }
            }
            if (i >= 0 && i < gradient.getWidth() && j >= 0 && j < gradient.getHeight()) {
                d = Boundary.colorToGray(gradient.getRGB(i, j)) - ka;
            }
            en += d * d;
            p = pointers[i][j];
        }
        return en;
    }

    public static double colorDistance(int rgb1, int rgb2) {
        double r = (double)(rgb1 >> 16 & 0xFF) - (double)(rgb2 >> 16 & 0xFF);
        double g = (double)(rgb1 >> 8 & 0xFF) - (double)(rgb2 >> 8 & 0xFF);
        double b = (double)(rgb1 & 0xFF) - (double)(rgb2 & 0xFF);
        return Math.sqrt(r * r + g * g + b * b);
    }

    public static double colorToGray(int rgb) {
        double r = rgb >> 16 & 0xFF;
        double g = rgb >> 8 & 0xFF;
        double b = rgb & 0xFF;
        return (r + g + b) / 3.0;
    }

    public static double colorDistance(Point p, BufferedImage s, BufferedImage t) {
        int rgb1 = s.getRGB(p.x, p.y);
        int rgb2 = 0;
        if (p.x >= 0 && p.x < t.getWidth() && p.y >= 0 && p.y < t.getHeight()) {
            t.getRGB(p.x, p.y);
        }
        return Boundary.colorDistance(rgb1, rgb2);
    }

    public Vector<Point> optimizeBoundary(BufferedImage extContour, BufferedImage source, BufferedImage target) {
        int width = source.getWidth();
        int height = source.getHeight();
        if (width != target.getWidth() || height != target.getHeight()) {
            System.err.println("[WARNING] Boundary: Source and target differ in size " + width + "x" + height + ", " + target.getWidth() + "x" + target.getHeight());
        }
        Vector<Point> omega = MOps2D.listPointsNot(extContour, -16777216);
        if (this.canvas != null) {
            this.canvas.add(omega, -65536, (int)this.maskBB.getMinX(), (int)this.maskBB.getMinY());
        }
        MOps2D.floodfill4(extContour, -1, -1);
        MOps2D.not(extContour);
        BufferedImage extMask = MOps2D.colorMask(extContour, -1);
        BufferedImage binaryMask = MOps2D.plot(omega, this.mask.getWidth(), this.mask.getHeight());
        MOps2D.orImage(extMask, binaryMask, -1);
        this.debug(extMask, "opt01");
        BufferedImage diffOmega = MOps2D.difference(extMask, this.mask);
        MOps2D.or(diffOmega, binaryMask);
        this.debug(diffOmega, "opt02");
        BufferedImage diff = COps.difference(source, target);
        BufferedImage gmag = COps.gradientMagnitude(diff);
        this.debug(source, "diff01");
        this.debug(target, "diff02");
        this.debug(diff, "diff03");
        this.debug(gmag, "diff04");
        double ka = this.gradientDifference ? this.colorDifference(omega, gmag) : this.colorDifference(omega, source, target);
        double energy = this.gradientDifference ? this.colorDifference(omega, ka, gmag) : this.colorDifference(omega, ka, source, target);
        byte[][] pointers = new byte[width][height];
        double[][] costs = new double[width][height];
        boolean[][] inSet = new boolean[width][height];
        byte[] assignments = new byte[]{2, 1, 4, 3, 8, 7, 6, 5};
        int count = 0;
        while (!this.canvas.moved) {
            Vector[] cut = this.shortestCut(omega, this.contourPoints);
            this.updateGraphics(MOps2D.colorMask(diffOmega, 0x66FFFFFF), cut, omega);
            this.updateGraphics(this.contour);
            if (cut[0].size() < 1 || cut[1].size() < 1) break;
            TreeSet<ValuePair> ele = new TreeSet<ValuePair>();
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    pointers[i][j] = -1;
                    costs[i][j] = Double.MAX_VALUE;
                    inSet[i][j] = false;
                }
            }
            for (int m = 0; m < cut[0].size(); ++m) {
                Point p = (Point)cut[0].get(m);
                double cost = this.gradientDifference ? Boundary.colorToGray(gmag.getRGB(p.x, p.y)) : Boundary.colorDistance(p, source, target) - ka;
                cost *= cost;
                ValuePair vp = new ValuePair(m, cost);
                vp.setObject(p);
                ele.add(vp);
                pointers[p.x][p.y] = 0;
                inSet[p.x][p.y] = true;
            }
            while (!ele.isEmpty() && !this.canvas.moved) {
                ValuePair q = (ValuePair)ele.first();
                ele.remove(q);
                Point pq = (Point)q.getObject();
                costs[pq.x][pq.y] = q.value;
                inSet[pq.x][pq.y] = false;
                Point[] neighbors = this.getNeighbors8(pq, cut, diffOmega, pointers);
                for (int i = 0; i < neighbors.length; ++i) {
                    Point fp;
                    double geomDist;
                    Point pr = neighbors[i];
                    if (pr == null) continue;
                    boolean arrived = cut[1].contains(pr);
                    double cost = this.gradientDifference ? Boundary.colorToGray(gmag.getRGB(pr.x, pr.y)) : Boundary.colorDistance(pr, source, target) - ka;
                    cost *= cost;
                    cost += q.value;
                    if (arrived && (geomDist = (fp = this.getFirstPoint(pq, pointers)).distanceSq(pr)) > 2.0) {
                        cost = Double.MAX_VALUE;
                    }
                    ValuePair r = new ValuePair(cost, pr);
                    if (inSet[pr.x][pr.y] && cost < costs[pr.x][pr.y]) {
                        ValuePair rr = new ValuePair(costs[pr.x][pr.y], pr);
                        ele.remove(rr);
                        inSet[pr.x][pr.y] = false;
                    }
                    if (inSet[pr.x][pr.y]) continue;
                    r.pointer = q;
                    pointers[pr.x][pr.y] = assignments[i];
                    ele.add(r);
                    inSet[pr.x][pr.y] = true;
                }
            }
            if (this.canvas.moved) break;
            int ii = 0;
            double energia = Double.MAX_VALUE;
            Point start = null;
            Vector<Point> pointList = null;
            do {
                double enar;
                Point pp = (Point)cut[1].get(ii++);
                if (ii >= cut[1].size() && pointers[pp.x][pp.y] < 0) break;
                while (pointers[pp.x][pp.y] < 0) {
                    pp = (Point)cut[1].get(ii++);
                    if (ii < cut[1].size()) continue;
                }
                if (ii >= cut[1].size() && pointers[pp.x][pp.y] < 0) break;
                this.canvas.add(pp, -16733441, (int)this.maskBB.getMinX(), (int)this.maskBB.getMinY());
                Point firstPoint = this.getFirstPoint(pp, pointers);
                if (firstPoint.distanceSq(pp) > 2.0) continue;
                double d = enar = this.gradientDifference ? this.colorDifference(pp, pointers, ka, gmag) : this.colorDifference(pp, pointers, ka, source, target);
                if (!(enar < energia) || (pointList = this.getPointList(pp, pointers)).size() < 50) continue;
                this.canvas.add(pointList, -1996488705, (int)this.maskBB.getMinX(), (int)this.maskBB.getMinY());
                start = pp;
                energia = enar;
            } while (ii < cut[1].size());
            if ((omega = this.getPointList(start, pointers)).size() < 50) {
                System.out.println("[WARNING] Boundary: Path length = " + omega.size() + " ??!");
                break;
            }
            extContour = MOps2D.plot(omega, this.mask.getWidth(), this.mask.getHeight());
            BufferedImage ccaux = MOps2D.plot(omega, this.mask.getWidth(), this.mask.getHeight());
            MOps2D.floodfill4(ccaux, -1, -1);
            MOps2D.not(ccaux);
            MOps2D.or(ccaux, extContour);
            extMask = MOps2D.colorMask(ccaux, -1);
            extContour = MOps2D.gradient(ccaux);
            diffOmega = MOps2D.difference(extMask, this.mask);
            MOps2D.or(diffOmega, MOps2D.plot(omega, this.mask.getWidth(), this.mask.getHeight()));
            omega = MOps2D.listPoints(extContour);
            ka = this.gradientDifference ? this.colorDifference(omega, gmag) : this.colorDifference(omega, source, target);
            double oldEnergy = energy;
            double d = energy = this.gradientDifference ? this.colorDifference(omega, ka, gmag) : this.colorDifference(omega, ka, source, target);
            count = oldEnergy - energy <= 0.0 || oldEnergy / energy < 1.05 ? ++count : 0;
            if (count < 2) continue;
        }
        this.resultMask = extMask;
        this.updateGraphics(MOps2D.colorMask(diffOmega, 0x66FFFFFF), null, omega);
        this.updateGraphics(this.contour);
        return omega;
    }

    Point getFirstPoint(Point start, byte[][] pointers) {
        int i = start.x;
        int j = start.y;
        byte p = pointers[i][j];
        int length = 0;
        while (p > 0) {
            ++length;
            switch (p) {
                case 1: {
                    --i;
                    break;
                }
                case 2: {
                    ++i;
                    break;
                }
                case 3: {
                    --j;
                    break;
                }
                case 4: {
                    ++j;
                    break;
                }
                case 5: {
                    --i;
                    --j;
                    break;
                }
                case 6: {
                    --i;
                    ++j;
                    break;
                }
                case 7: {
                    ++i;
                    --j;
                    break;
                }
                case 8: {
                    ++i;
                    ++j;
                }
            }
            p = pointers[i][j];
        }
        return new Point(i, j);
    }

    boolean isLongPath(Point start, byte[][] pointers) {
        int i = start.x;
        int j = start.y;
        byte p = pointers[i][j];
        int l = 1;
        while (p > 0) {
            if (++l >= 50) {
                return true;
            }
            switch (p) {
                case 1: {
                    --i;
                    break;
                }
                case 2: {
                    ++i;
                    break;
                }
                case 3: {
                    --j;
                    break;
                }
                case 4: {
                    ++j;
                    break;
                }
                case 5: {
                    --i;
                    --j;
                    break;
                }
                case 6: {
                    --i;
                    ++j;
                    break;
                }
                case 7: {
                    ++i;
                    --j;
                    break;
                }
                case 8: {
                    ++i;
                    ++j;
                }
            }
            p = pointers[i][j];
        }
        return false;
    }

    Vector<Point> getPointList(Point start, byte[][] pointers) {
        Vector<Point> v = new Vector<Point>();
        if (start == null) {
            return v;
        }
        v.add(start);
        int i = start.x;
        int j = start.y;
        byte p = pointers[i][j];
        while (p > 0) {
            switch (p) {
                case 1: {
                    --i;
                    break;
                }
                case 2: {
                    ++i;
                    break;
                }
                case 3: {
                    --j;
                    break;
                }
                case 4: {
                    ++j;
                    break;
                }
                case 5: {
                    --i;
                    --j;
                    break;
                }
                case 6: {
                    --i;
                    ++j;
                    break;
                }
                case 7: {
                    ++i;
                    --j;
                    break;
                }
                case 8: {
                    ++i;
                    ++j;
                }
            }
            p = pointers[i][j];
            v.add(new Point(i, j));
        }
        return v;
    }

    Point[] getNeighbors8(Point p, Vector[] cut, BufferedImage band, byte[][] pointers) {
        int w = band.getWidth();
        int h = band.getHeight();
        Point[] nn = new Point[]{new Point(p.x - 1, p.y), new Point(p.x + 1, p.y), new Point(p.x, p.y - 1), new Point(p.x, p.y + 1), new Point(p.x - 1, p.y - 1), new Point(p.x - 1, p.y + 1), new Point(p.x + 1, p.y - 1), new Point(p.x + 1, p.y + 1)};
        Point[] ref = new Point[nn.length];
        for (int i = 0; i < nn.length; ++i) {
            ref[i] = nn[i];
        }
        boolean inYellow = cut[0].contains(p);
        for (int i = 0; i < nn.length; ++i) {
            inYellow = inYellow || cut[0].contains(nn[i]);
        }
        boolean twist = false;
        boolean visited = false;
        for (int i = 0; i < nn.length; ++i) {
            Point p0 = nn[i];
            boolean bl = twist = cut[1].contains(p0) && !this.isLongPath(p, pointers);
            if (p0.x >= 0 && p0.x < w && p0.y >= 0 && p0.y < h) {
                boolean bl2 = visited = pointers[p0.x][p0.y] >= 0;
                if (band.getRGB(p0.x, p0.y) != -16777216 && !twist && !visited) continue;
                nn[i] = null;
                continue;
            }
            nn[i] = null;
        }
        return nn;
    }

    Point[] getNeighbors4(Point p, Vector<?> destinationCut) {
        int w = this.targetImage.getWidth();
        int h = this.targetImage.getHeight();
        Point[] nn = new Point[]{new Point(p.x - 1, p.y), new Point(p.x + 1, p.y), new Point(p.x, p.y - 1), new Point(p.x, p.y + 1)};
        for (int i = 0; i < nn.length; ++i) {
            Point p0 = nn[i];
            if (!destinationCut.contains(p0)) {
                nn[i] = null;
            }
            if (p0 == null || p0.x >= 0 && p0.x < w && p0.y >= 0 && p0.y < h) continue;
            nn[i] = null;
        }
        return nn;
    }

    Vector<Point>[] shortestCut(Vector<Point> outside, Vector<Point> inside) {
        int yb;
        int yb2;
        boolean steep;
        int j;
        Vector[] vectors;
        int w = (int)this.maskBB.getWidth();
        int h = (int)this.maskBB.getHeight();
        Vector[] cut = vectors = new Vector[]{new Vector(), new Vector()};
        if (outside.size() < 1 || inside.size() < 1) {
            return cut;
        }
        Point mina = outside.get(0);
        Point minb = inside.get(0);
        double distance = mina.distanceSq(minb);
        for (int i = 0; i < outside.size(); ++i) {
            Point a = outside.get(i);
            for (j = 0; j < inside.size(); ++j) {
                Point b = inside.get(j);
                double d = a.distanceSq(b);
                if (!(d < distance)) continue;
                mina = a;
                minb = b;
                distance = d;
            }
        }
        if (mina.equals(minb)) {
            cut[0].add(mina);
            Point p = mina;
            Point[] nn = new Point[]{new Point(p.x - 1, p.y), new Point(p.x + 1, p.y), new Point(p.x, p.y - 1), new Point(p.x, p.y + 1), new Point(p.x - 1, p.y - 1), new Point(p.x - 1, p.y + 1), new Point(p.x + 1, p.y - 1), new Point(p.x + 1, p.y + 1)};
            for (j = 0; j < nn.length; ++j) {
                Point pp = nn[j];
                if (pp.x >= w || pp.y >= h || pp.x < 0 || pp.y < 0) continue;
                cut[1].add(pp);
            }
            for (j = 0; j < nn.length; ++j) {
                Point p0 = nn[j];
                if (!outside.contains(p0)) continue;
                cut[1].remove(p0);
                break;
            }
            return cut;
        }
        int x0 = mina.x;
        int y0 = mina.y;
        int x1 = minb.x;
        int y1 = minb.y;
        boolean bl = steep = Math.abs(y1 - y0) > Math.abs(x1 - x0);
        if (steep) {
            x0 = mina.y;
            y0 = mina.x;
            x1 = minb.y;
            y1 = minb.x;
        }
        if (x0 > x1) {
            int swap = x0;
            x0 = x1;
            x1 = swap;
            swap = y0;
            y0 = y1;
            y1 = swap;
        }
        int deltax = x1 - x0;
        int deltay = Math.abs(y1 - y0);
        int error = 0;
        int ystep = 0;
        int y = y0;
        ystep = y0 < y1 ? 1 : -1;
        int x = x0;
        if (steep) {
            if (x0 - 1 >= 0) {
                if (y0 < w) {
                    cut[1].add(new Point(y0, x0 - 1));
                }
                if ((yb2 = y0 - ystep) < w && yb2 >= 0) {
                    cut[1].add(new Point(yb2, x0 - 1));
                }
            }
        } else if (x0 - 1 >= 0) {
            if (y0 < h) {
                cut[1].add(new Point(x0 - 1, y0));
            }
            if ((yb2 = y0 - ystep) < h && yb2 >= 0) {
                cut[1].add(new Point(x0 - 1, yb2));
            }
        }
        boolean displaced = false;
        for (x = x0; x <= x1; ++x) {
            if (steep) {
                if (y < w && x < h && x >= 0 && y >= 0) {
                    cut[0].add(new Point(y, x));
                    yb = y - ystep;
                    if (yb < w && yb >= 0) {
                        cut[1].add(new Point(yb, x));
                        if (displaced && (yb -= ystep) < w && yb >= 0) {
                            cut[1].add(new Point(yb, x));
                        }
                    }
                }
            } else if (x < w && y < h && x >= 0 && y >= 0) {
                cut[0].add(new Point(x, y));
                yb = y - ystep;
                if (yb < h && yb >= 0) {
                    cut[1].add(new Point(x, yb));
                    if (displaced && (yb -= ystep) < h && yb >= 0) {
                        cut[1].add(new Point(x, yb));
                    }
                }
            }
            if ((error += deltay) << 1 >= deltax) {
                displaced = true;
                y += ystep;
                error -= deltax;
                continue;
            }
            displaced = false;
        }
        if (steep) {
            if (x < h && y >= 0) {
                yb = y - ystep;
                if (yb < w && yb >= 0) {
                    cut[1].add(new Point(yb, x));
                }
                if ((yb -= ystep) < w && yb >= 0) {
                    cut[1].add(new Point(yb, x));
                }
            }
        } else if (x < w && y >= 0) {
            yb = y - ystep;
            if (yb < h && yb >= 0) {
                cut[1].add(new Point(x, yb));
            }
            if ((yb -= ystep) < h && yb >= 0) {
                cut[1].add(new Point(x, yb));
            }
        }
        return cut;
    }

    private void updateGraphics(BufferedImage band, Vector[] cut, Vector<Point> list) {
        this.canvas.clearLines();
        if (this.canvas != null) {
            if (band != null) {
                this.canvas.addL(band, (int)this.maskBB.getMinX(), (int)this.maskBB.getMinY());
            }
            if (list != null) {
                this.canvas.add(list, -65536, (int)this.maskBB.getMinX(), (int)this.maskBB.getMinY());
            }
            if (cut != null) {
                this.canvas.add(cut[0], -256, (int)this.maskBB.getMinX(), (int)this.maskBB.getMinY());
                this.canvas.add(cut[1], -16711681, (int)this.maskBB.getMinX(), (int)this.maskBB.getMinY());
            }
        }
    }

    private void updateGraphics(BufferedImage border) {
        if (this.canvas != null) {
            this.canvas.addL(border, (int)this.maskBB.getMinX(), (int)this.maskBB.getMinY());
        }
    }

    public void setPoissonType(int type) {
        this.poissonType = type;
    }

    public void setPoissonParameters(double sGradient, double poissonAccuracy) {
        this.sGradient = sGradient;
        this.poissonAccuracy = poissonAccuracy;
    }

    void debug(BufferedImage bim) {
        if (this.debugCanvas != null) {
            this.debugCanvas.set(bim);
        }
    }

    BufferedImage createClipped(BufferedImage source) {
        return this.createClipped(source, 2);
    }

    BufferedImage createClipped(BufferedImage source, int type) {
        return this.createClipped(source, type, (int)this.maskBB.getWidth(), (int)this.maskBB.getHeight(), (int)(-this.maskBB.getMinX()), (int)(-this.maskBB.getMinY()));
    }

    BufferedImage createClipped(BufferedImage source, int type, int width, int height, int xoff, int yoff) {
        BufferedImage clipped = new BufferedImage(width, height, type);
        Graphics gi = clipped.getGraphics();
        gi.drawImage(source, xoff, yoff, null);
        gi.dispose();
        return clipped;
    }

    @Override
    public void run() {
        try {
            while (this.sourceImage == null || this.targetImage == null || this.canvas == null) {
                Thread.sleep(500L);
            }
            this.sourceImage = this.canvas.getImage();
            Point targetOffset = this.compositeCanvas.getOffset();
            BufferedImage clippedSource = this.sourceImage;
            BufferedImage clippedTarget = this.targetImage;
            if (this.roughSegmentation != null) {
                this.setSegmentedThreaded();
            }
            this.canvas.clearLines();
            switch (this.method) {
                case 0: {
                    this.updateGraphics(this.contour);
                    clippedSource = this.createClipped(this.sourceImage);
                    clippedTarget = this.createClipped(this.targetImage, 2, (int)this.maskBB.getWidth(), (int)this.maskBB.getHeight(), -targetOffset.x, -targetOffset.y);
                    break;
                }
                case 1: {
                    this.updateGraphics(this.contour);
                    clippedSource = this.createClipped(this.sourceImage);
                    clippedTarget = this.createClipped(this.targetImage, 2, (int)this.maskBB.getWidth(), (int)this.maskBB.getHeight(), -targetOffset.x, -targetOffset.y);
                    break;
                }
                case 2: {
                    this.updateGraphics(this.contour);
                }
                case 3: {
                    if (this.externalContour == null) break;
                    clippedSource = this.createClipped(this.sourceImage);
                    clippedTarget = this.createClipped(this.targetImage, 2, (int)this.maskBB.getWidth(), (int)this.maskBB.getHeight(), -targetOffset.x, -targetOffset.y);
                    this.optimizeBoundary(this.externalContour, clippedSource, clippedTarget);
                }
            }
            BufferedImage alphaMask = new BufferedImage(this.resultMask.getWidth() + 100, this.resultMask.getHeight() + 100, 10);
            Graphics gi = alphaMask.getGraphics();
            gi.drawImage(this.resultMask, 50, 50, null);
            gi.dispose();
            if (this.alphaMatting) {
                ConvolveOp convolve = new ConvolveOp(KERNEL);
                alphaMask = convolve.filter(alphaMask, null);
            }
            alphaMask = alphaMask.getSubimage(50, 50, this.resultMask.getWidth(), this.resultMask.getHeight());
            clippedTarget = this.createClipped(this.targetImage, 2, (int)this.maskBB.getWidth(), (int)this.maskBB.getHeight(), -targetOffset.x, -targetOffset.y);
            clippedSource = this.createClipped(this.sourceImage);
            MOps2D.alphaMask(clippedSource, alphaMask);
            this.compositeCanvas.updateObject(clippedSource);
            if (this.poissonType > 0 && !this.canvas.moved) {
                BufferedImage binaryMask = MOps2D.bw2binary(this.resultMask);
                this.debug(clippedSource, "poisson01");
                this.debug(clippedTarget, "poisson02");
                this.debug(binaryMask, "poisson03");
                Poisson poisson = new Poisson(clippedSource, clippedTarget, binaryMask);
                poisson.setComposite(this.compositeCanvas);
                poisson.setMethod(this.poissonType);
                poisson.accuracy = this.poissonAccuracy;
                poisson.setMixture(this.sGradient);
                BufferedImage result = poisson.optimize();
                BufferedImage maskNoContour = MOps2D.colorMask(MOps2D.erode(binaryMask), -1);
                this.compositeCanvas.updateObject(MOps2D.maskImage(result, maskNoContour));
            }
        }
        catch (Exception exc) {
            System.err.println("Boundary thread: " + exc);
        }
    }
}

