/*
 * Decompiled with CFR 0.152.
 */
package titech.image.matting;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import titech.image.dsp.MOps2D;
import titech.wt.CompositeCanvas;

public class Poisson
extends Thread {
    public static final int GRADIENT_IMPORT = 1;
    public static final int GRADIENT_MIX = 2;
    public static final int WEIGHTED_GRADIENT = 3;
    public static final int ALPHA_MATTE = 4;
    private Thread[] fils;
    BufferedImage source;
    BufferedImage target;
    BufferedImage result;
    double[] alpha = null;
    byte[][] domain;
    int width;
    int height;
    BufferedImage omega;
    private int method;
    private int area;
    public double sourceWeight;
    public double targetWeight;
    public double accuracy;
    CompositeCanvas compositeCanvas = null;

    public void setComposite(CompositeCanvas canvas) {
        this.compositeCanvas = canvas;
    }

    public Poisson(BufferedImage source, BufferedImage target, BufferedImage omega) {
        this.target = target;
        this.sourceWeight = 0.5;
        this.targetWeight = 0.5;
        this.accuracy = 0.05;
        this.width = target.getWidth();
        this.height = target.getHeight();
        if (source.getWidth() != this.width || source.getHeight() != this.height || omega.getWidth() != this.width || omega.getHeight() != this.height) {
            System.err.println("[WARNING] Poisson: image sizes differ!");
        }
        this.result = new BufferedImage(this.width, this.height, 2);
        Graphics gi = this.result.getGraphics();
        gi.drawImage(target, 0, 0, null);
        gi.dispose();
        this.source = source;
        this.omega = omega;
        this.compositeCanvas = null;
        this.method = 1;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public void setMixture(double sGradient) {
        this.sourceWeight = sGradient;
        this.targetWeight = sGradient >= 1.0 ? 0.0 : 1.0 - sGradient;
    }

    public BufferedImage optimize() {
        this.domain = MOps2D.getGradient(this.omega);
        this.area = 0;
        for (int j = 0; j < this.omega.getHeight(); ++j) {
            for (int i = 0; i < this.omega.getWidth(); ++i) {
                if (this.domain[i][j] != 1) continue;
                ++this.area;
            }
        }
        this.fils = new Thread[3];
        try {
            int c;
            for (c = 0; c < this.fils.length; ++c) {
                this.fils[c] = new Thread((Runnable)this, "" + c);
                this.fils[c].start();
            }
            for (c = 0; c < this.fils.length; ++c) {
                this.fils[c].join();
            }
        }
        catch (InterruptedException exc) {
            System.err.println("[POISSON] " + exc);
        }
        return this.result;
    }

    public BufferedImage optimizeAlpha() {
        return this.result;
    }

    private void getNeighbors(int x, int y, byte[] nn) {
        nn[0] = y < 1 ? -1 : this.domain[x][y - 1];
        nn[1] = x < 1 ? -1 : this.domain[x - 1][y];
        nn[2] = x + 1 >= this.width ? -1 : this.domain[x + 1][y];
        nn[3] = y + 1 >= this.height ? -1 : this.domain[x][y + 1];
    }

    private void getDifference(int band, double[] d) {
        double[] g = new double[this.width * this.height];
        double[] t = null;
        this.source.getData().getSamples(0, 0, this.width, this.height, band, d);
        this.source.getData().getSamples(0, 0, this.width, this.height, band, g);
        switch (this.method) {
            case 4: {
                if (this.alpha == null) {
                    this.alpha = new double[this.width * this.height];
                    this.result.getAlphaRaster().getSamples(0, 0, this.width, this.height, band, this.alpha);
                }
            }
            case 2: 
            case 3: {
                t = new double[this.width * this.height];
                this.target.getData().getSamples(0, 0, this.width, this.height, band, t);
            }
        }
        byte[] np = new byte[4];
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                int p = i + j * this.width;
                this.getNeighbors(i, j, np);
                int[] nn = new int[]{i + (j - 1) * this.width, i - 1 + j * this.width, i + 1 + j * this.width, i + (j + 1) * this.width};
                d[p] = 0.0;
                block12: for (int k = 0; k < 4; ++k) {
                    if (np[k] < 0) continue;
                    int q = nn[k];
                    switch (this.method) {
                        case 1: {
                            int n = p;
                            d[n] = d[n] + (g[p] - g[q]);
                            continue block12;
                        }
                        case 2: {
                            double tt = t[p] - t[q];
                            double gg = g[p] - g[q];
                            if (Math.abs(tt) > Math.abs(gg)) {
                                int n = p;
                                d[n] = d[n] + tt;
                                continue block12;
                            }
                            int n = p;
                            d[n] = d[n] + gg;
                            continue block12;
                        }
                        case 3: {
                            double tt = t[p] - t[q];
                            double gg = g[p] - g[q];
                            int n = p;
                            d[n] = d[n] + (this.sourceWeight * gg + this.targetWeight * tt);
                            continue block12;
                        }
                        case 4: {
                            double ap = this.alpha[p] / 255.0;
                            double aq = this.alpha[q] / 255.0;
                            if (ap < 1.0 && aq < 1.0) {
                                int n = p;
                                d[n] = d[n] + (ap * g[q] - aq * g[q] + (1.0 - ap) * t[p] - (1.0 - aq) * t[q]);
                                continue block12;
                            }
                            int n = p;
                            d[n] = d[n] + (g[p] - g[q]);
                            continue block12;
                        }
                        default: {
                            int n = p;
                            d[n] = d[n] + (g[p] - g[q]);
                        }
                    }
                }
            }
        }
    }

    public void run() {
        int c = Integer.parseInt(Thread.currentThread().getName());
        double[] t = new double[this.width * this.height];
        double[] f0 = new double[this.width * this.height];
        double[] f1 = new double[this.width * this.height];
        double[] d = new double[this.width * this.height];
        for (int p = 0; p < f1.length; ++p) {
            f1[p] = 0.0;
        }
        this.result.getData().getSamples(0, 0, this.width, this.height, c, f0);
        this.result.getData().getSamples(0, 0, this.width, this.height, c, t);
        this.getDifference(c, d);
        double change = Double.MAX_VALUE;
        byte[] np = new byte[4];
        while (change > this.accuracy) {
            change = 0.0;
            int[] nn = new int[4];
            for (int j = 0; j < this.height; ++j) {
                for (int i = 0; i < this.width; ++i) {
                    if (this.domain[i][j] != 1) continue;
                    int p = i + j * this.width;
                    nn[0] = i + (j - 1) * this.width;
                    nn[1] = i - 1 + j * this.width;
                    nn[2] = i + 1 + j * this.width;
                    nn[3] = i + (j + 1) * this.width;
                    this.getNeighbors(i, j, np);
                    f1[p] = d[p];
                    int n = 0;
                    for (int k = 0; k < 4; ++k) {
                        if (np[k] == 0) {
                            int n2 = p;
                            f1[n2] = f1[n2] + t[nn[k]];
                        }
                        if (np[k] < 0) continue;
                        ++n;
                    }
                    if (np[0] == 1) {
                        int n3 = p;
                        f1[n3] = f1[n3] + f1[nn[0]];
                    }
                    if (np[1] == 1) {
                        int n4 = p;
                        f1[n4] = f1[n4] + f1[nn[1]];
                    }
                    if (np[2] == 1) {
                        int n5 = p;
                        f1[n5] = f1[n5] + f0[nn[2]];
                    }
                    if (np[3] == 1) {
                        int n6 = p;
                        f1[n6] = f1[n6] + f0[nn[3]];
                    }
                    int n7 = p;
                    f1[n7] = f1[n7] / (double)n;
                    if (f1[p] > 255.0) {
                        f1[p] = 255.0;
                    }
                    if (f1[p] < 0.0) {
                        f1[p] = 0.0;
                    }
                    change += f1[p] - f0[p];
                }
            }
            for (int p = 0; p < f1.length; ++p) {
                f0[p] = f1[p];
            }
            change /= (double)this.area;
            change = Math.abs(change);
        }
        this.result.getRaster().setSamples(0, 0, this.width, this.height, c, f1);
    }
}

