/*
 * Decompiled with CFR 0.152.
 */
package titech.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import titech.file.FileUtils;
import titech.file.ImageFileFilter;
import titech.image.dsp.ObjectImage;
import titech.image.dsp.Segmenter;
import titech.image.math.AMath;

public class Utilities {
    private static final Component sComponent = new Component(){
        private static final long serialVersionUID = 1L;
    };
    private static final MediaTracker sTracker = new MediaTracker(sComponent);
    private static int sID = 0;
    public static float[] D65XYZ = new float[]{0.950166f, 1.0f, 1.087654f};
    public static final String jpeg = "jpeg";
    public static final String jpg = "jpg";
    public static final String gif = "gif";
    public static final String tiff = "tiff";
    public static final String tif = "tif";
    public static final String png = "png";

    public static String getExtension(File f) {
        return Utilities.getExtension(f.getName());
    }

    public static String getExtension(String s) {
        String ext = null;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String clearExtension(String s) {
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            return s.substring(0, i);
        }
        return s;
    }

    public static boolean indexDir(String currentPath) throws IOException {
        File pdir;
        File indexFile = new File(currentPath + File.separator + ".blobs");
        File histogramFile = new File(currentPath + File.separator + ".histogram");
        if (indexFile.exists() && histogramFile.exists()) {
            return false;
        }
        ImageFileFilter filter = new ImageFileFilter();
        filter.addExtension(jpg);
        filter.addExtension(png);
        filter.addExtension(jpeg);
        filter.addExtension("bmp");
        filter.addExtension(tiff);
        File[] fileList = FileUtils.ls(currentPath, filter);
        if (!indexFile.exists()) {
            indexFile.createNewFile();
        }
        PrintWriter iWriter = new PrintWriter(new FileOutputStream(indexFile));
        if (!histogramFile.exists()) {
            histogramFile.createNewFile();
        }
        PrintWriter ihWriter = new PrintWriter(new FileOutputStream(histogramFile));
        File bdir = new File(currentPath + File.separator + ".bthumbs");
        if (bdir.mkdir()) {
            System.out.println("Directory " + currentPath + File.separator + ".bthumbs" + " created.\n");
        }
        if ((pdir = new File(currentPath + File.separator + "thumbs")).mkdir()) {
            System.out.println("Directory " + currentPath + File.separator + "thumbs" + " created.\n");
        }
        long totalTime = 0L;
        Segmenter segmenter = new Segmenter();
        for (int i = 0; i < fileList.length; ++i) {
            File f = fileList[i];
            BufferedImage img = Utilities.loadImage(f.getAbsolutePath());
            long time = System.currentTimeMillis();
            System.out.println("indexing... " + (i + 1) + "/" + fileList.length);
            ObjectImage objectImage = segmenter.getKMedianRegions(img);
            totalTime += System.currentTimeMillis() - time;
            String descriptor = objectImage.getDescriptor();
            iWriter.println(descriptor);
            iWriter.flush();
            double[] rh = objectImage.getHistogram();
            descriptor = AMath.showVector(rh);
            ihWriter.println(descriptor);
            ihWriter.flush();
            Utilities.saveImage(segmenter.getSegmentedImage(), png, currentPath + File.separator + ".bthumbs" + File.separator + FileUtils.nameWOExtension(f.getName()) + ".png");
            Utilities.saveImage(segmenter.getQuantizedImage(), png, currentPath + File.separator + ".bthumbs" + File.separator + FileUtils.nameWOExtension(f.getName()) + "-ccat.png");
        }
        double t = (double)totalTime / 1000.0;
        iWriter.close();
        System.out.println("Computed index for " + fileList.length + " images in " + t + " secs.\n");
        System.out.println("Index saved in " + indexFile.getAbsolutePath());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForImage(Image image) {
        int id;
        Component component = sComponent;
        synchronized (component) {
            id = sID++;
        }
        sTracker.addImage(image, id);
        try {
            sTracker.waitForID(id);
        }
        catch (InterruptedException ie) {
            return false;
        }
        return !sTracker.isErrorID(id);
    }

    public static Image blockingLoad(String path) {
        Image image = Toolkit.getDefaultToolkit().getImage(path);
        if (!Utilities.waitForImage(image)) {
            return null;
        }
        return image;
    }

    public static BufferedImage loadImage(File f) throws IOException {
        return ImageIO.read(f);
    }

    public static BufferedImage loadImage(String filepath) throws IOException {
        return Utilities.loadImage(new File(filepath));
    }

    public static BufferedImage loadIndexedImage(String filepath) throws Exception {
        return Utilities.loadIndexedImage(new File(filepath));
    }

    public static BufferedImage loadIndexedImage(File f) throws Exception {
        Iterator<ImageReader> itimr = ImageIO.getImageReadersBySuffix(png);
        BufferedImage out = null;
        if (itimr.hasNext()) {
            ImageReader imr = itimr.next();
            imr.setInput(new FileImageInputStream(f));
            ImageReadParam param = imr.getDefaultReadParam();
            param.setDestinationType(imr.getRawImageType(0));
            out = imr.read(0, param);
            System.out.println(out.getColorModel());
        } else {
            System.err.println("Utilities: Can't read PNG files!");
        }
        return out;
    }

    public static void saveImage(BufferedImage img, String format, File f) throws IOException {
        ImageIO.write((RenderedImage)img, format, f);
    }

    public static void saveImage(BufferedImage img, String format, String path) throws IOException {
        ImageIO.write((RenderedImage)img, format, new File(path));
    }

    public static Image blockingLoad(URL url) {
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        if (!Utilities.waitForImage(image)) {
            return null;
        }
        return image;
    }

    public static BufferedImage makeBufferedImage(Image image) {
        return Utilities.makeBufferedImage(image, 1);
    }

    public static BufferedImage makeBufferedImage(Image image, int imageType) {
        if (!Utilities.waitForImage(image)) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), imageType);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, null, null);
        return bufferedImage;
    }

    public static BufferedImage maskIndexedImage(BufferedImage image, int index, BufferedImage original) {
        return Utilities.maskIndexedImage(image, index, original, true, true);
    }

    public static BufferedImage maskIndexedImage(BufferedImage image, int index, BufferedImage original, boolean togray, boolean rescale) {
        int transparent = 0;
        int noalpha = -16777216;
        Raster rasta = image.getData();
        int minx = rasta.getMinX();
        int miny = rasta.getMinY();
        int width = rasta.getWidth();
        int height = rasta.getHeight();
        BufferedImage source = image;
        if (original != null) {
            source = original;
            if ((original.getWidth() != image.getWidth() || original.getHeight() != image.getHeight()) && rescale) {
                source = Utilities.resize(original, image.getWidth(), image.getHeight());
            }
        }
        BufferedImage out = new BufferedImage(source.getWidth(), source.getHeight(), 2);
        int x = 0;
        int y = 0;
        double scalex = (double)width / (double)source.getWidth();
        double scaley = (double)height / (double)source.getHeight();
        for (y = 0; y < source.getHeight(); ++y) {
            for (x = 0; x < source.getWidth(); ++x) {
                int i = minx + (int)((double)x * scalex);
                int j = miny + (int)((double)y * scaley);
                int pixel = rasta.getSample(i, j, 0);
                if (pixel == index) {
                    out.setRGB(x, y, source.getRGB(x, y));
                    continue;
                }
                if (togray) {
                    out.setRGB(x, y, noalpha | Utilities.toGray(source.getRGB(x, y)));
                    continue;
                }
                out.setRGB(x, y, transparent);
            }
        }
        return out;
    }

    public static BufferedImage maskIndexedImage(BufferedImage image, int index) {
        return Utilities.maskIndexedImage(image, index, null);
    }

    public static BufferedImage resize(BufferedImage image, int newSize) {
        double w = image.getWidth();
        double h = image.getHeight();
        double scale = 1.0;
        int newWidth = newSize;
        int newHeight = newSize;
        if (w < h) {
            scale = (double)newWidth / w;
            newHeight = (int)(h * scale);
        } else {
            scale = (double)newHeight / h;
            newWidth = (int)(w * scale);
        }
        BufferedImage result = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g = result.createGraphics();
        AffineTransform xform = AffineTransform.getScaleInstance(scale, scale);
        g.drawRenderedImage(image, xform);
        g.dispose();
        return result;
    }

    public static Dimension resizeDimension(BufferedImage image, int newSize) {
        double w = image.getWidth();
        double h = image.getHeight();
        double scale = 1.0;
        int newWidth = newSize;
        int newHeight = newSize;
        if (w < h) {
            scale = (double)newWidth / w;
            newHeight = (int)(h * scale);
        } else {
            scale = (double)newHeight / h;
            newWidth = (int)(w * scale);
        }
        return new Dimension(newWidth, newHeight);
    }

    public static BufferedImage resize(BufferedImage image, int newWidth, int newHeight) {
        BufferedImage result = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g = result.createGraphics();
        double scaleX = (double)newWidth / (double)image.getWidth();
        double scaleY = (double)newHeight / (double)image.getHeight();
        AffineTransform xform = AffineTransform.getScaleInstance(scaleX, scaleY);
        g.drawRenderedImage(image, xform);
        g.dispose();
        return result;
    }

    public static void colorToGray(BufferedImage image) {
        int noalpha = -16777216;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = image.getRGB(x, y);
                image.setRGB(x, y, noalpha | Utilities.toGray(pixel));
            }
        }
    }

    public static Kernel gaussian2Dkernel(float sigma) {
        int ksize = (int)(Math.ceil(sigma * 3.0f) * 2.0 + 1.0);
        return Utilities.gaussian2Dkernel(ksize, sigma);
    }

    public static Kernel gaussian2Dkernel(int size, float s) {
        if (size < 3) {
            return null;
        }
        if (size % 2 == 0) {
            return null;
        }
        int half = size >> 1;
        double[] kernel = new double[size * size];
        for (int i = -half; i <= half; ++i) {
            for (int j = -half; j <= half; ++j) {
                kernel[i + half + (j + half) * size] = Utilities.gaussPI(i, j, s);
            }
        }
        AMath.multV(kernel, 1.0 / AMath.sum(kernel));
        return new Kernel(size, size, AMath.toFloat(kernel));
    }

    public static double gaussPI(double x, double y, double s) {
        return Math.exp(-(x * x + y * y) / (2.0 * s * s));
    }

    public static int toGray(int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        int gray = (r + g + b) / 3;
        return gray << 16 | gray << 8 | gray;
    }

    public static float[] sRGBtoRGB(float[] srgb) {
        float[] rgb = new float[]{(double)srgb[0] > 0.04045 ? (float)Math.pow(((double)srgb[0] + 0.055) / 1.055, 2.4) : (float)((double)srgb[0] / 12.92), (double)srgb[1] > 0.04045 ? (float)Math.pow(((double)srgb[1] + 0.055) / 1.055, 2.4) : (float)((double)srgb[1] / 12.92), (double)srgb[2] > 0.04045 ? (float)Math.pow(((double)srgb[2] + 0.055) / 1.055, 2.4) : (float)((double)srgb[2] / 12.92)};
        return rgb;
    }

    public static float[] XYZtoLab(float[] xyz) {
        xyz[0] = xyz[0] / D65XYZ[0];
        xyz[1] = xyz[1] / D65XYZ[1];
        xyz[2] = xyz[2] / D65XYZ[2];
        float e = 0.008856452f;
        float k = 903.2963f;
        for (int i = 0; i < 3; ++i) {
            xyz[i] = xyz[i] > e ? (float)Math.pow(xyz[i], 0.3333333333333333) : (float)(((double)(k * xyz[i]) + 16.0) / 116.0);
        }
        float[] Lab = new float[]{116.0f * xyz[1] - 16.0f, 500.0f * (xyz[0] - xyz[1]), 200.0f * (xyz[1] - xyz[2])};
        return Lab;
    }

    public static float[] RGBtoXYZ(float[] rgb) {
        float[][] M = new float[][]{{0.412424f, 0.357579f, 0.180464f}, {0.212656f, 0.715158f, 0.0721856f}, {0.0193324f, 0.119193f, 0.950444f}};
        return AMath.fmultV(rgb, M);
    }

    public static float[] sRGBtoLab(float[] srgb) {
        return Utilities.XYZtoLab(Utilities.RGBtoXYZ(Utilities.sRGBtoRGB(srgb)));
    }

    public static float[] sRGBtoLab(int rgb) {
        float[] srgb = new float[]{(float)((rgb & 0xFF0000) >> 16) / 255.0f, (float)((rgb & 0xFF00) >> 8) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
        return Utilities.XYZtoLab(Utilities.RGBtoXYZ(Utilities.sRGBtoRGB(srgb)));
    }

    public static float[] LabtosRGB(float[] lab) {
        return Utilities.RGBtosRGB(Utilities.XYZtoRGB(Utilities.LabtoXYZ(lab)));
    }

    public static float[] LabtoXYZ(float[] lab) {
        float e = 0.008856452f;
        float k = 903.2963f;
        float[] xyz = new float[]{0.0f, 0.0f, 0.0f};
        xyz[1] = (float)(lab[0] > k * e ? Math.pow((lab[0] + 16.0f) / 116.0f, 3.0) : (double)(lab[0] / k));
        float fy = xyz[1] > e ? (lab[0] + 16.0f) / 116.0f : (k * xyz[1] + 16.0f) / 116.0f;
        float fx = lab[1] / 500.0f + fy;
        float fz = fy - lab[2] / 200.0f;
        xyz[0] = (float)Math.pow(fx, 3.0);
        if (xyz[0] <= e) {
            xyz[0] = (116.0f * fx - 16.0f) / k;
        }
        xyz[2] = (float)Math.pow(fz, 3.0);
        if (xyz[2] <= e) {
            xyz[2] = (116.0f * fz - 16.0f) / k;
        }
        for (int i = 0; i < 3; ++i) {
            int n = i;
            xyz[n] = xyz[n] * D65XYZ[i];
        }
        return xyz;
    }

    public static float[] XYZtoRGB(float[] xyz) {
        float[][] M = new float[][]{{3.24071f, -1.53726f, -0.498571f}, {-0.969258f, 1.87599f, 0.0415557f}, {0.0556352f, -0.203996f, 1.05707f}};
        return AMath.fmultV(xyz, M);
    }

    public static float[] RGBtosRGB(float[] rgb) {
        float[] srgb = new float[]{rgb[0] > 0.00304f ? (float)(1.055 * Math.pow(rgb[0], 0.4166666666666667) - 0.055) : (float)(12.92 * (double)rgb[0]), rgb[1] > 0.00304f ? (float)(1.055 * Math.pow(rgb[1], 0.4166666666666667) - 0.055) : (float)(12.92 * (double)rgb[1]), rgb[2] > 0.00304f ? (float)(1.055 * Math.pow(rgb[2], 0.4166666666666667) - 0.055) : (float)(12.92 * (double)rgb[2])};
        return srgb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float[][] loadPaletteLab(InputStream stream) throws FileNotFoundException {
        float[][] labmap = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        Vector<float[]> map = new Vector<float[]>();
        try {
            String str = br.readLine();
            while (str != null) {
                StringTokenizer tzer = new StringTokenizer(str);
                float[] rgb = new float[3];
                for (int c = 0; c < 3; ++c) {
                    int ii = Integer.parseInt(tzer.nextToken());
                    rgb[c] = (float)ii / 255.0f;
                }
                float[] lab = Utilities.sRGBtoLab(rgb);
                map.add(lab);
                str = br.readLine();
            }
        }
        catch (Exception exc) {
            try {
                System.err.println("loadPaletteLab: " + exc);
            }
            catch (Throwable throwable) {
                labmap = new float[map.size()][3];
                for (int i = 0; i < map.size(); ++i) {
                    float[] lab = (float[])map.get(i);
                    for (int c = 0; c < 3; ++c) {
                        labmap[i][c] = lab[c];
                    }
                }
                throw throwable;
            }
            labmap = new float[map.size()][3];
            for (int i = 0; i < map.size(); ++i) {
                float[] lab = (float[])map.get(i);
                for (int c = 0; c < 3; ++c) {
                    labmap[i][c] = lab[c];
                }
            }
        }
        labmap = new float[map.size()][3];
        for (int i = 0; i < map.size(); ++i) {
            float[] lab = (float[])map.get(i);
            for (int c = 0; c < 3; ++c) {
                labmap[i][c] = lab[c];
            }
        }
        return labmap;
    }

    public static byte[][] loadPalette(InputStream stream) throws FileNotFoundException {
        byte[][] colormap = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        Vector<int[]> map = new Vector<int[]>();
        try {
            while (true) {
                String str = br.readLine();
                StringTokenizer tzer = new StringTokenizer(str);
                int[] rgb = new int[3];
                for (int c = 0; c < 3; ++c) {
                    rgb[c] = Integer.parseInt(tzer.nextToken());
                }
                map.add(rgb);
            }
        }
        catch (Exception exc) {
            colormap = new byte[3][map.size()];
            for (int i = 0; i < map.size(); ++i) {
                int[] rgb = (int[])map.get(i);
                for (int c = 0; c < 3; ++c) {
                    colormap[c][i] = (byte)rgb[c];
                }
            }
            return colormap;
        }
    }

    public static Frame getNonClearingFrame(String name, Component c) {
        final Frame f = new Frame(name){
            private static final long serialVersionUID = 1L;

            public void update(Graphics g) {
                this.paint(g);
            }
        };
        Utilities.sizeContainerToComponent(f, c);
        Utilities.centerFrame(f);
        f.setLayout(new BorderLayout());
        f.add(c, "Center");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                f.dispose();
            }
        });
        return f;
    }

    public static void sizeContainerToComponent(Container container, Component component) {
        if (!container.isDisplayable()) {
            container.addNotify();
        }
        Insets insets = container.getInsets();
        Dimension size = component.getPreferredSize();
        int width = insets.left + insets.right + size.width;
        int height = insets.top + insets.bottom + size.height;
        container.setSize(width, height);
    }

    public static void centerFrame(Frame f) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = f.getSize();
        int x = (screen.width - d.width) / 2;
        int y = (screen.height - d.height) / 2;
        f.setLocation(x, y);
    }

    public static void placeRightTo(Frame f, Frame reference) {
        Dimension d = reference.getSize();
        Point origin = reference.getLocation();
        f.setLocation((int)(origin.getX() + d.getWidth()), (int)origin.getY());
    }

    public static void fitBetween(Frame f, Frame left, Frame right) {
        Utilities.fitBetween(f, left, right, 0);
    }

    public static void fitBetween(Frame f, Frame left, Frame right, int minSize) {
        Dimension d = left.getSize();
        Point origin = left.getLocation();
        Point maxr = right.getLocation();
        double size = Math.max(maxr.getX() - origin.getX() - d.getWidth(), (double)minSize);
        f.setSize((int)size, Toolkit.getDefaultToolkit().getScreenSize().height);
        f.setLocation((int)(origin.getX() + d.getWidth()), (int)origin.getY());
    }

    public static void placeRight(Frame f) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = f.getSize();
        Point origin = f.getLocation();
        f.setLocation((int)((double)screen.width - d.getWidth()), (int)origin.getY());
    }

    public static void placeBelow(Frame f, Frame reference) {
        Dimension d = reference.getSize();
        Point origin = reference.getLocation();
        f.setLocation((int)origin.getX(), (int)(origin.getY() + d.getHeight()));
    }

    public static void placeBottomRight(Frame f) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = f.getSize();
        int x = screen.width - d.width;
        int y = screen.height - d.height;
        f.setLocation(x, y);
    }

    public static void placeBottomLeft(Frame f) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = f.getSize();
        int y = screen.height - d.height;
        f.setLocation(0, y);
    }

    public static String dateStamp() {
        GregorianCalendar c = new GregorianCalendar();
        int year = c.get(1) - 2000;
        int month = c.get(2) + 1;
        int day = c.get(5);
        String date = "";
        date = date + (year < 10 ? "0" + year : Integer.valueOf(year));
        date = date + (month < 10 ? "0" + month : Integer.valueOf(month));
        date = date + (day < 10 ? "0" + day : Integer.valueOf(day));
        return date;
    }
}

