/*
 * Decompiled with CFR 0.152.
 */
package titech.wt;

import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import titech.image.matting.Boundary;
import titech.util.Utilities;
import titech.wt.ModListener;

public class ClipCanvas
extends Canvas
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private int pressedButton = 0;
    private BufferedImage mRealBufferImage = null;
    private Graphics realBufferGraphics;
    private BufferedImage mImage = null;
    private BufferedImage lineImage = null;
    private BufferedImage contourImage = null;
    private BufferedImage originalImage = null;
    protected int strokeSize = 50;
    protected Stroke stroke = new BasicStroke(this.strokeSize);
    private Dimension maxSize;
    private int width = 1;
    private int height = 1;
    private Point offset;
    Point location;
    protected Color bgColor = Color.black;
    protected Color fgColor = Color.green;
    protected Color transparent = new Color(0, true);
    Color strokeColor = new Color(0x30FFFF00, true);
    public boolean moved;
    private ModListener modListener;
    private Point previousPoint;
    private Point firstPoint;
    private boolean freehand;
    private boolean contourExists;
    boolean inside = false;
    boolean dragging = false;

    public boolean theresContour() {
        return this.contourExists;
    }

    public void setStroke(int size) {
        this.strokeSize = size;
        this.stroke = new BasicStroke(size, 1, 1);
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = this.width;
        size.height = this.height;
        return size;
    }

    public Dimension getMaxSize() {
        return this.maxSize;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public BufferedImage getContour() {
        if (this.contourExists) {
            return this.contourImage;
        }
        return null;
    }

    public BufferedImage getClippedImage() {
        BufferedImage bim = new BufferedImage(this.width, this.height, 2);
        Graphics gi = bim.getGraphics();
        gi.drawImage(this.mImage, this.offset.x, this.offset.y, this);
        gi.dispose();
        return bim;
    }

    public Rectangle getClipArea() {
        int w = this.width;
        int h = this.height;
        int x = 0;
        int y = 0;
        if (this.offset.x < 0) {
            x = -this.offset.x;
            w = Math.min(w, this.mImage.getWidth() - x);
        } else {
            w -= this.offset.x;
        }
        if (this.offset.y < 0) {
            y = -this.offset.y;
            h = Math.min(h, this.mImage.getHeight() - y);
        } else {
            h -= this.offset.y;
        }
        Rectangle r = new Rectangle(x, y, w, h);
        return r;
    }

    public Point getOffset() {
        return this.offset;
    }

    public ClipCanvas(int size) {
        this(size, size);
    }

    public ClipCanvas(int width, int height) {
        this(width, height, Color.black);
    }

    public ClipCanvas(int width, int height, Color bg) {
        this.bgColor = bg;
        this.setBackground(this.bgColor);
        this.setSize(width, height);
        this.offset = new Point(0, 0);
        this.moved = true;
        this.previousPoint = new Point(-1, -1);
        this.firstPoint = new Point(-1, -1);
        this.freehand = true;
        this.contourExists = false;
        this.maxSize = new Dimension(width, width);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.width = width;
        this.height = height;
        this.mImage = new BufferedImage(width, height, 2);
        Graphics gi = this.mImage.getGraphics();
        gi.setColor(this.bgColor);
        gi.fillRect(0, 0, width, height);
        gi.dispose();
        this.lineImage = new BufferedImage(width, height, 2);
        this.contourImage = new BufferedImage(width, height, 2);
        this.mRealBufferImage = new BufferedImage(width, height, 2);
        this.realBufferGraphics = this.mRealBufferImage.getGraphics();
        this.realBufferGraphics.setColor(this.bgColor);
        this.realBufferGraphics.fillRect(0, 0, width, height);
    }

    public void setMaxSize(Dimension dim) {
        this.maxSize.width = dim.width;
        this.maxSize.height = dim.height;
    }

    public void setModListener(ModListener modListener) {
        this.modListener = modListener;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.realBufferGraphics.drawImage(this.mImage, this.offset.x, this.offset.y, this);
        this.realBufferGraphics.drawImage(this.contourImage, 0, 0, this);
        this.realBufferGraphics.drawImage(this.lineImage, 0, 0, this);
        if (this.inside && !this.dragging) {
            this.realBufferGraphics.setColor(this.fgColor);
            this.realBufferGraphics.drawOval(this.location.x - (this.strokeSize >> 1), this.location.y - (this.strokeSize >> 1), this.strokeSize, this.strokeSize);
        }
        g.drawImage(this.mRealBufferImage, 0, 0, this);
    }

    public void add(BufferedImage bim) {
        Graphics gi = this.mImage.getGraphics();
        gi.drawImage(bim, 0, 0, this);
        this.repaint();
    }

    public void setImage(BufferedImage bim) {
        this.originalImage = bim;
        BufferedImage img = Utilities.resize(this.originalImage, this.maxSize.width, this.maxSize.height);
        this.setSize(img.getWidth(), img.getHeight());
        this.mImage = img;
        this.resetOffset();
        this.clearLines();
        this.clearContour();
        this.repaint();
    }

    public void addL(BufferedImage bim) {
        this.addL(bim, 0, 0);
    }

    public void addL(BufferedImage bim, int x, int y) {
        Graphics gi = this.lineImage.getGraphics();
        gi.drawImage(bim, x, y, this);
        this.repaint();
    }

    public void add(Boundary boundary) {
        this.add(boundary, 0, 0);
    }

    public void add(Boundary boundary, int x, int y) {
        Graphics2D gi = (Graphics2D)this.lineImage.getGraphics();
        gi.drawImage((Image)boundary.getContour(), x, y, this);
        this.repaint();
    }

    public void add(Vector points, int color) {
        this.add(points, color, 0, 0);
    }

    public void add(Vector points, int color, int x, int y) {
        int w = this.lineImage.getWidth();
        int h = this.lineImage.getHeight();
        for (int i = 0; i < points.size(); ++i) {
            Point p = (Point)points.get(i);
            int xx = p.x + x;
            int yy = p.y + y;
            if (xx < 0 || xx >= w || yy < 0 || yy >= h) continue;
            this.lineImage.setRGB(xx, yy, color);
        }
        this.repaint();
    }

    public void add(Point[] points, int color) {
        this.add(points, color, 0, 0);
    }

    public void add(Point[] points, int color, int x, int y) {
        int w = this.lineImage.getWidth();
        int h = this.lineImage.getHeight();
        for (int i = 0; i < points.length; ++i) {
            Point p = points[i];
            if (p == null) continue;
            int xx = p.x + x;
            int yy = p.y + y;
            if (xx < 0 || xx >= w || yy < 0 || yy >= h) continue;
            this.lineImage.setRGB(xx, yy, color);
        }
        this.repaint();
    }

    public void add(Point p, int color) {
        this.add(p, color, 0, 0);
    }

    public void add(Point p, int color, int x, int y) {
        int w = this.lineImage.getWidth();
        int h = this.lineImage.getHeight();
        int xx = p.x + x;
        int yy = p.y + y;
        if (xx >= 0 && xx < w && yy >= 0 && yy < h) {
            this.lineImage.setRGB(xx, yy, color);
        }
        this.repaint();
    }

    public void clearLines() {
        Graphics2D gi = (Graphics2D)this.lineImage.getGraphics();
        gi.setBackground(this.transparent);
        gi.clearRect(0, 0, this.width, this.height);
        gi.dispose();
    }

    public void clearContour() {
        Graphics2D gi = (Graphics2D)this.contourImage.getGraphics();
        gi.setBackground(this.transparent);
        gi.clearRect(0, 0, this.width, this.height);
        gi.dispose();
        this.contourExists = false;
    }

    public void resetOffset() {
        this.offset.x = 0;
        this.offset.y = 0;
    }

    public void mouseDragged(MouseEvent e) {
        this.dragging = true;
        if (this.pressedButton == 2 || e.isMetaDown()) {
            int x = e.getX();
            int y = e.getY();
            int wh = this.width >> 1;
            int hh = this.height >> 1;
            this.offset.x = x - wh;
            this.offset.y = y - hh;
            this.repaint();
        } else if (this.pressedButton == 1) {
            int maxy;
            int x = e.getX();
            int y = e.getY();
            int minx = this.offset.x > 0 ? this.offset.x : 0;
            int miny = this.offset.y > 0 ? this.offset.y : 0;
            int maxx = this.mImage.getWidth() + this.offset.x < this.width ? this.mImage.getWidth() + this.offset.x : this.width;
            int n = maxy = this.mImage.getHeight() + this.offset.y < this.height ? this.mImage.getHeight() + this.offset.y : this.height;
            int n2 = x < minx ? minx : (x = x >= maxx ? maxx - 1 : x);
            int n3 = y < miny ? miny : (y = y >= maxy ? maxy - 1 : y);
            if (this.previousPoint.x >= 0) {
                Graphics2D gi = (Graphics2D)this.contourImage.getGraphics();
                if (e.isShiftDown()) {
                    this.freehand = false;
                    this.clearContour();
                    int xx = x < this.firstPoint.x ? x : this.firstPoint.x;
                    int yy = y < this.firstPoint.y ? y : this.firstPoint.y;
                    int w = Math.abs(this.firstPoint.x - x);
                    int h = Math.abs(this.firstPoint.y - y);
                    gi.drawRect(xx, yy, w, h);
                } else {
                    this.freehand = true;
                    gi.setStroke(this.stroke);
                    gi.setColor(this.strokeColor);
                    gi.fillOval(x - (this.strokeSize >> 1), y - (this.strokeSize >> 1), this.strokeSize, this.strokeSize);
                }
                this.repaint();
            } else {
                this.clearContour();
                this.firstPoint.x = x;
                this.firstPoint.y = y;
            }
            this.previousPoint.x = x;
            this.previousPoint.y = y;
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.location = e.getPoint();
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.location = e.getPoint();
        this.inside = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.inside = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        this.pressedButton = e.getButton();
    }

    public void mouseReleased(MouseEvent e) {
        this.pressedButton = 0;
        if (this.previousPoint.x < 0) {
            this.moved = true;
            this.clearLines();
            this.clearContour();
            this.repaint();
            if (this.modListener != null) {
                this.modListener.shifted();
            }
        } else {
            this.moved = true;
            this.previousPoint.x = -1;
            this.previousPoint.y = -1;
            this.firstPoint.x = -1;
            this.firstPoint.y = -1;
            this.contourExists = true;
            this.repaint();
            if (this.modListener != null) {
                this.modListener.clip();
            }
        }
        this.dragging = false;
    }

    public void mouseWheelMoved(MouseWheelEvent event) {
        if (event.getScrollType() == 0) {
            int totalScrollAmount = event.getUnitsToScroll();
            double ratio = (double)this.originalImage.getWidth() / (double)this.originalImage.getHeight();
            this.maxSize.height += totalScrollAmount;
            this.maxSize.width = (int)((double)this.maxSize.height * ratio);
            this.mImage = Utilities.resize(this.originalImage, this.maxSize.width, this.maxSize.height);
            this.repaint();
        }
    }

    public void keyPressed(KeyEvent e) {
        int c = e.getKeyCode();
        switch (c) {
            case 71: {
                Utilities.colorToGray(this.mImage);
                this.repaint();
                System.out.println("g");
                break;
            }
            case 87: {
                if (this.modListener == null) break;
                this.modListener.fullclip();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

