/*
 * Decompiled with CFR 0.152.
 */
package titech.wt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import titech.wt.ModListener;

public class CompositeCanvas
extends Canvas
implements MouseMotionListener,
MouseListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private BufferedImage mRealBufferImage = null;
    private Graphics realBufferGraphics;
    private BufferedImage mImage = null;
    private BufferedImage mObject = null;
    private int width = 1;
    private int height = 1;
    private Point offset;
    private Point draggingPoint;
    private ModListener modListener;
    protected Color bgColor;
    protected Color transparent = new Color(0, true);
    protected boolean objectExists;
    protected boolean dragging;
    public int maxObjectWidth;
    public int maxObjectHeight;

    public boolean theresObject() {
        return this.objectExists;
    }

    public void setModListener(ModListener modListener) {
        this.modListener = modListener;
    }

    public Point getOffset() {
        return this.offset;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = this.width;
        size.height = this.height;
        return size;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public BufferedImage getCollage() {
        Graphics gi = this.mImage.getGraphics();
        gi.drawImage(this.mObject, this.offset.x, this.offset.y, this);
        return this.mImage;
    }

    public CompositeCanvas(int size) {
        this(size, size);
    }

    public CompositeCanvas(int width, int height) {
        this(width, height, Color.white);
    }

    public CompositeCanvas(int width, int height, Color bg) {
        this.maxObjectWidth = width;
        this.maxObjectHeight = height;
        this.bgColor = bg;
        this.setBackground(this.bgColor);
        this.setSize(width, height);
        this.offset = new Point(0, 0);
        this.draggingPoint = new Point(0, 0);
        this.modListener = null;
        this.objectExists = false;
        this.dragging = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public void setbgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.width = width;
        this.height = height;
        this.mImage = new BufferedImage(width, height, 2);
        Graphics gi = this.mImage.getGraphics();
        gi.setColor(this.bgColor);
        gi.fillRect(0, 0, width, height);
        gi.dispose();
        this.mRealBufferImage = new BufferedImage(width, height, 2);
        this.realBufferGraphics = this.mRealBufferImage.getGraphics();
        this.realBufferGraphics.setColor(this.bgColor);
        this.realBufferGraphics.fillRect(0, 0, width, height);
        this.mObject = new BufferedImage(this.maxObjectWidth, this.maxObjectHeight, 2);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.realBufferGraphics.drawImage(this.mImage, 0, 0, this);
        this.realBufferGraphics.drawImage(this.mObject, this.offset.x, this.offset.y, this);
        g.drawImage(this.mRealBufferImage, 0, 0, this);
    }

    public void clearObject() {
        Graphics2D gi = (Graphics2D)this.mObject.getGraphics();
        gi.setBackground(this.transparent);
        gi.clearRect(0, 0, this.width, this.height);
        gi.dispose();
        this.objectExists = false;
    }

    public void clearObject(int width, int height) {
        this.mObject = new BufferedImage(width, height, 2);
        this.objectExists = false;
    }

    public void add(BufferedImage bim) {
        Graphics gi = this.mImage.getGraphics();
        gi.drawImage(this.mObject, this.offset.x, this.offset.y, this);
        this.resetOffset();
        this.updateObject(bim);
        this.objectExists = true;
    }

    public void setBackground(BufferedImage bim) {
        Graphics gi = this.mImage.getGraphics();
        gi.clearRect(0, 0, this.width, this.height);
        gi.drawImage(bim, 0, 0, this);
        gi.dispose();
        this.repaint();
    }

    public void updateObject(BufferedImage bim) {
        this.clearObject(bim.getWidth(), bim.getHeight());
        Graphics gi = this.mObject.getGraphics();
        gi.drawImage(bim, 0, 0, this);
        this.repaint();
        this.objectExists = true;
    }

    public void addOffset(int x, int y) {
        this.offset.x += x;
        this.offset.y += y;
    }

    public void resetOffset() {
        this.offset.x = 0;
        this.offset.y = 0;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.objectExists && this.dragging) {
            int x = e.getX();
            int y = e.getY();
            this.offset.x = x - this.draggingPoint.x;
            this.offset.y = y - this.draggingPoint.y;
            this.repaint();
        }
    }

    public static boolean isTransparent(BufferedImage img, int x, int y) {
        if (x < 0 || x >= img.getWidth()) {
            return false;
        }
        if (y < 0 || y >= img.getHeight()) {
            return false;
        }
        return img.getRGB(x, y) >> 24 == 0;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.requestFocusInWindow();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (!this.dragging) {
            int x = e.getX();
            int y = e.getY();
            boolean insideObject = x >= this.offset.x && x < this.mObject.getWidth() + this.offset.x && y >= this.offset.y && y < this.mObject.getHeight() + this.offset.y;
            this.draggingPoint.x = x - this.offset.x;
            this.draggingPoint.y = y - this.offset.y;
            if (insideObject && !CompositeCanvas.isTransparent(this.mObject, this.draggingPoint.x, this.draggingPoint.y)) {
                this.dragging = true;
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.modListener != null && this.objectExists && this.dragging) {
            this.modListener.moved();
            this.dragging = false;
        }
    }

    public void keyPressed(KeyEvent e) {
        int c = e.getKeyCode();
        switch (c) {
            case 8: 
            case 127: {
                this.clearObject();
                this.repaint();
                break;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

