/*
 * Decompiled with CFR 0.152.
 */
package titech.wt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class SimpleCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    private BufferedImage mImage = null;
    private int width = 1;
    private int height = 1;
    protected Color bgColor = Color.black;

    public SimpleCanvas(int size) {
        this(size, size);
    }

    public SimpleCanvas(int width, int height) {
        this(width, height, Color.black);
    }

    public SimpleCanvas(int width, int height, Color bg) {
        this.bgColor = bg;
        this.setBackground(this.bgColor);
        this.setSize(width, height);
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.width = width;
        this.height = height;
        this.mImage = new BufferedImage(width, height, 2);
        Graphics gi = this.mImage.getGraphics();
        gi.setColor(this.bgColor);
        gi.fillRect(0, 0, width, height);
        gi.dispose();
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width = this.width;
        size.height = this.height;
        return size;
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public void add(BufferedImage bim) {
        Graphics gi = this.mImage.getGraphics();
        gi.drawImage(bim, 0, 0, this);
        this.repaint();
    }

    public void set(BufferedImage bim) {
        this.setSize(bim.getWidth(), bim.getHeight());
        this.add(bim);
    }

    public void paint(Graphics g) {
        g.drawImage(this.mImage, 0, 0, this);
    }
}

