﻿/*
	Script:		main.js
	Gadget:		Slimserver Controler
	Author:		Ben Coleman
	Version:	1.4.0
	Date:		11 July 2007
	Update:		26 July 2007
	Notes:		Tested on Google Desktop v5.1
	Changes:
			1.0.0.0	-	Initial release
			1.0.1.0	-	Detects "stopped" state and empty playlists better
			1.2.0.0	-	Major overhaul, MUCH, MUCH more efficient, popup menu support, and track deatils view.
			1.2.1.0	-	Fixes to the details popout and album art when offline or with empty playlists
			1.2.5.0	-	Send message support, and logging code
			1.2.6.0	-	Fixed all the bug people were having, casued by URL caching
			1.2.7.0	-	Album art in details panel still pointing to euclid - fixed
			1.2.8.0	-	Inconsistant behaviour of details view fixed, now refreshes on track change
			1.3.0.0	-	Gadget made slightly larger with biger text, album art now hidable + other fixes
			1.4.0.0	-	Shiny new progress bar and track jump feature, plus album art improvements
*/

var xhr = new XMLHttpRequest();
var xhr_album;
var notify_item = new ContentItem();
var token = -1;
var old_title = "";
var old_vol = "";
var details_shown = false;
var art_shown = true;

var title;
var artist;
var album;
var track;
var genre;
var duration;
var type;
var bitrate;
var year;
var title_id;
var artist_id;
var album_id;
var genre_id;
var time_total;

var player_ip;
var server_host;
var server_port;
var url_stub;

var stopped = false;
var log;

// hook call so our custom menu function is called 
pluginHelper.onAddCustomMenuItems = addCustomMenuItems

//
// add menu items to the main gadget menu
//
function addCustomMenuItems(menu)
{
	shuffle_menu = menu.AddPopup("Shuffle");
	shuffle_menu.AddItem("Shuffle Off", 0, shuffleOff);
	shuffle_menu.AddItem("Shuffle Tracks", 0, shuffleTracks);
	shuffle_menu.AddItem("Shuffle Albums", 0, shuffleAlbums);

	repeat_menu = menu.AddPopup("Repeat");
	repeat_menu.AddItem("Repeat None", 0, repeatOff);
	repeat_menu.AddItem("Repeat One", 0, repeatOne);
	repeat_menu.AddItem("Repeat All", 0, repeatAll);

	menu.AddItem("Random Mix", 0, random_mix);
	menu.AddItem("Clear Playlist", 0, clearPlaylist);
	menu.AddItem("Play this album", 0, playAlbum);
	menu.AddItem("Send Message", 0, show_messageSender);
}

function view_onOpen()
{
	// system default options
	options.putDefaultValue("server_host", "localhost");
	options.putDefaultValue("server_port", "9000");
	options.putDefaultValue("player_name", "");
	options.putDefaultValue("player_list", "");
	options.putDefaultValue("refresh_int", 20);
	options.putDefaultValue("refresh_on", true);
	options.putDefaultValue("alert_show", false);

	player_ip = options.getValue("player_name");
	server_host = options.getValue("server_host");
	server_port = options.getValue("server_port");
	url_stub = "http://"+server_host+":"+server_port;

	details_shown = false;

	// do the inital refresh and data load
	getStatus();
	
	main_link.href = url_stub+"?player="+player_ip;
}

// user has clicked the play button
function play()
{
	sendCommand("play");
	getStatus();
}

// user has clicked the pause button
function pause()
{
	sendCommand("pause&p1=1");
	getStatus();
}

// user has clicked the skip back (rewind) button
function skip_back()
{
	sendButton("jump_rew");
	getStatus();
}

// user has clicked the skip forward button
function skip_fwd()
{
	sendButton("jump_fwd");
	getStatus();
}

// user has clicked the power button
function power()
{
	sendButton("power_toggle");
	getStatus();
}

// user has clicked on the volume bar
function volume()
{
	v = Math.round((event.x / img_vol.width) * 100);
	v = Math.ceil(v / 5) * 5;

	sendCommand("mixer&p1=volume&p2="+v);
}

// user has clicked on the random mix button
function random_mix()
{
	//txt_status.innerText = "Loading random mix";
	
	getURL(url_stub+"/plugins/RandomPlay/randomplay_mix.html?type=track&addOnly=0&player="+player_ip, false);
	getStatus();
}

// clear the player playlist of items (stop playback)
function clearPlaylist()
{
	sendCommand("playlist&p1=clear");
	getStatus();
}

// set the shuffle mode
function shuffle(mode)
{
	sendCommand("playlist&p1=shuffle&p2="+mode);
	getStatus();
}
function shuffleOff() { shuffle(0); }
function shuffleTracks() { shuffle(1); }
function shuffleAlbums() { shuffle(2); }

// set the repeat mode
function repeat(mode)
{
	sendCommand("playlist&p1=repeat&p2="+mode);
	getStatus();
}
function repeatOff() { repeat(0); }
function repeatOne() { repeat(1); }
function repeatAll() { repeat(2); }


// The main function 
// - this requests the XML file from the slimserver, this is done asynchronously with XMLHttpRequest
// - when the results are returned httpChange is called (callback from XMLHttpRequest) this then calls
// - the second part of the function getStatus_2 (note. never call getStatus_2 directly)
function getStatus()
{
	// reset the auto refesh, and set a new one to run in X seconds time
	clearInterval(token);
	if(options.getValue("refresh_on"))
		token = setInterval("getStatus()", options.getValue("refresh_int") * 1000);

	// online status check
	/*if(!framework.system.network.online) {
		showText("Not online.\nPlease connect your PC to\nthe network in order to proceed", true);
		
		stopped = true;
		caption = "Not Online";
		return;
	}*/

	// hide the error icon (if show), show the "refreshing data" icon 
	img_refresh.visible = true;
	img_error.visible = false;

	// call this with async set true, the httpChange function then calls the second part 
	// when the HTTP resp is returned, note that getURL is called with second param of true
	getURL(url_stub+"/xml/status_header.xml?player="+player_ip, true);	

}

// called when the httpChange callback is invoked - meaning we have some XML back from the server
// this parses the XML using code in xml_parser.js and updates the display and other parts of the system
function getStatus_2()
{
	// XML parser helper object
	parser = new SimpleXmlParser(xhr.responseXML);
	
	// get all the items under the "player" node in the XML
	// these will be all the players registered with this slimserver
	items = parser.getItems("player");
	count = items.length;
	// if no players then we in trouble!
	if(count == 0) {
		showText("No players registered!\nPlease install a player and register\n - it with this Slimserver", true);
		return;
	}

	// store the list of player names in a tab seperated list, for use in the options dialog
	var temp = new Array();
	for(i = 0; i < count; i++) {
			temp[i] = items[i]['player_name'];
	}
	options.putValue("player_list", temp.join("\t"));

	// get all the items under the "transport" node in the XML
	// this gives us things like the player status (on/off) and playmode (play/pause)
	items = parser.getItems("transport");
	onoff = items[0]['mode'];
	playmode = items[0]['playmode'];
	//playmode = playmode.charAt(0).toUpperCase()+playmode.substring(1);

	// get all the items under the "transport" node in the XML
	// this gives us things like the player volume
	items = parser.getItems("audio");
	lab_vol.innerText = items[0]['volume'] + "%";

	// get all the items under the "current_song" node in the XML
	// this is the main task here, find all the info about the currently playing track
	items = parser.getItems("current_song");
	
	// bugger - we have nothing in the playlist
	if(items.length == 0) {
		showText("\nPlaylist is empty");
		old_title = "";
		status = "Stopped";
		status_time = "";
		div_tp_bar.width = 0;
		img_album.src = "img/no_art.png";
		stopped = true;
		caption = "Stopped";
	// thats better...
	} else {
		stopped = false;
		// process the track title, album & artist
		title = (items[0]['title'] != null) ? items[0]['title'] : "";
		artist = (items[0]['artist'] != null) ? items[0]['artist'] : "";
		album = (items[0]['album'] != null) ? items[0]['album'] : "";

		// playlist info (number of tracks and current track number in the playlist)
		playlist_now = parseInt(items[0]['playlist_offset']) + 1;
		playlist_total = items[0]['playlist_length'];
		status = "("+playlist_now+" of "+playlist_total+")";
		
		// get the track elapsed time and total length
		time_elapsed = parseInt(items[0]['seconds_elapsed']);
		time_total = parseInt(items[0]['seconds_total']);
		time_width = (time_elapsed / time_total) * (div_tp_back.width-2);
		div_tp_bar.width = time_width;

		status_time = secsToReadable(time_elapsed) + " / " + secsToReadable(time_total);

		// link to album page on slimserver
		if(items[0]['album_browse_url'] != null) {
			url_part = items[0]['album_browse_url'].substring(17);
			link_album.href = url_stub+"/browsedb.html"+url_part;
		} else {
			link_album.href = "#";
		}
		
		// grab extra info about the track
		track = (items[0]['track'] != null) ? items[0]['track'] : "";
		genre = (items[0]['genre'] != null) ? items[0]['genre'] : "";
		duration = (items[0]['duration'] != null) ? items[0]['duration'] : "";
		type = (items[0]['type'] != null) ? items[0]['type'] : "";
		bitrate = (items[0]['bitrate'] != null) ? items[0]['bitrate']/1000 : "?";
		year = (items[0]['year'] != null) ? items[0]['year'] : "";

		// grab IDs these are used for the links in the details view
		title_id = items[0]['song_id'];
		genre_id = items[0]['genre_id'];
		album_id = items[0]['album_id'];
		artist_id = items[0]['artist_id'];

		// Tooltip shows extra info it would be impractical to show in the main display
		tooltip = "Artist:\t\t"+artist+"\n";
		tooltip += "Album:\t\t"+album+"\n";
		tooltip += "Title:\t\t"+title+"\n";
		tooltip += "Track:\t\t"+track+"\n";
		tooltip += "Year:\t\t"+year+"\n";
		tooltip += "Duration:\t"+duration+"\n";
		tooltip += "Genre:\t\t"+genre+"\n";
		tooltip += "Type:\t\t"+type+"\n";
		tooltip += "Bitrate:\t\t"+bitrate+"";
		txt_display.tooltip = tooltip;
		
		// update the main display text
		showText(artist+"\n"+title+"\n"+album);
		caption = title;

		// the reason this is here, is the cover art call back will set the image on it
		//notify_item = new ContentItem();

		// code to deal with the album artwork, wow snazzy stuff!
		if(items[0]['coverart'] != null) {
			art_url = url_stub + "/music/"+title_id+"/thumb_95x95_s.jpg";
			//art_url = url_stub + items[0]['coverart'];

			// we use a seperate XMLHttpRequest object to fetch the album art.
			try {
				xhr_album = new XMLHttpRequest();
				xhr_album.open("GET", art_url, true);
			} catch (e) {
				
			}

			// set the callback for when the downloading is completed (or failed)
			xhr_album.onreadystatechange = onAlbumData;

			// start the download
			try {
				xhr_album.send();
			} catch (e) {
				
			}
		} else {
			img_album.src = "img/no_art.png";
		}
	
		// keep track of the old track title, if it changes then display popup notification
		if(old_title == "" || title != old_title) {
			old_title = title;
			if(details_shown) {
				hideDetails();
				showDetails();
			}

			// Display the desktop notify alert if enabled
			if(options.getValue("alert_show")) {
				notify_item.heading = title;
				notify_item.snippet = artist+" - "+album;	// I wish we could use HTML or newlines here!
				pluginHelper.addContentItem(notify_item, gddItemDisplayAsNotification);
			}
		}
	}

	// change the power icon to reflect the status
	img_power.src = "img/power_"+onoff+".png"

	// Some status info displayed as text
	if(onoff == "off") {
		txt_status.innerText = ""
		txt_time.innerText = ""
		div_tp_bar.width = 0;
		txt_time.innerText = "Player is off";
	} else {
		txt_status.innerText = status;
		txt_time.innerText = status_time;
	}

	// change the colours of the play and pause buttons if in playing or paused status
	if(playmode == "playing") {
		img_play.src = "img/player_play1.png";
		img_pause.src = "img/player_pause.png";
	} else if(playmode == "paused") {
		img_play.src = "img/player_play.png";
		img_pause.src = "img/player_pause1.png";
	} else if(playmode == "stopped") {
		img_play.src = "img/player_play.png";
		img_pause.src = "img/player_pause.png";
		txt_time.innerText = "Stopped";
		div_tp_bar.width = 0;
	}

	// phew! done, hide the "now refreshing" icon
	img_refresh.visible = false;
}

// mouse hovering over the volume bar
function volume_mouseMove()
{
	v = Math.round((event.x / img_vol.width) * 100);
	v = Math.ceil(v / 5) * 5;

	lab_vol.innerText = v + "%";
}

// mouse over the volume bar
function volume_mouseOver()
{
	old_vol = lab_vol.innerText;
}

// mouse left the volume bar
function volume_mouseOut()
{
	lab_vol.innerText = old_vol;
}

// Convenience function to send a command to the slimserver
//  - note this is NOT done asynchronously, very cheeky - but it works
function sendCommand(cmd)
{
	//debug.trace("sending cmd "+cmd);
	rc = getURL(url_stub+"/status.txt?p0="+cmd+"&player="+player_ip, false);
}

// Convenience function to send a RC button-press to the slimserver
//  - note this is NOT done asynchronously, very cheeky - but it works
function sendButton(button)
{
	rc = getURL(url_stub+"/status.txt?p0=button&player="+player_ip+"&p1="+button, false);
}

// Convenience function to issue a HTTP GET request to a URL using XMLHttpRequest
function getURL(url, callback)
{
	//debug.trace(url);
	try {
		xhr.open("GET", url, callback);
		
		// force cacheing off
		ifModifiedSince = new Date(0); // January 1, 1970
		xhr.setRequestHeader("Pragma", "no-cache");
		xhr.setRequestHeader("Cache-Control", "no-cache");
		xhr.setRequestHeader("If-Modified-Since", ifModifiedSince);
		
		xhr.send();
		
		if(callback) {
			xhr.onreadystatechange = httpChange;
		} else {
			
		}
		return;
	} catch (e) {
		debug.error("Call to "+url+" failed"+e);
		
		return -1;
	}
}

// callback handler for the XMLHttpRequest to invoke when data is returned
// - note only the getStatus function makes asynchronous calls to XMLHttpRequest so it's only used for that
function httpChange()
{
	if(xhr.readyState == 4) {
		
		if(xhr.status == 200) {
			getStatus_2();
		} else {
			
			showText("Failed to connect\nto Slimserver "+options.getValue("server_host"), true);
			stopped = true;
			caption = "Error";
		}
	}
}

// Update the main display text area
function showText(msg, err)
{
	if(err) {
		img_error.visible = true;
		img_refresh.visible = false;
		txt_time.innerText = "Error";
	}
	txt_display.color = "#ffffff";
	txt_display.innerText = msg;
	txt_display_shad.innerText = msg;
}

function show_messageSender() 
{
	div_message.visible = true;
	txt_display.visible = false;
	txt_display_shad.visible = false;
}

function hide_messageSender() 
{
	div_message.visible = false;
	txt_display.visible = true;
	txt_display_shad.visible = true;
}

function sendMessage() 
{
	sendCommand("display&p1=&p2="+edit_msg.value+"&p3=60");
	hide_messageSender();
}

// the option dialog has changed some options, this callback gets called when an option value is updated
function view_onOptionChanged()
{
	// weird check this, this callback function will get called for EVERY option value change 
	// - that would result in dozens of calls to getStatus, but we want to invoke getStatus once
	// - this traps the last value we change in the options_onOK() function so we only call getStatus once
	if(event.propertyName == "refresh_on") {
		player_ip = options.getValue("player_name");
		server_host = options.getValue("server_host");
		server_port = options.getValue("server_port");
		url_stub = "http://"+server_host+":"+server_port;

		getStatus();
		
		// if the options have changed the link needs updating
		main_link.href = url_stub+"?player="+player_ip;
	}
}

// callback for the album art download XMLHttpRequest
function onAlbumData() {
	// Verify that the download completed
	if (xhr_album.readyState != 4)
		return;

	// Verify that the download was successful
	if (xhr_album.status != 200) {
		return;
	}

	if(xhr_album.responseStream != null) {
		// Obtain the stream of image data and set it as the image.
		img_album.src = xhr_album.responseStream;
		// we also set the art on the notify item, very nifty
		notify_item.notifier_image = framework.graphics.loadImage(xhr_album.responseStream);
	}
	
	// Destroy the XMLHttpRequest object since it isn't being used anymore
	//xhr_album = null;
}

// convert integer seconds to a readable form (mins:secs) as a string; eg 85 = '01:25'
function secsToReadable(secs)
{
	if(isNaN(secs)) {
		return "00:00";
	}
	temp = secs / 60;
	mins = ""+Math.floor(temp);
	if(mins.length < 2) 
		mins = "0" + mins;
	s = ""+Math.round((temp - mins) * 60);
	if(s.length < 2) 
		s = "0" + s;

	return mins+":"+s;
}

function showOrHideArt()
{
	if(art_shown) {
		view.resizable = true;
		background.src = "img/background_noalbum.png";
		img_art.src = "img/forward.png";
		background.width = 244;
		view.resizeTo(244, view.height);//width = 244;
		link_album.visible = false;
		img_album.visible = false;
		art_backing.visible = false;
		art_shown = false;
		view.resizable = "zoom";
	} else {
		view.resizable = true;
		background.src = "img/background_album.png";
		img_art.src = "img/back.png";
		background.width = 349;
		view.resizeTo(349, view.height);//width = 244;
		link_album.visible = true;
		img_album.visible = true;
		art_backing.visible = true;
		art_shown = true;
		view.resizable = "zoom";
	}
}

function jump()
{
	t = (event.x / div_tp_back.width) * time_total;
	sendCommand("time&p1="+t);
	getStatus();
}

function playAlbum()
{
	getURL(url_stub+"/status_header.html?command=playlist&subcommand=loadtracks&album.id="+album_id+"&player="+player_ip, false);
	getStatus();
}

// No Longer used

/*
function initLog()
{
	fso = framework.system.filesystem;
}

function logMessage(msg)
{
	if(!options.getValue("logging")) return;

	log = fso.OpenTextFile("slimcontrol_gd.log", 8, true);
	log.WriteLine(new Date()+" "+msg);
	debug.trace(new Date()+" "+msg);
	log.Close();
}
*/