﻿
// options show
// load in the values from the options object
function options_onOpen()
{
	edit_server.value = options.getValue("server_host");
	edit_port.value = options.getValue("server_port");
	selected_player = options.getValue("player_name");

	edit_refresh_rate.value = options.getValue("refresh_int");
	cb_refresh.value = options.getValue("refresh_on");
	cb_alert.value = options.getValue("alert_show");

	plist = options.getValue("player_list");
	players = plist.split("\t");

	// this ugly code, dynamically populates the listbox with the list of players names
	for(i = 0; i < players.length; i++) {
		listbox.appendElement("<listitem name='player"+i+"'><label valign='middle' font='Calibri' color='#000000'>"+players[i]+"</label></listitem>");
		if(players[i] == selected_player) {
			listbox.selectedIndex = i;
		}
	}
}

// options OK clicked
// store options back into the object
function options_onOK()
{
	options.putValue("server_host", edit_server.value);
	options.putValue("server_port", edit_port.value);
	if(listbox.selectedIndex >= 0) {
		options.putValue("player_name", listbox.selectedItem.children.item(0).innerText);
	}
	temp = edit_refresh_rate.value;
	if(isNumeric(temp)) {
		if(temp < 5) temp = 5;
		//alert("What do you want to kill your slimserver?\nRefresh interval must be 10 seconds or more");
		options.putValue("refresh_int", temp);
	}

	//options.putValue("refresh_int", edit_refresh_rate.value);
	options.putValue("alert_show", cb_alert.value);
	options.putValue("refresh_on", cb_refresh.value);
}

//
// helper function to check values are numeric
//
function isNumeric(value) {
	return typeof value != "boolean" && value !== null && !isNaN(+ value);
}
