//---------------------------------------------------------------------
//  Copyright (C) Microsoft Corporation.  All rights reserved.
// 
//THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
//KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
//PARTICULAR PURPOSE.
//---------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace CountDownCSharp
{
    public partial class CDHomePanel : UserControl
    {
        public CDHomePanel()
        {
            InitializeComponent();

            this.VisibleChanged += new EventHandler(CDHomePanel_VisibleChanged);
            viewLogLabel.LinkClicked += new LinkLabelLinkClickedEventHandler(viewLogLabel_LinkClicked);
        }

        // Detect whether countdown logging is enabled, and adjust the display accordingly. We do this in 
        // VisibleChanged to handle the user switching logging in the middle of the session.
        private void CDHomePanel_VisibleChanged(Object sender, System.EventArgs e) 
        {
            if (this.Visible) 
	        {
                if (!Properties.Settings.Default.LogSessions)
		        {
                    viewLogLabel.Enabled = false;
                    loggingEnabledLabel.Text = Properties.Resources.CountdownLoggingDisabledText;
		        } else
		        {
                    viewLogLabel.Enabled = true;
                    loggingEnabledLabel.Text = Properties.Resources.CountdownLoggingEnabledText;
                }
            }
        }

        private void viewLogLabel_LinkClicked(System.Object sender, LinkLabelLinkClickedEventArgs e)
        {
            ViewCountdownLog _data = new ViewCountdownLog();
            _data.ShowDialog();
        }
    }
}
