//---------------------------------------------------------------------
//  Copyright (C) Microsoft Corporation.  All rights reserved.
// 
//THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
//KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
//PARTICULAR PURPOSE.
//---------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Media;

namespace CountDownCSharp
{
    public partial class CDSettingsPanel : UserControl, IPanelNavigating
    {
        SoundPlayer _player = null;

        public CDSettingsPanel()
        {
            InitializeComponent();

            saveButton.Click += new EventHandler(saveButton_Click);
            selectSoundFileButton.Click += new EventHandler(selectSoundFileButton_Click);
            soundFileText.TextChanged += new EventHandler(soundFileText_TextChanged);
            testSoundButton.Click += new EventHandler(testSoundButton_Click);

            _player = new SoundPlayer();
        }

        private bool _settingsChanged = false;

        private void selectSoundFileButton_Click(object sender, System.EventArgs e)
        {
            DialogResult _dr = selectFileDialog.ShowDialog();
            if (_dr == DialogResult.OK)
            {
                soundFileText.Text = selectFileDialog.FileName;
                _settingsChanged = true;
            }
        }

        public bool CanNavigate()
        {
            if ((_settingsChanged))
            {
                DialogResult _Dr = MessageBox.Show("There are unsaved changes. Save them?", "Unsaved Settings Changes", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1);
                if (_Dr == DialogResult.Yes)
                {
                    Properties.Settings.Default.Save();
                }
                else
                {
                    // Restore the previously persisted values.
                    Properties.Settings.Default.Reload();
                }
                _settingsChanged = false;
            }
            return(true);
        }

        private void saveButton_Click(object sender, System.EventArgs e)
        {
            Properties.Settings.Default.Save();
        }

        private void testSoundButton_Click(object sender, System.EventArgs e)
        {
            if ((soundFileText.Text.Length > 0 & File.Exists(soundFileText.Text)))
            {
                _player.SoundLocation = soundFileText.Text;
                _player.Play();
            }
        }

        private void soundFileText_TextChanged(object sender, System.EventArgs e)
        {
            if ((soundFileText.Text.Length > 0))
            {
                testSoundButton.Enabled = true;
            }
            else
            {
                testSoundButton.Enabled = false;
            }
        }
    }
}
