//---------------------------------------------------------------------
//  Copyright (C) Microsoft Corporation.  All rights reserved.
// 
//THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
//KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
//PARTICULAR PURPOSE.
//---------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Reflection;
using System.Runtime.Remoting;

namespace CountDownCSharp
{
    public partial class Form1 : Form
    {
        String _dataDirectory = null;

        private Point _mouseOffset;
        private bool _isMouseDown = false;
        private ToolStripButton _currentClickedButton = null;
        private Control _currentControl;

        public Form1()
        {
            InitializeComponent();

            appCloseButton.Click += new EventHandler(appCloseButton_Click);
            appMinimizeButton.Click += new EventHandler(appMinimizeButton_Click);
            titleStrip.MouseDown += new MouseEventHandler(titleStrip_MouseDown);
            titleStrip.MouseMove += new MouseEventHandler(titleStrip_MouseMove);
            titleStrip.MouseUp += new MouseEventHandler(titleStrip_MouseUp);

            foreach (ToolStripItem item in NavStrip.Items)
            {
                if (item is ToolStripButton)
                {
                    ToolStripButton button = (ToolStripButton)item;
                    button.MouseDown += new MouseEventHandler(ToolStripButton_MouseDown);
                }
            }

             _dataDirectory = My.Application.DataDirectory;
            slideshow1.ImagePath = _dataDirectory + "\\images";
            slideshow1.StartSlideshow(6000, true);

            if (Properties.Settings.Default.SoundFile.Length == 0 | !File.Exists(Properties.Settings.Default.SoundFile))
            {
                Properties.Settings.Default.SoundFile = _dataDirectory + "\\sounds\\CountdownFinished.wav";
                Properties.Settings.Default.Save();
            }
            toolStripLabel1.Text = this.Text;
            CDHomePanel homePanel = new CDHomePanel();
            homePanel.Tag = "Countdown.CDHomePanel";
            homePanel.Dock = DockStyle.Fill;
            splitContainer1.Panel1.Controls.Add(homePanel);
            _currentControl = homePanel;
            _currentClickedButton = HomeButton;
        }

        private void appCloseButton_Click(object sender, System.EventArgs e)
        {
            this.Close();
        }

        private void appMinimizeButton_Click(object sender, System.EventArgs e)
        {
            this.WindowState = FormWindowState.Minimized;
        }

        private void titleStrip_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            if (e.Button == System.Windows.Forms.MouseButtons.Left)
            {
                _mouseOffset = new Point(e.X, e.Y);
                _isMouseDown = true;
                titleStrip.Capture = true;
            }
        }

        private void titleStrip_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            if (_isMouseDown)
            {
                Point _currentPos = Control.MousePosition;
                _currentPos.X = _currentPos.X - _mouseOffset.X;
                _currentPos.Y = _currentPos.Y - _mouseOffset.Y;
                this.Location = _currentPos;
            }
        }

        private void titleStrip_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            if (e.Button == System.Windows.Forms.MouseButtons.Left)
            {
                _isMouseDown = false;
                titleStrip.Capture = false;
            }
        }

        // The Settings panel might have unsaved data on it, and the Countdown panel
        // will want to cancel the meditation clock if the user navigates to a new
        // panel. Handle the mouse down, and determine if the application 
        // should navigate away from this panel or cancel the click.
        private void ToolStripButton_MouseDown(object sender, MouseEventArgs e)
        {
            if ((_currentControl is IPanelNavigating))
            {
                IPanelNavigating _canNavigate = (IPanelNavigating)_currentControl;
                if ((_canNavigate.CanNavigate()))
                {
                    Navigate(sender);
                }
            }
            else
            {
                Navigate(sender);
            }
        }

        private void Navigate(Object sender)
        {
            Control _newControl;
            //  TODO: Error handling!
            ToolStripButton _currentButton = (ToolStripButton)sender;
            String _controlName =_currentButton.Tag.ToString();

            // Uncheck the previous clicked button.
            _currentClickedButton.Checked = false;
            _currentClickedButton = _currentButton;

            // First, make sure this isn't a redundant event - is the control already displayed?
            if (!(_controlName == _currentControl.Name))
            {
                // Get the control to use, and instantiate it dynamically if it isn't already defined.
                _newControl = splitContainer1.Panel1.Controls[_controlName];
                if (_newControl == null) 
                {
                    //Control not found - instantiate it.
                    ObjectHandle _oh = AppDomain.CurrentDomain.CreateInstance(Assembly.GetExecutingAssembly().FullName, _controlName);
                    _newControl = (Control)_oh.Unwrap();
                    _newControl.Name = _controlName;
                    _newControl.Dock = DockStyle.Fill;
                    splitContainer1.Panel1.Controls.Add(_newControl);
                }

            // Hide the old control, and show the new one. 
            _currentControl.Visible = false;
            _newControl.Visible = true;
            _currentControl = _newControl;
            }
        }
   }
}