//---------------------------------------------------------------------
//  Copyright (C) Microsoft Corporation.  All rights reserved.
// 
//THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
//KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
//PARTICULAR PURPOSE.
//---------------------------------------------------------------------

using System;
using System.Collections.Generic;
using WindowsForms = System.Windows.Forms;
using System.Deployment.Application;
using System.IO;
using System.Xml;

namespace CountDownCSharp
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            ApplicationStartup();

            WindowsForms.Application.EnableVisualStyles();
            WindowsForms.Application.SetCompatibleTextRenderingDefault(false);
            WindowsForms.Application.Run(new Form1());
        }

        static void ApplicationStartup()
        {

        }
    }

    public static class My
    {
        private static MyApplication defaultInstance = new CountDownCSharp.MyApplication();

        public static MyApplication Application
        {
            get
            {
                return (defaultInstance);
            }
        }
    }

    public class MyApplication
    {
        XmlDocument _xmlDoc = null;
        bool _logFileAvailable = false;
        String _dataDirectory = null;

        public MyApplication()
        {
            OpenLogFile();
        }

        public void OpenLogFile()
        {
            string _dataDir = DataDirectory;
            if ((!(File.Exists(_dataDir + "\\log.xml"))))
            {
                try
                {
                    _xmlDoc = new XmlDocument();
                    XmlElement _elem = _xmlDoc.CreateElement("Countdown");
                    _xmlDoc.AppendChild(_elem);
                    XmlElement _ChildElem = _xmlDoc.CreateElement("Sessions");
                    _elem.AppendChild(_ChildElem);
                    WriteXmlFile();
                }
                catch (Exception ex)
                {
                    // TODO Log the error
                    // For now, make sure no one touches the log file if it can't be opened for writing.
                    _logFileAvailable = false;
                }
            }
            else
            {
                _xmlDoc = new XmlDocument();
                _xmlDoc.Load(_dataDir + "\\log.xml");
            }
        }

        public string GetDataDirectory()
        {
            string _pathStr;
            if (ApplicationDeployment.IsNetworkDeployed)
            {
                _pathStr = WindowsForms.Application.UserAppDataPath;
            }
            else
            {
                _pathStr = WindowsForms.Application.ExecutablePath.Substring(0, WindowsForms.Application.ExecutablePath.LastIndexOf("\\"));
                if (!Directory.Exists(_pathStr + "\\images"))
                {
                    _pathStr = _pathStr + "\\..\\..";
                    if (!Directory.Exists(_pathStr + "\\images"))
                    {
                        throw new DirectoryNotFoundException("Cannot find directory " + _pathStr + "\\images. Fatal error.");
                    }
                }
            }
            return (_pathStr);
        }

        // Let all errors bubble up. 
        private void WriteXmlFile()
        {
            XmlWriter _writer = XmlWriter.Create(DataDirectory + "\\log.xml");
            _xmlDoc.WriteTo(_writer);
            _writer.Close();
        }

        public string DataDirectory
        {
            get
            {
                if ((_dataDirectory == null))
                {
                    _dataDirectory = GetDataDirectory();
                    return (_dataDirectory);
                }
                else
                {
                    return (_dataDirectory);
                }
            }
        }

        public bool LogFileAvailable
        {
            get
            {
                return (_logFileAvailable);
            }
        }

        public void AddLogFileEntry(DateTime startTime, int hours, int minutes, int seconds)
        {
            if (_logFileAvailable)
            {
                XmlElement _elem = (XmlElement)_xmlDoc.SelectSingleNode("Countdown/Sessions");
                XmlElement _sessionElem = _xmlDoc.CreateElement("Session");
                _elem.AppendChild(_sessionElem);
                XmlElement _subElem = (XmlElement)_xmlDoc.CreateElement("StartDate");
                _subElem.InnerText = startTime.ToShortDateString();
                _sessionElem.AppendChild(_subElem);
                _subElem = _xmlDoc.CreateElement("StartTime");
                _subElem.InnerText = startTime.ToShortTimeString();
                _sessionElem.AppendChild(_subElem);
                _subElem = (XmlElement)_xmlDoc.CreateElement("HourDuration");
                _subElem.InnerText = hours.ToString();
                _sessionElem.AppendChild(_subElem);
                _subElem = (XmlElement)_xmlDoc.CreateElement("MinuteDuration");
                _subElem.InnerText = minutes.ToString();
                _sessionElem.AppendChild(_subElem);
                _subElem = (XmlElement)_xmlDoc.CreateElement("SecondDuration");
                _subElem.InnerText = seconds.ToString();
                _sessionElem.AppendChild(_subElem);
                WriteXmlFile();
            }
        }
    }
}