//---------------------------------------------------------------------
//  Copyright (C) Microsoft Corporation.  All rights reserved.
// 
//THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
//KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
//PARTICULAR PURPOSE.
//---------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Security.Permissions;

namespace CountDownCSharp
{
    public partial class Slideshow : UserControl
    {
        private string _imageFolderPath;

        private int _currentImage = 0;

        private string[] _files;

        private bool _loop = true;

        private Dictionary<String,int> _allowedExtensions;

        [SecurityPermission(SecurityAction.Demand, Unrestricted = true)]
        public Slideshow() : base()
        {
            InitializeComponent();

            this._allowedExtensions = new Dictionary<String, int>();
            _allowedExtensions.Add("jpg", 1);
            _allowedExtensions.Add("jpeg", 1);
            _allowedExtensions.Add("gif", 1);
            _allowedExtensions.Add("png", 1);
            _allowedExtensions.Add("tif", 1);
            _allowedExtensions.Add("tiff", 1);

            // Event wiring.
            imageSlideTimer.Tick += new EventHandler(imageSlideTimer_Tick);
        }

        public string ImagePath
        {
            get
            {
                return _imageFolderPath;
            }
            set
            {
                if ((Directory.Exists(value)
                            || (value == null)))
                {
                    _imageFolderPath = value;
                }
                else
                {
                    throw new System.IO.FileNotFoundException("Directory does not exist.");
                }
            }
        }

        [SecurityPermission(SecurityAction.Demand, Unrestricted = true)]
        public void StartSlideshow(int milliSeconds, bool LoopSlideshow) {
        if ((_imageFolderPath == null)) {
            throw new ArgumentException("You must set a valid value for ImagePath first.");
        }
        //  Load up the array of images through which to cycle.
        string[] _filesTmp = Directory.GetFiles(this._imageFolderPath);
        List<String> _tmpArray = new List<String>();
        //  Remove elements that aren't images.
        foreach (string _file in _filesTmp) {
            string _ext = _file.Substring((_file.LastIndexOf(".") + 1)).ToLower();
            if (this._allowedExtensions.ContainsKey(_ext)) {
                _tmpArray.Add(_file);
            }
        }
        _files = _tmpArray.ToArray();
        _loop = LoopSlideshow;
        //  Load up the initial page. The application will manipulate the page by making JavaScript calls using HtmlDocument's
        //  InvokeScript() method.
        webBrowser1.DocumentText = "<HTML>" + "\n" +
"<script type=\"text/javascript\">" + "\n" +
"function transitionImage(newImg){" + "\n" +
        "var imgObject = document.getElementById(\"ourImage\");" + "\n" +
        "imgObject.filters[0].apply();" + "\n" +
        "imgObject.src = newImg;" + "\n" +
     "imgObject.filters[0].play();" + "\n" +
"}</script>" + "\n" +
"<BODY><IMG src=\"" + GetNextImage() +
"\" id=\"ourImage\" style=\"position:absolute;top:0px;left:0px;filter:progid:DXImageTransform.Microsoft.RandomDissolve(Duration=2);" +
"width:" + webBrowser1.Width + ";height:" + webBrowser1.Height + ";\"></BODY></HTML>";
        //  Start the timer.
        this.imageSlideTimer.Interval = milliSeconds;
        this.imageSlideTimer.Start();
    }

        public void StopSlideshow()
        {
            this.imageSlideTimer.Stop();
        }

        private string GetNextImage()
        {
            string _uriStr = null;
            if ((_currentImage == _files.Length))
            {
                if (_loop)
                {
                    _currentImage = 0;
                }
                else
                {
                    //  That was it - time to bail. 
                    StopSlideshow();
                }
            }
            _uriStr = _files[_currentImage];
            _currentImage++;
            return _uriStr;
        }

        private void imageSlideTimer_Tick(object sender, System.EventArgs e)
        {
            string UriStr = GetNextImage();
            //  Create transition page for image.
            string[] args = new string[2];
            args[0] = UriStr;
            webBrowser1.Document.InvokeScript("transitionImage", args);
        }
    }
}
