//---------------------------------------------------------------------
//  Copyright (C) Microsoft Corporation.  All rights reserved.
 
//THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
//KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
//PARTICULAR PURPOSE.
//---------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;

namespace CountDownCSharp
{
    public partial class ViewCountdownLog : Form
    {
        public ViewCountdownLog()
        {
            InitializeComponent();
        }

        private void ViewCountdownLog_Load(object sender, System.EventArgs e)
        {
            XmlDocument _Data = new XmlDocument();
            _Data.Load(My.Application.DataDirectory + "\\log.xml");
            foreach (XmlElement _Elem in _Data.SelectNodes("Countdown/Sessions/Session"))
            {
                string _Duration = _Elem.SelectSingleNode("HourDuration").InnerText + "h " + _Elem.SelectSingleNode("MinuteDuration").InnerText + "m " + _Elem.SelectSingleNode("SecondDuration").InnerText + "s";
                DataGridView1.Rows.Add(_Elem.SelectSingleNode("StartDate").InnerText, _Elem.SelectSingleNode("StartTime").InnerText, _Duration);
            }
        }
    }
}