using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace TestPanelFlyout
{
    public partial class CollapsibleControl : UserControl
    {
        private List<CollapsibleControlSection> SectionList;
        int _cControlCounter = 0;

        public CollapsibleControl()
        {
            InitializeComponent();
            SectionList = new List<CollapsibleControlSection>();
        }

        public void AddSection(CollapsibleControlSection newSection)
        {
            SectionList.Add(newSection);
            // Add a new row. 
            ListHeader header = new ListHeader();
            header.Text = newSection.SectionName;
            header.Width = this.Width;
            header.ListHeaderStateChanged += new ListHeaderStateChangedEventHandler(header_ListHeaderStateChanged);
            flowLayoutPanel1.Controls.Add(header);
            // Get the position of the control the application will add, so that it can show 
            // and hide it when needed.
            header.Tag = "CollapsibleControl" + _cControlCounter;
            _cControlCounter++;

            Control c = newSection.SectionControl;
            c.Width = this.Width;
            c.Name = header.Tag.ToString();
            flowLayoutPanel1.Controls.Add(c);
        }

        // Handle the change in the list. 
        void header_ListHeaderStateChanged(object sender, ListHeaderStateChangedEventArgs e)
        {
            ListHeader header = (ListHeader)sender;
            Control c = flowLayoutPanel1.Controls[(string)header.Tag];

            if (e.State == ListHeaderState.Collapsed)
            {
                c.Hide();
            }
            else
            {
                c.Show();
            }
        }

        public void TestHidingControl()
        {
            flowLayoutPanel1.Controls[1].Hide();
        }

        public void TestShowingControl()
        {
            flowLayoutPanel1.Controls[1].Show();
        }
    }

    public class CollapsibleControlSection : Object
    {
        private string _sectionName = null;
        private Control _control = null;

        public CollapsibleControlSection(string sectionName, Control control) : base()
        {
            _sectionName = sectionName;
            _control = control;
        }

        public string SectionName
        {
            get { return(_sectionName); }
            set { _sectionName = value; }
        }

        public Control SectionControl
        {
            get { return (_control); }
            set { _control = value; }
        }
    }
}
