using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Reflection;
using System.Runtime.Remoting;

namespace TestPanelFlyout
{
    public partial class Form1 : Form
    {
        bool _doFade = false;
        bool _haveProcessedMouseEnter = false;
        Control _currentControl = null;

        public Form1()
        {
            InitializeComponent();

            toolBoxLabel.MouseEnter += new EventHandler(toolBoxLabel_MouseEnter);
            toolBoxLabel.MouseLeave += new EventHandler(toolBoxLabel_MouseLeave);
        }

        void toolBoxLabel_MouseEnter(object sender, EventArgs e)
        {
            if (!_haveProcessedMouseEnter)
            {
                _haveProcessedMouseEnter = true;

                // Make sure the panel is not still fading. If it is fading, it means the user has re-entered the
                // label area during fade processing. In that case, reverse course and show the panel instead.
                if (_doFade)
                {
                    panelTimer.Stop();
                    _doFade = false;
                } else if (_currentControl == null)
                {
                    // Get the control to use, and instantiate it dynamically.
                    string controlName = ((ToolStripLabel)sender).Tag.ToString();
                    ObjectHandle oh = AppDomain.CurrentDomain.CreateInstance(Assembly.GetExecutingAssembly().FullName, controlName);
                    _currentControl = (Control)oh.Unwrap();
                    _currentControl.Height = this.Height;
                    _currentControl.Location = new Point((toolStrip1.Location.X + toolStrip1.Width) - _currentControl.Width, 0);

                    this.SuspendLayout();
                    this.Controls.Add(_currentControl);

                    // The following calls make the panel appear above all other controls on the form,
                    // *except* the ToolStrip with the panel buttons.
                    _currentControl.BringToFront();
                    toolStrip1.BringToFront();

                    this.ResumeLayout();
                }

                panelTimer.Start();
            }
        }

        void toolBoxLabel_MouseLeave(object sender, EventArgs e)
        {
            // Slight problem: The application could be transitioning between the ToolStrip and the flyout panel. If the
            // mouse is in an inbetween state where it's not over the ToolStripLabel but *is* over the
            // thin wedge of the ToolStrip itself, the application can fade erroneously. Kick off this
            // timer to give the user time to transition. The delay built into VS is about 1 second; that 
            // should work here.
            mouseLeaveTimer.Start();
        }

        private void panelTimer_Tick(object sender, EventArgs e)
        {
            if (_doFade)
            {
                // Hide the panel.
                if (_currentControl.Location.X + _currentControl.Size.Width > toolStrip1.Location.X + toolStrip1.Width)
                {
                    _currentControl.Location = new Point(_currentControl.Location.X - 10, _currentControl.Location.Y);
                }
                else
                {
                    panelTimer.Stop();
                    _haveProcessedMouseEnter = false;
                    _doFade = false;
                }
            }
            else
            {
                // Show the panel.
                if (_currentControl.Location.X < toolStrip1.Location.X + toolStrip1.Width)
                {
                    _currentControl.Location = new Point(_currentControl.Location.X + 10, _currentControl.Location.Y);
                }
                else
                {
                    panelTimer.Stop();
                    _haveProcessedMouseEnter = false;
                    _doFade = true;
                }
            }
        }

        private void mouseLeaveTimer_Tick(object sender, EventArgs e)
        {
            // If the mouse is over the flyout panel, don't trigger the leave event. 
            Control controlUnderMouse = this.GetChildAtPoint(this.PointToClient(Cursor.Position));
            // This may retrieve whatever child control is under the ToolStrip. Inspect 
            // parent controls until we reach the Form. If the application doesn;t find a control that matches
            // currentControl in the parenting chain, fade.
            bool overPanel = false;
            while (controlUnderMouse != this)
            {
                // If the mouse is over the blank form area, controlOverMouse will be null.
                if (controlUnderMouse == null)
                {
                    overPanel = false;
                    break;
                }

                if (controlUnderMouse == _currentControl)
                {
                    overPanel = true;
                    break;
                }

                controlUnderMouse = controlUnderMouse.Parent;
            }

            if (!overPanel)
            {
                mouseLeaveTimer.Stop();
                panelTimer.Start();
            }
        }
    }
}